/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache.cache;

import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.listener.CSIDListener;
import org.apache.linkis.cs.listener.ListenerBus.ContextAsyncListenerBus;
import org.apache.linkis.cs.listener.event.ContextIDEvent;
import org.apache.linkis.cs.listener.manager.imp.DefaultContextListenerManager;
import org.apache.linkis.cs.persistence.entity.PersistenceContextID;
import org.apache.linkis.cs.persistence.persistence.ContextIDPersistence;
import org.apache.linkis.cs.persistence.persistence.ContextMapPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultContextAddListener
implements CSIDListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextAddListener.class);
    private ContextAsyncListenerBus listenerBus = DefaultContextListenerManager.getInstance().getContextAsyncListenerBus();
    @Autowired
    private ContextIDPersistence contextIDPersistence;
    @Autowired
    private ContextMapPersistence contextMapPersistence;

    @PostConstruct
    private void init() {
        this.listenerBus.addListener((EventListener)this);
    }

    public void onEventError(Event event, Throwable t) {
    }

    public void onCSIDAccess(ContextIDEvent contextIDEvent) {
    }

    public void onCSIDADD(ContextIDEvent contextIDEvent) {
        try {
            PersistenceContextID pContextID = new PersistenceContextID();
            pContextID.setContextId(contextIDEvent.getContextID().getContextId());
            pContextID.setAccessTime(new Date());
            this.contextIDPersistence.updateContextID((ContextID)pContextID);
            if (logger.isDebugEnabled()) {
                logger.debug("Updated accesstime for contextID : {}", (Object)contextIDEvent.getContextID().getContextId());
            }
        }
        catch (Exception e) {
            logger.error("Update context accessTime failed, {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void onCSIDRemoved(ContextIDEvent contextIDEvent) {
    }

    public void onEvent(Event event) {
    }
}

