/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.contextcache;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.contextcache.ContextCacheService;
import org.apache.linkis.cs.contextcache.cache.ContextCache;
import org.apache.linkis.cs.contextcache.cache.csid.ContextIDValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultContextCacheService
implements ContextCacheService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContextCacheService.class);
    @Autowired
    private ContextCache contextCache;

    @Override
    public ContextKeyValue put(ContextID contextID, ContextKeyValue csKeyValue) throws CSErrorException {
        if (null == contextID || null == csKeyValue) {
            return null;
        }
        logger.info("Start to put contextKey({}) to ContextID({})", (Object)csKeyValue.getContextKey().getKey(), (Object)contextID.getContextId());
        ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
        ContextKeyValue oldValue = contextIDValue.getContextKeyValueContext().put(csKeyValue);
        logger.info("Finished to put contextKey({}) to ContextID({})", (Object)csKeyValue.getContextKey().getKey(), (Object)contextID.getContextId());
        return oldValue;
    }

    @Override
    public ContextKeyValue rest(ContextID contextID, ContextKey csKey) {
        if (null == contextID || null == csKey) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            return contextIDValue.getContextKeyValueContext().remove(csKey);
        }
        catch (Exception e) {
            logger.error("Failed to rest contextID({}) of csKey({})", new Object[]{contextID.getContextId(), csKey.getKey(), e});
            return null;
        }
    }

    @Override
    public ContextKeyValue get(ContextID contextID, ContextKey csKey) {
        if (null == contextID || null == csKey) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            return contextIDValue.getContextKeyValueContext().getContextKeyValue(csKey, csKey.getContextType());
        }
        catch (Exception e) {
            logger.error("Failed to get contextID({}) of csKey({})", new Object[]{contextID.getContextId(), csKey.getKey(), e});
            return null;
        }
    }

    @Override
    public List<ContextKeyValue> getValues(ContextID contextID, String keyword, ContextType csType) {
        if (null == contextID || StringUtils.isBlank((CharSequence)keyword)) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            return contextIDValue.getContextKeyValueContext().getValues(keyword, csType);
        }
        catch (Exception e) {
            logger.error("Failed to get values contextID({}) of keyword({})", new Object[]{contextID.getContextId(), keyword, e});
            return null;
        }
    }

    @Override
    public List<ContextKeyValue> getAllLikes(ContextID contextID, String regex, ContextType csType) {
        if (null == contextID || StringUtils.isBlank((CharSequence)regex)) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            return contextIDValue.getContextKeyValueContext().getAllLikes(regex, csType);
        }
        catch (Exception e) {
            logger.error("Failed to getAllLikes contextID({}) of regex({})", new Object[]{contextID.getContextId(), regex, e});
            return null;
        }
    }

    @Override
    public List<ContextKeyValue> getAll(ContextID contextID) {
        if (null == contextID) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            return contextIDValue.getContextKeyValueContext().getAll();
        }
        catch (Exception e) {
            logger.error("Failed to getAllByType contextID({})", (Object)contextID.getContextId(), (Object)e);
            return null;
        }
    }

    @Override
    public List<ContextKeyValue> getAllByScope(ContextID contextID, ContextScope scope, ContextType csType) {
        if (null == contextID && null == scope) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            List<ContextKeyValue> valueCSTypeList = contextIDValue.getContextKeyValueContext().getAllValues(csType);
            if (CollectionUtils.isNotEmpty(valueCSTypeList)) {
                return valueCSTypeList.stream().filter(contextKeyValue -> scope.equals((Object)contextKeyValue.getContextKey().getContextScope())).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.error("Failed to getAllByScope contextID({}) of ContextScope({}) of csType({})", new Object[]{contextID.getContextId(), scope, csType, e});
        }
        return null;
    }

    @Override
    public List<ContextKeyValue> getAllByType(ContextID contextID, ContextType csType) {
        if (null == contextID || StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            List<ContextKeyValue> allValues = contextIDValue.getContextKeyValueContext().getAllValues(csType);
            return allValues;
        }
        catch (Exception e) {
            logger.error("Failed to getAllByType contextID({}) of csType({})", new Object[]{contextID.getContextId(), csType, e});
            return null;
        }
    }

    @Override
    public ContextKeyValue remove(ContextID contextID, ContextKey csKey) {
        if (null == contextID || csKey == null) {
            return null;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            return contextIDValue.getContextKeyValueContext().remove(csKey);
        }
        catch (Exception e) {
            logger.error("Failed to remove contextID({}) of csKey({})", new Object[]{contextID.getContextId(), csKey.getKey(), e});
            return null;
        }
    }

    @Override
    public void removeAll(ContextID contextID) {
        if (null == contextID) {
            return;
        }
        try {
            this.contextCache.remove(contextID);
        }
        catch (Exception e) {
            logger.error("Failed to removeAll contextID({})", (Object)contextID.getContextId(), (Object)e);
        }
    }

    @Override
    public void removeAll(ContextID contextID, ContextScope scope, ContextType csType) {
    }

    @Override
    public void removeAll(ContextID contextID, ContextType csType) {
        if (null == contextID) {
            return;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            contextIDValue.getContextKeyValueContext().removeAll(csType);
        }
        catch (Exception e) {
            logger.error("Failed to removeAll contextID({}) of csType({})", new Object[]{contextID.getContextId(), csType, e});
        }
    }

    @Override
    public void removeByKeyPrefix(ContextID contextID, String preFix) {
        if (null == contextID || StringUtils.isBlank((CharSequence)preFix)) {
            return;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            contextIDValue.getContextKeyValueContext().removeByKeyPrefix(preFix);
        }
        catch (Exception e) {
            logger.error("Failed to removeByKeyPrefix contextID({}) of key preFix({})", new Object[]{contextID.getContextId(), preFix, e});
        }
    }

    @Override
    public void removeByKeyPrefix(ContextID contextID, String preFix, ContextType csType) {
        if (null == contextID || StringUtils.isBlank((CharSequence)preFix) || null == csType) {
            return;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            contextIDValue.getContextKeyValueContext().removeByKeyPrefix(preFix, csType);
        }
        catch (Exception e) {
            logger.error("Failed to removeByKeyPrefix contextID({}) of key preFix({}) and csyTye({})", new Object[]{contextID.getContextId(), preFix, csType.name(), e});
        }
    }

    @Override
    public void removeByKey(ContextID contextID, String keyStr, ContextType csType) {
        if (null == contextID || StringUtils.isBlank((CharSequence)keyStr) || null == csType) {
            return;
        }
        try {
            ContextIDValue contextIDValue = this.contextCache.getContextIDValue(contextID);
            contextIDValue.getContextKeyValueContext().removeByKey(keyStr, csType);
        }
        catch (Exception e) {
            logger.error("Failed to removeByKey contextID({}) of key keyStr({}) and csyTye({})", new Object[]{contextID.getContextId(), keyStr, csType.name(), e});
        }
    }
}

