/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.service.impl;

import org.apache.linkis.configuration.entity.UserIpVo;
import org.apache.linkis.configuration.service.UserIpConfigService;
import org.apache.linkis.configuration.service.UserIpService;
import org.apache.linkis.governance.common.protocol.conf.UserIpRequest;
import org.apache.linkis.governance.common.protocol.conf.UserIpResponse;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserIpServiceImpl
implements UserIpService {
    private static final Logger logger = LoggerFactory.getLogger(UserIpService.class);
    @Autowired
    private UserIpConfigService userIpConfigService;

    @Override
    @Receiver
    public UserIpResponse getUserIpData(UserIpRequest request, Sender sender) {
        UserIpVo userIpVo = this.userIpConfigService.queryUserIP(request.user(), request.creator());
        if (null == userIpVo) {
            logger.warn("UserIpCache user {} creator {} data loading failed", (Object)request.user(), (Object)request.creator());
            return new UserIpResponse(request.user(), request.creator(), "");
        }
        return new UserIpResponse(userIpVo.getUser(), userIpVo.getCreator(), userIpVo.getIpList());
    }
}

