/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.configuration.errorcode;

import org.apache.linkis.common.errorcode.ErrorCodeUtils;
import org.apache.linkis.common.errorcode.LinkisErrorCode;

public enum LinkisConfigurationErrorCodeSummary implements LinkisErrorCode
{
    BUILD_LABEL_ID(14100, ""),
    CONFIGURATION_NOT_TYPE(14100, "Configuration does not support engine type:{0}(\u914d\u7f6e\u6682\u4e0d\u652f\u6301{0}\u5f15\u64ce\u7c7b\u578b)"),
    CORRESPONDING_ENGINE_TYPE(14100, "The corresponding engine type is not matched:{0}(\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u5f15\u64ce\u7c7b\u578b:{0})"),
    FAILED_TO_BUILD_LABEL(14100, "Failed to build label(\u5efa\u7acb\u6807\u7b7e\u5931\u8d25)"),
    BUILD_LABEL_IS_NULL(14100, "Failed to build label ,label is null(\u5efa\u7acb\u6807\u7b7e\u5931\u8d25\uff0c\u6807\u7b7e\u4e3a\u7a7a)"),
    CONFIGKEY_CANNOT_BE_NULL(14100, "ConfigKey cannot be null(configKey \u4e0d\u80fd\u4e3a\u7a7a)"),
    CONFIG_KEY_NOT_EXISTS(14100, "Config key not exists:{0}(\u914d\u7f6e\u952e\u4e0d\u5b58\u5728\uff1a{0})"),
    LABEL_NOT_EXISTS(14100, "Label not exists:{0}(\u6807\u7b7e\u4e0d\u5b58\u5728{0})"),
    KEY_CANNOT_EMPTY(14100, "Key cannot be null(Key \u4e0d\u80fd\u4e3a\u7a7a)"),
    PARAMS_CANNOT_BE_EMPTY(14100, "Params cannot be empty!(\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01)"),
    TOKEN_IS_ERROR(14100, "Token is error(\u4ee4\u724c\u662f\u9519\u8bef\u7684)"),
    IS_NULL_CANNOT_BE_ADDED(14100, "CategoryName is null, cannot be added(categoryName \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0)"),
    CANNOT_BE_INCLUDED(14100, "CategoryName cannot be included '-'(\u7c7b\u522b\u540d\u79f0\u4e0d\u80fd\u5305\u542b '-')"),
    CREATOR_IS_NULL_CANNOT_BE_ADDED(14100, "Creator is null, cannot be added(\u521b\u5efa\u8005\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0)"),
    ENGINE_TYPE_IS_NULL(14100, "Engine type is null, cannot be added(\u5f15\u64ce\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6dfb\u52a0)"),
    INCORRECT_FIXED_SUCH(14100, "The saved engine type parameter is incorrect, please send it in a fixed format, such as spark-2.4.3(\u4fdd\u5b58\u7684\u5f15\u64ce\u7c7b\u578b\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u6309\u7167\u56fa\u5b9a\u683c\u5f0f\u4f20\u9001\uff0c\u4f8b\u5982spark-2.4.3)"),
    INCOMPLETE_RECONFIRM(14100, "Incomplete request parameters, please reconfirm(\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4)"),
    ONLY_ADMIN_PERFORM(14100, "Only admin have permission to perform this operation(\u9650\u7ba1\u7406\u5458\u6267\u884c\u6b64\u64cd\u4f5c)"),
    THE_LABEL_PARAMETER_IS_EMPTY(14100, " The label parameter is empty(\u6807\u7b7e\u53c2\u6570\u4e3a\u7a7a)"),
    ERROR_VALIDATOR_RANGE(14100, "Error validator range\uff01(\u9519\u8bef\u9a8c\u8bc1\u5668\u8303\u56f4\uff01)"),
    TYPE_OF_LABEL_NOT_SUPPORTED(14100, "This type of label is not supported:{0}(\u4e0d\u652f\u6301\u8fd9\u79cd\u7c7b\u578b\u7684\u6807\u7b7e\uff1a{0})");

    private final int errorCode;
    private final String errorDesc;

    private LinkisConfigurationErrorCodeSummary(int errorCode, String errorDesc) {
        ErrorCodeUtils.validateErrorCode((int)errorCode, (int)10000, (int)24999);
        this.errorCode = errorCode;
        this.errorDesc = errorDesc;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }
}

