/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.once;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.entity.job.Job;
import org.apache.linkis.cli.application.entity.job.JobResult;
import org.apache.linkis.cli.application.entity.job.JobStatus;
import org.apache.linkis.cli.application.interactor.job.once.OnceJobResult;
import org.apache.linkis.cli.application.operator.OperManager;
import org.apache.linkis.cli.application.operator.once.OnceJobOper;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.apache.linkis.cli.application.utils.SchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisOnceJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(LinkisOnceJob.class);
    private Boolean isAsync = false;
    private OnceJobOper oper;

    @Override
    public void build(CliCtx ctx) {
        this.isAsync = ctx.getVarAccess().getVarOrDefault(Boolean.class, "wds.linkis.client.common.async.submit", false);
        this.oper = (OnceJobOper)OperManager.getNew("linkis.once", ctx);
    }

    @Override
    public JobResult run() {
        StringBuilder infoBuilder = new StringBuilder();
        infoBuilder.append("connecting to linkis gateway:").append(this.oper.getServerUrl());
        LoggerManager.getInformationLogger().info(infoBuilder.toString());
        this.oper.submit();
        JobStatus jobStatus = this.oper.getStatus();
        infoBuilder.setLength(0);
        infoBuilder.append("JobId:").append(this.oper.getJobID()).append(System.lineSeparator());
        LoggerManager.getPlaintTextLogger().info(infoBuilder.toString());
        if (this.isAsync.booleanValue() && jobStatus != null && jobStatus.isJobSubmitted()) {
            return new OnceJobResult(true, "Submit Success!!!", new HashMap<String, String>());
        }
        CountDownLatch latch = new CountDownLatch(1);
        try {
            Thread logConsumer = new Thread(() -> this.ProcessLog(latch), "Log-Consumer");
            SchedulerManager.getCachedThreadPoolExecutor().execute(logConsumer);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve log", (Throwable)e);
        }
        this.oper.waitForComplete();
        try {
            latch.await();
        }
        catch (Exception e) {
            // empty catch block
        }
        JobStatus finalStatus = this.oper.getStatus();
        if (finalStatus.isJobSuccess()) {
            return new OnceJobResult(true, "Execute Success!!!", new HashMap<String, String>());
        }
        return new OnceJobResult(false, "Execute Failure!!!", new HashMap<String, String>());
    }

    @Override
    public void onDestroy() {
        this.oper.kill();
    }

    private void ProcessLog(CountDownLatch latch) {
        while (!this.oper.isLogFin().booleanValue()) {
            String log = this.oper.getCurrentLog();
            LoggerManager.getPlaintTextLogger().info(log);
            CliUtils.doSleepQuietly(2000L);
        }
        latch.countDown();
    }
}

