/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.bml.common.ResourceHelper;
import org.apache.linkis.bml.common.ResourceHelperFactory;
import org.apache.linkis.bml.dao.ResourceDao;
import org.apache.linkis.bml.dao.VersionDao;
import org.apache.linkis.bml.entity.Resource;
import org.apache.linkis.bml.entity.ResourceVersion;
import org.apache.linkis.bml.service.ResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ResourceServiceImpl
implements ResourceService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceServiceImpl.class);
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private VersionDao versionDao;
    private static final String FIRST_VERSION = "v000001";

    @Override
    public List<Resource> getResources(Map paramMap) {
        return this.resourceDao.getResources(paramMap);
    }

    @Override
    public void deleteResource(String resourceId) {
        this.resourceDao.deleteResource(resourceId);
        this.versionDao.deleteResource(resourceId);
    }

    @Override
    public void batchDeleteResources(List<String> resourceIds) {
        this.resourceDao.batchDeleteResources(resourceIds);
        this.versionDao.batchDeleteResources(resourceIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<UploadResult> upload(List<MultipartFile> files, String user, Map<String, Object> properties) throws Exception {
        ResourceHelper resourceHelper = ResourceHelperFactory.getResourceHelper();
        ArrayList<UploadResult> results = new ArrayList<UploadResult>();
        for (MultipartFile p : files) {
            String resourceId = (String)properties.get("resourceId");
            InputStream inputStream = p.getInputStream();
            String fileName = resourceId;
            String path = resourceHelper.generatePath(user, fileName, properties);
            StringBuilder sb = new StringBuilder();
            long size = resourceHelper.upload(path, user, inputStream, sb, true);
            String md5String = sb.toString();
            boolean isSuccess = false;
            if (StringUtils.isNotEmpty((CharSequence)md5String) && size >= 0L) {
                isSuccess = true;
            }
            Resource resource = Resource.createNewResource(resourceId, user, fileName, properties);
            long id = this.resourceDao.uploadResource(resource);
            logger.info("{} uploaded a resource and resourceId is {}", (Object)user, (Object)resource.getResourceId());
            String clientIp = (String)properties.get("clientIp");
            ResourceVersion resourceVersion = ResourceVersion.createNewResourceVersion(resourceId, path, md5String, clientIp, size, FIRST_VERSION, 1L);
            this.versionDao.insertNewVersion(resourceVersion);
            UploadResult uploadResult = new UploadResult(resourceId, FIRST_VERSION, isSuccess);
            results.add(uploadResult);
        }
        return results;
    }

    @Override
    public boolean checkResourceId(String resourceId) {
        return this.resourceDao.checkExists(resourceId) == 1;
    }

    @Override
    public Resource getResource(String resourceId) {
        return this.resourceDao.getResource(resourceId);
    }

    @Override
    public boolean checkAuthority(@NotNull String user, String resourceId) {
        return user.equals(this.resourceDao.getUserByResourceId(resourceId));
    }

    @Override
    public boolean checkExpire(String resourceId, String version) {
        Resource resource = this.resourceDao.getResource(resourceId);
        ResourceVersion resourceVersion = this.versionDao.getResourceVersion(resourceId, version);
        return resource.isEnableFlag() && resourceVersion.isEnableFlag();
    }

    @Override
    public void cleanExpiredResources() {
    }

    @Override
    public void changeOwnerByResourceId(String resourceId, String oldOwner, String newOwner) {
        this.resourceDao.changeOwner(resourceId, oldOwner, newOwner);
    }

    @Override
    public void copyResourceToOtherUser(String resourceId, String otherUser) {
    }

    public static class UploadResult {
        private String resourceId;
        private String version;
        private boolean isSuccess;

        public UploadResult(String resourceId, String version, boolean isSuccess) {
            this.resourceId = resourceId;
            this.version = version;
            this.isSuccess = isSuccess;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(boolean success) {
            this.isSuccess = success;
        }
    }
}

