/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.basedatamanager.server.domain.ErrorCodeEntity;
import org.apache.linkis.basedatamanager.server.service.ErrorCodeService;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ErrorCodeRestfulApi"})
@RestController
@RequestMapping(path={"/basedata-manager/error-code"})
public class ErrorCodeRestfulApi {
    @Autowired
    ErrorCodeService errorCodeService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="int", name="currentPage"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize")})
    @ApiOperation(value="list", notes="list Error Codes with page", httpMethod="GET")
    @RequestMapping(path={""}, method={RequestMethod.GET})
    public Message list(HttpServletRequest request, String searchName, Integer currentPage, Integer pageSize) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query list data of Error Code,search name:" + searchName));
        PageInfo pageList = this.errorCodeService.getListByPage(searchName, currentPage, pageSize);
        return Message.ok((String)"").data("list", (Object)pageList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="get", notes="Get an Error Code Record by id", httpMethod="GET")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Message get(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Get a Error Code Record,id:" + id.toString()));
        ErrorCodeEntity errorCode = (ErrorCodeEntity)this.errorCodeService.getById(id);
        return Message.ok((String)"").data("item", (Object)errorCode);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="ErrorCodeEntity", name="errorCode")})
    @ApiOperation(value="add", notes="Add an Error Code Record", httpMethod="POST")
    @RequestMapping(path={""}, method={RequestMethod.POST})
    public Message add(HttpServletRequest request, @RequestBody ErrorCodeEntity errorCode) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a Datasource Code Record," + errorCode.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.errorCodeService.save(errorCode);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="remove", notes="Remove an Error Code by id", httpMethod="DELETE")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public Message remove(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Remove a Datasource Code Record,id:" + id.toString()));
        boolean result = this.errorCodeService.removeById(id);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="ErrorCodeEntity", name="errorCode")})
    @ApiOperation(value="update", notes="Update a Error Code Record", httpMethod="PUT")
    @RequestMapping(path={""}, method={RequestMethod.PUT})
    public Message update(HttpServletRequest request, @RequestBody ErrorCodeEntity errorCode) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Update a Datasource Code Record,id:" + errorCode.getId().toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.errorCodeService.updateById(errorCode);
        return Message.ok((String)"").data("result", (Object)result);
    }
}

