/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.basedatamanager.server.domain.ConfigurationConfigKey;
import org.apache.linkis.basedatamanager.server.request.ConfigurationTemplateSaveRequest;
import org.apache.linkis.basedatamanager.server.response.EngineLabelResponse;
import org.apache.linkis.basedatamanager.server.service.ConfigurationTemplateService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/basedata-manager/configuration-template"})
public class ConfigurationTemplateRestfulApi {
    @Autowired
    ConfigurationTemplateService configurationTemplateService;

    @ApiOperation(value="save", notes="save a configuration template", httpMethod="POST")
    @RequestMapping(path={"/save"}, method={RequestMethod.POST})
    public Message add(HttpServletRequest httpRequest, @RequestBody ConfigurationTemplateSaveRequest request) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)httpRequest, (String)"save a configuration template");
        if (Objects.isNull(request) || StringUtils.isEmpty((Object)request.getEngineLabelId()) || StringUtils.isEmpty((Object)request.getKey()) || StringUtils.isEmpty((Object)request.getName()) || StringUtils.isEmpty((Object)request.getTreeName())) {
            throw new InvalidParameterException("please check your parameter.");
        }
        Boolean flag = this.configurationTemplateService.saveConfigurationTemplate(request);
        return Message.ok((String)"").data("success: ", (Object)flag);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="keyId", value="")})
    @ApiOperation(value="delete", notes="delete a configuration template", httpMethod="DELETE")
    @RequestMapping(path={"/{keyId}"}, method={RequestMethod.DELETE})
    public Message delete(HttpServletRequest httpRequest, @PathVariable(value="keyId") Long keyId) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)httpRequest, (String)("delete a configuration template, keyId: " + keyId));
        Boolean flag = this.configurationTemplateService.deleteConfigurationTemplate(keyId);
        return Message.ok((String)"").data("success: ", (Object)flag);
    }

    @ApiOperation(value="engin-list", notes="get all engine list", httpMethod="GET")
    @RequestMapping(path={"/engin-list"}, method={RequestMethod.GET})
    public Message getEngineList(HttpServletRequest httpRequest) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)httpRequest, (String)"get all engine list");
        List<EngineLabelResponse> engineList = this.configurationTemplateService.getEngineList();
        return Message.ok((String)"").data("success: ", engineList);
    }

    @ApiOperation(value="template-list-by-label", notes="get template list by label", httpMethod="GET")
    @RequestMapping(path={"/template-list-by-label"}, method={RequestMethod.GET})
    public Message getTemplateListByLabelId(HttpServletRequest httpRequest, @RequestParam String engineLabelId) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)httpRequest, (String)("get template list by label, engineLabelId: " + engineLabelId));
        if (StringUtils.isEmpty((Object)engineLabelId)) {
            throw new InvalidParameterException("please check your parameter.");
        }
        List<ConfigurationConfigKey> configKeyList = this.configurationTemplateService.getTemplateListByLabelId(engineLabelId);
        return Message.ok((String)"").data("success: ", configKeyList);
    }
}

