/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.restful;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.governance.common.constant.ec.ECConstants;
import org.apache.linkis.governance.common.utils.JobUtils;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.exception.AMErrorCode;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.manager.EngineNodeManager;
import org.apache.linkis.manager.am.service.ECResourceInfoService;
import org.apache.linkis.manager.am.service.engine.EngineAskEngineService;
import org.apache.linkis.manager.am.service.engine.EngineAskEngineService$;
import org.apache.linkis.manager.am.service.engine.EngineCreateService;
import org.apache.linkis.manager.am.service.engine.EngineInfoService;
import org.apache.linkis.manager.am.service.engine.EngineOperateService;
import org.apache.linkis.manager.am.service.engine.EngineReuseService;
import org.apache.linkis.manager.am.service.engine.EngineStopService;
import org.apache.linkis.manager.am.util.ECResourceInfoUtils;
import org.apache.linkis.manager.am.utils.AMUtils;
import org.apache.linkis.manager.am.vo.AMEngineNodeVo;
import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.node.AMEMNode;
import org.apache.linkis.manager.common.entity.node.EMNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.persistence.ECResourceInfoRecord;
import org.apache.linkis.manager.common.protocol.engine.EngineAskAsyncResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineAskRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineOperateRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineOperateResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineReuseRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineStopRequest;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.UserModifiable;
import org.apache.linkis.manager.label.exception.LabelErrorException;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"EC(engineconn) operation"})
@RequestMapping(path={"/linkisManager"}, produces={"application/json"})
@RestController
public class EngineRestfulApi {
    @Autowired
    private EngineInfoService engineInfoService;
    @Autowired
    private EngineAskEngineService engineAskService;
    @Autowired
    private EngineCreateService engineCreateService;
    @Autowired
    private EngineNodeManager engineNodeManager;
    @Autowired
    private EngineOperateService engineOperateService;
    @Autowired
    private NodeLabelService nodeLabelService;
    @Autowired
    private EngineStopService engineStopService;
    @Autowired
    private ECResourceInfoService ecResourceInfoService;
    @Autowired
    private EngineReuseService engineReuseService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private LabelBuilderFactory stdLabelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    private static final Logger logger = LoggerFactory.getLogger(EngineRestfulApi.class);

    @ApiOperation(value="askEngineConn", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/askEngineConn"}, method={RequestMethod.POST})
    public Message askEngineConn(HttpServletRequest req, final @RequestBody EngineAskRequest engineAskRequest) throws IOException, InterruptedException {
        final String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"askEngineConn");
        engineAskRequest.setUser(userName);
        long timeout = engineAskRequest.getTimeOut();
        if (timeout <= 0L) {
            timeout = ((TimeType)AMConfiguration.ENGINE_CONN_START_REST_MAX_WAIT_TIME.getValue()).toLong();
            engineAskRequest.setTimeOut(timeout);
        }
        HashMap<String, Object> retEngineNode = new HashMap<String, Object>();
        logger.info("User {} try to ask an engineConn with maxStartTime {}. EngineAskRequest is {}.", new Object[]{userName, ByteTimeUtils.msDurationToString((long)timeout), engineAskRequest});
        final Sender sender = Sender.getSender((ServiceInstance)Sender.getThisServiceInstance());
        EngineNode engineNode = null;
        final String taskId = JobUtils.getJobIdFromStringMap((Map)engineAskRequest.getProperties());
        LoggerUtils.setJobIdMDC((String)taskId);
        logger.info("received task : {}, engineAskRequest : {}", (Object)taskId, (Object)engineAskRequest);
        if (!engineAskRequest.getLabels().containsKey("executeOnce")) {
            EngineReuseRequest engineReuseRequest = new EngineReuseRequest();
            engineReuseRequest.setLabels(engineAskRequest.getLabels());
            engineReuseRequest.setTimeOut(engineAskRequest.getTimeOut());
            engineReuseRequest.setUser(engineAskRequest.getUser());
            engineReuseRequest.setProperties(engineAskRequest.getProperties());
            boolean end = false;
            EngineNode reuseNode = null;
            int count = 0;
            int MAX_RETRY = 2;
            while (!end) {
                try {
                    reuseNode = this.engineReuseService.reuseEngine(engineReuseRequest, sender);
                    end = true;
                }
                catch (LinkisRetryException e) {
                    logger.error("task: {}, user: {} reuse engine failed", new Object[]{taskId, engineReuseRequest.getUser(), e});
                    Thread.sleep(1000L);
                    end = false;
                    if (++count <= MAX_RETRY) continue;
                    end = true;
                }
                catch (Exception e1) {
                    logger.info("task: {} user: {} reuse engine failed", new Object[]{taskId, engineReuseRequest.getUser(), e1});
                    end = true;
                }
            }
            if (null != reuseNode) {
                logger.info("Finished to ask engine for task: {}, user: {} by reuse node {}", new Object[]{taskId, engineReuseRequest.getUser(), reuseNode});
                LoggerUtils.removeJobIdMDC();
                engineNode = reuseNode;
            }
        }
        if (null != engineNode) {
            this.fillResultEngineNode(retEngineNode, engineNode);
            return Message.ok((String)"reuse engineConn ended.").data("engine", retEngineNode);
        }
        final String engineAskAsyncId = EngineAskEngineService$.MODULE$.getAsyncId();
        Callable createECTask = new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() {
                LoggerUtils.setJobIdMDC((String)taskId);
                logger.info("Task: {}, start to async({}) createEngine: {}", new Object[]{taskId, engineAskAsyncId, engineAskRequest.getCreateService()});
                engineAskRequest.getLabels().remove("engineInstance");
                EngineCreateRequest engineCreateRequest = new EngineCreateRequest();
                engineCreateRequest.setLabels(engineAskRequest.getLabels());
                engineCreateRequest.setTimeout(engineAskRequest.getTimeOut());
                engineCreateRequest.setUser(engineAskRequest.getUser());
                engineCreateRequest.setProperties(engineAskRequest.getProperties());
                engineCreateRequest.setCreateService(engineAskRequest.getCreateService());
                try {
                    EngineNode createNode = EngineRestfulApi.this.engineCreateService.createEngine(engineCreateRequest, sender);
                    long timeout = 0L;
                    timeout = engineCreateRequest.getTimeout() <= 0L ? ((TimeType)AMConfiguration.ENGINE_START_MAX_TIME.getValue()).toLong() : engineCreateRequest.getTimeout();
                    EngineNode createEngineNode = EngineRestfulApi.this.engineNodeManager.useEngine(createNode, timeout);
                    if (null == createEngineNode) {
                        throw new LinkisRetryException(30002, "create engine${createNode.getServiceInstance} success, but to use engine failed");
                    }
                    logger.info("Task: $taskId finished to ask engine for user ${engineAskRequest.getUser} by create node $createEngineNode");
                    EngineNode engineNode = createEngineNode;
                    return engineNode;
                }
                catch (Exception e) {
                    logger.error("Task: {} failed to ask engine for user {} by create node", new Object[]{taskId, userName, e});
                    LinkisRetryException linkisRetryException = new LinkisRetryException(30002, e.getMessage());
                    return linkisRetryException;
                }
                finally {
                    LoggerUtils.removeJobIdMDC();
                }
            }
        };
        try {
            Object rs = createECTask.call();
            if (rs instanceof LinkisRetryException) {
                throw (LinkisRetryException)((Object)rs);
            }
            engineNode = (EngineNode)rs;
        }
        catch (LinkisRetryException retryException) {
            logger.error("User {} create engineConn failed get retry  exception. can be Retry", (Object)userName, (Object)retryException);
            return Message.error((String)String.format("Create engineConn failed, caused by %s.", ExceptionUtils.getRootCauseMessage((Throwable)retryException))).data("canRetry", (Object)true);
        }
        catch (Exception e) {
            LoggerUtils.removeJobIdMDC();
            logger.error("User {} create engineConn failed get retry  exception", (Object)userName, (Object)e);
            return Message.error((String)String.format("Create engineConn failed, caused by %s.", ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        LoggerUtils.removeJobIdMDC();
        this.fillResultEngineNode(retEngineNode, engineNode);
        logger.info("Finished to create a engineConn for user {}. NodeInfo is {}.", (Object)userName, (Object)engineNode);
        return Message.ok((String)"create engineConn ended.").data("engine", retEngineNode);
    }

    private void fillNullNode(Map<String, Object> retEngineNode, EngineAskAsyncResponse askAsyncResponse) {
        retEngineNode.put("ecAsyncStartResult", "failed");
        retEngineNode.put("failMsg", "Got null response for asyId : " + askAsyncResponse.id());
        retEngineNode.put(ECConstants.MANAGER_SERVICE_INSTANCE_KEY(), Sender.getThisServiceInstance());
    }

    private void fillResultEngineNode(Map<String, Object> retEngineNode, EngineNode engineNode) {
        retEngineNode.put("ecAsyncStartResult", "success");
        retEngineNode.put("serviceInstance", engineNode.getServiceInstance());
        if (null == engineNode.getNodeStatus()) {
            engineNode.setNodeStatus(NodeStatus.Starting);
        }
        retEngineNode.put(ECConstants.NODE_STATUS_KEY(), engineNode.getNodeStatus().toString());
        retEngineNode.put(ECConstants.EC_TICKET_ID_KEY(), engineNode.getTicketId());
        EMNode emNode = engineNode.getEMNode();
        if (null != emNode) {
            retEngineNode.put(ECConstants.ECM_SERVICE_INSTANCE_KEY(), engineNode.getEMNode().getServiceInstance());
        }
        retEngineNode.put(ECConstants.MANAGER_SERVICE_INSTANCE_KEY(), Sender.getThisServiceInstance());
    }

    @ApiOperation(value="createEngineConn", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/createEngineConn"}, method={RequestMethod.POST})
    public Message createEngineConn(HttpServletRequest req, @RequestBody EngineCreateRequest engineCreateRequest) throws IOException, InterruptedException {
        EngineNode engineNode;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"createEngineConn");
        engineCreateRequest.setUser(userName);
        long timeout = engineCreateRequest.getTimeout();
        if (timeout <= 0L) {
            timeout = ((TimeType)AMConfiguration.ENGINE_CONN_START_REST_MAX_WAIT_TIME.getValue()).toLong();
            engineCreateRequest.setTimeout(timeout);
        }
        logger.info("User {} try to create a engineConn with maxStartTime {}. EngineCreateRequest is {}.", new Object[]{userName, ByteTimeUtils.msDurationToString((long)timeout), engineCreateRequest});
        Sender sender = Sender.getSender((ServiceInstance)Sender.getThisServiceInstance());
        try {
            engineNode = this.engineCreateService.createEngine(engineCreateRequest, sender);
        }
        catch (LinkisRetryException e) {
            logger.error("User {} create engineConn failed get retry  exception. can be Retry", (Object)userName, (Object)e);
            return Message.error((String)String.format("Create engineConn failed, caused by %s.", ExceptionUtils.getRootCauseMessage((Throwable)e))).data("canRetry", (Object)true);
        }
        catch (Exception e) {
            logger.error(String.format("User %s create engineConn failed.", userName), (Throwable)e);
            return Message.error((String)String.format("Create engineConn failed, caused by %s.", ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        logger.info("Finished to create a engineConn for user {}. NodeInfo is {}.", (Object)userName, (Object)engineNode);
        HashMap<String, Object> retEngineNode = new HashMap<String, Object>();
        this.fillResultEngineNode(retEngineNode, engineNode);
        return Message.ok((String)"create engineConn succeed.").data("engine", retEngineNode);
    }

    @ApiOperation(value="getEngineConn", notes="get engineconn", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/getEngineConn"}, method={RequestMethod.POST})
    public Message getEngineConn(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getEngineConn");
        ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(jsonNode);
        JsonNode ticketIdNode = jsonNode.get("ticketId");
        EngineNode engineNode = null;
        try {
            engineNode = this.engineNodeManager.getEngineNodeInfo(serviceInstance);
        }
        catch (Exception e) {
            logger.info("Instances {} does not exist", (Object)serviceInstance.getInstance());
        }
        String ecMetrics = null;
        if (null == engineNode) {
            ECResourceInfoRecord ecInfo = null;
            if (null != ticketIdNode) {
                try {
                    ecInfo = this.ecResourceInfoService.getECResourceInfoRecord(ticketIdNode.asText());
                }
                catch (Exception e) {
                    logger.info("TicketId  {} does not exist", (Object)ticketIdNode.asText());
                }
            }
            if (null == ecInfo) {
                ecInfo = this.ecResourceInfoService.getECResourceInfoRecordByInstance(serviceInstance.getInstance());
            }
            if (null == ecInfo) {
                return Message.error((String)("Instance does not exist " + serviceInstance));
            }
            if (null == ecMetrics) {
                ecMetrics = ecInfo.getMetrics();
            }
            engineNode = ECResourceInfoUtils.convertECInfoTOECNode(ecInfo);
        } else {
            ecMetrics = engineNode.getEcMetrics();
        }
        if (!userName.equals(engineNode.getOwner()) && Configuration.isNotAdmin((String)userName)) {
            return Message.error((String)("You have no permission to access EngineConn " + serviceInstance));
        }
        Message result = Message.ok().data("engine", (Object)engineNode);
        result.data("ecMetrics", (Object)ecMetrics);
        return result;
    }

    @ApiOperation(value="kill egineconn", notes="kill engineconn", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/killEngineConn"}, method={RequestMethod.POST})
    public Message killEngineConn(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws Exception {
        ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(jsonNode);
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("killEngineConn\uff1a" + serviceInstance));
        logger.info("User {} try to kill engineConn {}.", (Object)userName, (Object)serviceInstance);
        EngineNode engineNode = this.engineNodeManager.getEngineNode(serviceInstance);
        if (!userName.equals(engineNode.getOwner()) && Configuration.isNotAdmin((String)userName)) {
            return Message.error((String)("You have no permission to kill EngineConn " + serviceInstance));
        }
        EngineStopRequest stopEngineRequest = new EngineStopRequest(serviceInstance, userName);
        Sender sender = Sender.getSender((ServiceInstance)Sender.getThisServiceInstance());
        this.engineStopService.stopEngine(stopEngineRequest, sender);
        logger.info("Finished to kill engineConn {}.", (Object)serviceInstance);
        return Message.ok((String)"Kill engineConn succeed.");
    }

    @ApiOperation(value="kill egineconns of a ecm", notes="", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="instance", dataType="String", required=true, example="bdp110:9210")})
    @ApiOperationSupport(ignoreParameters={"param"})
    @RequestMapping(path={"/rm/killUnlockEngineByEM"}, method={RequestMethod.POST})
    public Message killUnlockEngine(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException {
        JsonNode ecmInstance = jsonNode.get("instance");
        if (null == ecmInstance || StringUtils.isBlank((CharSequence)ecmInstance.textValue())) {
            throw new AMErrorException(210003, "instance is null in the parameters of the request(\u8bf7\u6c42\u53c2\u6570\u4e2d\u3010instance\u3011\u4e3a\u7a7a)");
        }
        String operatMsg = MessageFormat.format("kill the unlock engines of ECM:{0}", ecmInstance.textValue());
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)operatMsg);
        if (Configuration.isNotAdmin((String)userName)) {
            throw new AMErrorException(210003, "Only admin can kill unlock engine of the specified ecm(\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd kill \u6307\u5b9a ecm \u4e0b\u7684\u6240\u6709\u7a7a\u95f2\u5f15\u64ce).");
        }
        Map<String, Object> result = this.engineStopService.stopUnlockEngineByECM(ecmInstance.textValue(), userName);
        return Message.ok((String)"Kill engineConn succeed.").data("result", result);
    }

    @ApiOperation(value="kill eginecon", notes="kill one engineconn or more ", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="engineInstance", dataType="String", example="bdp110:12295"), @ApiImplicitParam(name="applicationName", dataType="String", example="linkis-cg-engineconn")})
    @ApiOperationSupport(ignoreParameters={"param"})
    @RequestMapping(path={"/rm/enginekill"}, method={RequestMethod.POST})
    public Message killEngine(HttpServletRequest req, @RequestBody Map<String, String>[] param) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"enginekill");
        Sender sender = Sender.getSender((ServiceInstance)Sender.getThisServiceInstance());
        for (Map<String, String> engineParam : param) {
            String moduleName = engineParam.get("applicationName");
            String engineInstance = engineParam.get("engineInstance");
            logger.info("try to kill engine with engineInstance:{}", (Object)engineInstance);
            EngineStopRequest stopEngineRequest = new EngineStopRequest(ServiceInstance.apply((String)moduleName, (String)engineInstance), userName);
            this.engineStopService.stopEngine(stopEngineRequest, sender);
        }
        logger.info("Finished to kill engines");
        return Message.ok((String)"Kill engineConn succeed.");
    }

    @ApiOperationSupport(ignoreParameters={"param"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="instances", dataType="Array", example="[\"bdp110:12295\",\"bdp110:12296\"]")})
    @RequestMapping(path={"/rm/enginekillAsyn"}, method={RequestMethod.POST})
    public Message killEngineAsyn(HttpServletRequest req, @RequestBody JsonNode jsonNode) {
        JsonNode instancesParam;
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"enginekill");
        String token = ModuleUserUtils.getToken((HttpServletRequest)req);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            if (!Configuration.isAdminToken((String)token)) {
                logger.warn("Token {} has no permission to asyn kill engines.", (Object)token);
                return Message.error((String)("Token:" + token + " has no permission to asyn kill engines."));
            }
        } else if (!Configuration.isAdmin((String)username)) {
            logger.warn("User {} has no permission to asyn kill engines.", (Object)username);
            return Message.error((String)("User:" + username + " has no permission to asyn kill engines."));
        }
        if ((instancesParam = jsonNode.get("instances")) == null || instancesParam.size() == 0) {
            return Message.error((String)"instances is null in the parameters of the request(\u8bf7\u6c42\u53c2\u6570\u4e2d\u3010instances\u3011\u4e3a\u7a7a)");
        }
        List instancesList = null;
        try {
            instancesList = (List)JsonUtils.jackson().readValue(instancesParam.toString(), (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (JsonProcessingException e) {
            return Message.error((String)"instances parameters parsing failed(\u8bf7\u6c42\u53c2\u6570\u3010instances\u3011\u89e3\u6790\u5931\u8d25)");
        }
        for (String engineInstance : instancesList) {
            String moduleName = (String)GovernanceCommonConf.ENGINE_CONN_MANAGER_SPRING_NAME().getValue();
            EngineStopRequest stopEngineRequest = new EngineStopRequest(ServiceInstance.apply((String)moduleName, (String)engineInstance), username);
            this.engineStopService.asyncStopEngineWithUpdateMetrics(stopEngineRequest);
        }
        logger.info("Finished to kill engines");
        return Message.ok((String)"Kill engineConn succeed.");
    }

    @ApiOperation(value="listUserEngines", notes="get user's engineconn list", response=Message.class)
    @RequestMapping(path={"/listUserEngines"}, method={RequestMethod.GET})
    public Message listUserEngines(HttpServletRequest req) {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"listUserEngines");
        List<EngineNode> engineNodes = this.engineInfoService.listUserEngines(userName);
        return Message.ok().data("engines", engineNodes);
    }

    @ApiOperation(value="listEMEngines", notes="get the list of engineconn under an ECM", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="em", required=false, dataType="Map", value="ecm object"), @ApiImplicitParam(name="serviceInstance", dataType="Map"), @ApiImplicitParam(name="applicationName", dataType="String", example="linkis-cg-engineconnmanager"), @ApiImplicitParam(name="instance", required=false, dataType="String", value="instance"), @ApiImplicitParam(name="emInstance", dataType="String", example="bdp110:9102"), @ApiImplicitParam(name="engineType", dataType="String"), @ApiImplicitParam(name="nodeStatus", dataType="String"), @ApiImplicitParam(name="owner", dataType="String", value="owner")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/listEMEngines"}, method={RequestMethod.POST})
    public Message listEMEngines(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws IOException, AMErrorException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"listEMEngines");
        if (Configuration.isNotAdmin((String)username)) {
            throw new AMErrorException(210003, "Only admin can search engine information(\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u67e5\u8be2\u6240\u6709\u5f15\u64ce\u4fe1\u606f).");
        }
        AMEMNode amemNode = (AMEMNode)this.objectMapper.treeToValue((TreeNode)jsonNode.get("em"), AMEMNode.class);
        JsonNode emInstace = jsonNode.get("emInstance");
        JsonNode nodeStatus = jsonNode.get("nodeStatus");
        JsonNode engineType = jsonNode.get("engineType");
        JsonNode owner = jsonNode.get("owner");
        List<EngineNode> engineNodes = this.engineInfoService.listEMEngines((EMNode)amemNode);
        List<AMEngineNodeVo> allengineNodes = AMUtils.copyToAMEngineNodeVo(engineNodes);
        if (CollectionUtils.isNotEmpty(allengineNodes)) {
            Stream<Object> stream = allengineNodes.stream();
            if (null != emInstace) {
                stream = stream.filter(em -> StringUtils.isNotBlank((CharSequence)em.getInstance()) && em.getInstance().contains(emInstace.asText()));
            }
            if (null != nodeStatus && StringUtils.isNotBlank((CharSequence)nodeStatus.asText())) {
                stream = stream.filter(em -> null != em.getNodeStatus() && em.getNodeStatus().equals((Object)NodeStatus.valueOf((String)nodeStatus.asText())));
            }
            if (null != owner && StringUtils.isNotBlank((CharSequence)owner.asText())) {
                stream = stream.filter(em -> StringUtils.isNotBlank((CharSequence)em.getOwner()) && em.getOwner().equalsIgnoreCase(owner.asText()));
            }
            if (null != engineType && StringUtils.isNotBlank((CharSequence)engineType.asText())) {
                stream = stream.filter(em -> StringUtils.isNotBlank((CharSequence)em.getEngineType()) && em.getEngineType().equalsIgnoreCase(engineType.asText()));
            }
            allengineNodes = stream.collect(Collectors.toList());
        }
        return Message.ok().data("engines", allengineNodes);
    }

    @ApiOperation(value="modifyEngineInfo", notes="modify engineconn info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationName", dataType="String", example="linkis-cg-engineconn"), @ApiImplicitParam(name="emStatus", dataType="String", example="Starting,Unlock,Locked,Idle,Busy,Running,ShuttingDown,Failed,Success"), @ApiImplicitParam(name="instance", dataType="String", example="bdp110:12295"), @ApiImplicitParam(name="labels", dataType="List", required=false, value="labels"), @ApiImplicitParam(name="labelKey", dataType="String", example="engineInstance"), @ApiImplicitParam(name="stringValue", dataType="String", example="linkis-cg:12295"), @ApiImplicitParam(name="nodeHealthy", dataType="String", example="UnHealthy")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/modifyEngineInfo"}, method={RequestMethod.PUT})
    public Message modifyEngineInfo(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException, LabelErrorException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"modifyEngineInfo");
        if (Configuration.isNotAdmin((String)username)) {
            throw new AMErrorException(210003, "Only admin can modify engineConn information(\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u5f15\u64ce\u4fe1\u606f).");
        }
        ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(jsonNode);
        JsonNode labels = jsonNode.get("labels");
        HashSet<String> labelKeySet = new HashSet<String>();
        if (labels != null) {
            ArrayList newLabelList = new ArrayList();
            for (JsonNode label : labels) {
                String stringValue;
                String labelKey = label.get("labelKey").asText();
                Label newLabel = this.stdLabelBuilderFactory.createLabel(labelKey, (Object)(stringValue = label.get("stringValue").asText()));
                if (newLabel instanceof UserModifiable) {
                    ((UserModifiable)newLabel).valueCheck(stringValue);
                }
                labelKeySet.add(labelKey);
                newLabelList.add(newLabel);
            }
            if (labelKeySet.size() != newLabelList.size()) {
                throw new AMErrorException(210003, "Failed to update label, include repeat label(\u66f4\u65b0label\u5931\u8d25\uff0c\u5305\u542b\u91cd\u590dlabel)");
            }
            this.nodeLabelService.updateLabelsToNode(serviceInstance, newLabelList);
            logger.info("success to update label of instance: " + serviceInstance.getInstance());
        }
        String healthyKey = "Healthy";
        String unHealthyKey = "UnHealthy";
        JsonNode nodeHealthy = jsonNode.get("nodeHealthy");
        if (nodeHealthy != null && healthyKey.equals(nodeHealthy.asText())) {
            this.engineInfoService.updateEngineHealthyStatus(serviceInstance, NodeHealthy.Healthy);
        } else if (nodeHealthy != null && unHealthyKey.equals(nodeHealthy.asText())) {
            this.engineInfoService.updateEngineHealthyStatus(serviceInstance, NodeHealthy.UnHealthy);
        }
        return Message.ok((String)"success to update engine information(\u66f4\u65b0\u5f15\u64ce\u4fe1\u606f\u6210\u529f)");
    }

    @ApiOperation(value="batchSetEngineToUnHealthy", notes="batch set engine to unHealthy", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="instances", dataType="String", example="[{\"instance\":\"bdplinkis1001:38701\",\"engineType\":\"spark\",\"applicationName\":\"linkis-cg-engineconn\"}]")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/batchSetEngineToUnHealthy"}, method={RequestMethod.POST})
    public Message batchSetEngineToUnHealthy(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"batchSetEngineToUnHealthy");
        if (Configuration.isNotAdmin((String)username)) {
            throw new AMErrorException(210003, "Only admin can modify engineConn healthy info(\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u5f15\u64ce\u5065\u5eb7\u4fe1\u606f).");
        }
        JsonNode instances = jsonNode.get("instances");
        if (instances != null) {
            for (JsonNode instanceNode : instances) {
                ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(instanceNode);
                this.engineInfoService.updateEngineHealthyStatus(serviceInstance, NodeHealthy.UnHealthy);
            }
        }
        logger.info("success to batch update engine status to UnHealthy.");
        return Message.ok((String)"success to update engine information(\u6279\u91cf\u66f4\u65b0\u5f15\u64ce\u5065\u5eb7\u4fe1\u606f\u6210\u529f)");
    }

    @ApiOperation(value="listAllNodeHealthyStatus", notes="get all node healthy staus list", response=Message.class)
    @RequestMapping(path={"/listAllNodeHealthyStatus"}, method={RequestMethod.GET})
    public Message listAllNodeHealthyStatus(HttpServletRequest req, @RequestParam(value="onlyEditable", required=false) Boolean onlyEditable) {
        NodeStatus[] nodeStatus = NodeStatus.values();
        return Message.ok().data("nodeStatus", (Object)nodeStatus);
    }

    @ApiOperation(value="executeEngineConnOperation", notes="execute engine conn operation", response=Message.class)
    @RequestMapping(path={"/executeEngineConnOperation"}, method={RequestMethod.POST})
    public Message executeEngineConnOperation(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws Exception {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"executeEngineConnOperation");
        ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(jsonNode);
        logger.info("User {} try to execute Engine Operation {}.", (Object)userName, (Object)serviceInstance);
        EngineNode engineNode = this.engineNodeManager.getEngineNode(serviceInstance);
        if (null == engineNode) {
            return Message.ok().data("isError", (Object)true).data("errorMsg", (Object)("Ec : " + serviceInstance.toString() + " not found."));
        }
        if (!userName.equals(engineNode.getOwner()) && Configuration.isNotAdmin((String)userName)) {
            return Message.error((String)("You have no permission to execute Engine Operation " + serviceInstance));
        }
        Map parameters = (Map)this.objectMapper.convertValue((Object)jsonNode.get("parameters"), (TypeReference)new TypeReference<Map<String, Object>>(){});
        EngineOperateRequest engineOperateRequest = new EngineOperateRequest(userName, parameters);
        EngineOperateResponse engineOperateResponse = this.engineOperateService.executeOperation(engineNode, engineOperateRequest);
        return Message.ok().data("result", (Object)engineOperateResponse.getResult()).data("errorMsg", (Object)engineOperateResponse.errorMsg()).data("isError", (Object)engineOperateResponse.isError());
    }

    @ApiOperation(value="kill egineconns of a ecm", notes="Kill engine after updating configuration", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="creator", dataType="String", required=true, example="IDE"), @ApiImplicitParam(name="engineType", dataType="String", required=true, example="hive-2.3.3")})
    @ApiOperationSupport(ignoreParameters={"param"})
    @RequestMapping(path={"/rm/killEngineByUpdateConfig"}, method={RequestMethod.POST})
    public Message killEngineByUpdateConfig(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req);
        String jvmUser = StorageUtils.getJvmUser();
        if (jvmUser.equals(userName)) {
            return Message.error((String)(jvmUser + " users do not support this feature (" + jvmUser + " \u7528\u6237\u4e0d\u652f\u6301\u6b64\u529f\u80fd)"));
        }
        JsonNode creator = jsonNode.get("creator");
        if (null == creator || StringUtils.isBlank((CharSequence)creator.textValue())) {
            return Message.error((String)"instance is null in the parameters of the request(\u8bf7\u6c42\u53c2\u6570\u4e2d\u3010creator\u3011\u4e3a\u7a7a)");
        }
        String creatorStr = Configuration.getGlobalCreator((String)creator.textValue());
        String engineType = "";
        if (null != jsonNode.get("engineType")) {
            engineType = jsonNode.get("engineType").textValue();
        }
        if (StringUtils.isNotBlank((CharSequence)engineType) && AMConfiguration.isUnAllowKilledEngineType(engineType)) {
            return Message.error((String)"multi user engine does not support this feature(\u591a\u7528\u6237\u5f15\u64ce\u4e0d\u652f\u6301\u6b64\u529f\u80fd)");
        }
        this.engineStopService.stopUnlockECByUserCreatorAndECType(userName, creatorStr, engineType);
        return Message.ok((String)"Kill engineConn succeed");
    }

    static ServiceInstance getServiceInstance(JsonNode jsonNode) throws AMErrorException {
        String applicationName = jsonNode.get("applicationName").asText();
        String instance = jsonNode.get("instance").asText();
        if (StringUtils.isEmpty((CharSequence)applicationName)) {
            throw new AMErrorException(AMErrorCode.QUERY_PARAM_NULL.getErrorCode(), "applicationName cannot be null(\u8bf7\u6c42\u53c2\u6570applicationName\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isEmpty((CharSequence)instance)) {
            throw new AMErrorException(AMErrorCode.QUERY_PARAM_NULL.getErrorCode(), "instance cannot be null(\u8bf7\u6c42\u53c2\u6570instance\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        return ServiceInstance.apply((String)applicationName, (String)instance);
    }
}

