/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.label;

import java.util.List;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.em.EMInstanceLabel;
import org.apache.linkis.manager.label.entity.engine.EngineInstanceLabel;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.service.common.label.ManagerLabelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultManagerLabelService
implements ManagerLabelService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultManagerLabelService.class);
    @Autowired
    private NodeLabelService nodeLabelService;

    @Override
    public boolean isEngine(ServiceInstance serviceInstance) {
        List<Label<?>> labelList = this.nodeLabelService.getNodeLabels(serviceInstance);
        return this.isEngine(labelList);
    }

    @Override
    public boolean isEM(ServiceInstance serviceInstance) {
        List<Label<?>> labelList = this.nodeLabelService.getNodeLabels(serviceInstance);
        boolean isEngine = labelList.stream().anyMatch(label -> label instanceof EngineInstanceLabel);
        if (!isEngine) {
            return labelList.stream().anyMatch(label -> label instanceof EMInstanceLabel);
        }
        return false;
    }

    @Override
    public boolean isEngine(List<Label<?>> labels) {
        return labels.stream().anyMatch(label -> label instanceof EngineInstanceLabel);
    }
}

