/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.loader.loaders.resource;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.linkis.engineplugin.loader.loaders.EngineConnPluginsResourceLoader;
import org.apache.linkis.engineplugin.loader.loaders.resource.PluginResource;
import org.apache.linkis.engineplugin.loader.utils.EngineConnPluginUtils;
import org.apache.linkis.manager.engineplugin.common.loader.entity.EngineConnPluginInfo;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEngineConnPluginResourceLoader
implements EngineConnPluginsResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(LocalEngineConnPluginResourceLoader.class);

    @Override
    public PluginResource loadEngineConnPluginResource(EngineConnPluginInfo pluginInfo, String savePath) {
        long modifyTime;
        File savePos = FileUtils.getFile((String[])new String[]{savePath});
        if (savePos.exists() && savePos.isDirectory() && (modifyTime = savePos.lastModified()) > pluginInfo.resourceUpdateTime()) {
            EngineTypeLabel typeLabel = pluginInfo.typeLabel();
            List<URL> urls = EngineConnPluginUtils.getJarsUrlsOfPath(savePath);
            if (urls.size() > 0) {
                LOG.info("Load local resource of engine conn plugin: [name: {}, version: {}] uri: [{}]", new Object[]{typeLabel.getEngineType(), typeLabel.getVersion(), savePath});
            }
            return new PluginResource(null, null, modifyTime, urls.toArray(new URL[0]));
        }
        return null;
    }
}

