/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.shims.config.entries;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.ConfigUtil;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ConfigEntry;

public class ModuleEntry
extends ConfigEntry {
    public static final String MODULE_NAME = "name";
    public static final String MODULE_TYPE = "type";
    private final String name;

    protected ModuleEntry(String name, DescriptorProperties properties) {
        super(properties);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void validate(DescriptorProperties properties) {
        properties.validateString(MODULE_TYPE, false, 1);
    }

    public static ModuleEntry create(Map<String, Object> config) {
        return ModuleEntry.create(ConfigUtil.normalizeYaml(config));
    }

    private static ModuleEntry create(DescriptorProperties properties) {
        properties.validateString(MODULE_NAME, false, 1);
        String name = properties.getString(MODULE_NAME);
        DescriptorProperties cleanedProperties = properties.withoutKeys(Collections.singletonList(MODULE_NAME));
        return new ModuleEntry(name, cleanedProperties);
    }
}

