/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.shims.config.entries;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.ConfigUtil;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ConfigEntry;

public class ConfigurationEntry
extends ConfigEntry {
    public static final ConfigurationEntry DEFAULT_INSTANCE = new ConfigurationEntry(new DescriptorProperties(true));

    private ConfigurationEntry(DescriptorProperties properties) {
        super(properties);
    }

    @Override
    protected void validate(DescriptorProperties properties) {
    }

    public static ConfigurationEntry create(Map<String, Object> config) {
        return new ConfigurationEntry(ConfigUtil.normalizeYaml(config));
    }

    public static ConfigurationEntry merge(ConfigurationEntry configuration1, ConfigurationEntry configuration2) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>(configuration1.asMap());
        mergedProperties.putAll(configuration2.asMap());
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(mergedProperties);
        return new ConfigurationEntry(properties);
    }

    public static ConfigurationEntry enrich(ConfigurationEntry configuration, Map<String, String> prefixedProperties) {
        HashMap<String, String> enrichedProperties = new HashMap<String, String>(configuration.asMap());
        prefixedProperties.forEach((k, v) -> {
            String normalizedKey = k.toLowerCase();
            if (k.startsWith("table.")) {
                enrichedProperties.put(normalizedKey, (String)v);
            }
        });
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(enrichedProperties);
        return new ConfigurationEntry(properties);
    }
}

