/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.shims.config.entries;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.FlinkInitFailedException;

public abstract class ConfigEntry {
    protected final DescriptorProperties properties;

    protected ConfigEntry(DescriptorProperties properties) throws FlinkInitFailedException {
        try {
            this.validate(properties);
        }
        catch (ValidationException e) {
            throw new FlinkInitFailedException(FlinkErrorCodeSummary.CONFIGURATION_ENTRY_INVALID.getErrorDesc(), e);
        }
        this.properties = properties;
    }

    protected abstract void validate(DescriptorProperties var1);

    public Map<String, String> asMap() {
        return this.properties.asMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigEntry that = (ConfigEntry)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }
}

