/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.shims.config.entries;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.ConfigUtil;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ConfigEntry;

public class CatalogEntry
extends ConfigEntry {
    public static final String CATALOG_NAME = "name";
    public static final String CATALOG_TYPE = "type";
    public static final String CATALOG_PROPERTY_VERSION = "property-version";
    private final String name;

    protected CatalogEntry(String name, DescriptorProperties properties) {
        super(properties);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void validate(DescriptorProperties properties) {
        properties.validateString(CATALOG_TYPE, false, 1);
        properties.validateInt(CATALOG_PROPERTY_VERSION, true, 0);
    }

    public static CatalogEntry create(Map<String, Object> config) {
        return CatalogEntry.create(ConfigUtil.normalizeYaml(config));
    }

    private static CatalogEntry create(DescriptorProperties properties) {
        properties.validateString(CATALOG_NAME, false, 1);
        String name = properties.getString(CATALOG_NAME);
        DescriptorProperties cleanedProperties = properties.withoutKeys(Collections.singletonList(CATALOG_NAME));
        return new CatalogEntry(name, cleanedProperties);
    }
}

