/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.shims.config;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.ConfigUtil;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.CatalogEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ConfigurationEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.DeploymentEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ExecutionEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.FunctionEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ModuleEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.TableEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ViewEntry;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.FlinkInitFailedException;

public class Environment {
    public static final String SESSION_ENTRY = "session";
    public static final String EXECUTION_ENTRY = "execution";
    public static final String CONFIGURATION_ENTRY = "table";
    public static final String DEPLOYMENT_ENTRY = "deployment";
    private ExecutionEntry execution;
    private Map<String, ModuleEntry> modules = new LinkedHashMap<String, ModuleEntry>();
    private Map<String, CatalogEntry> catalogs = Collections.emptyMap();
    private Map<String, TableEntry> tables = Collections.emptyMap();
    private Map<String, FunctionEntry> functions = Collections.emptyMap();
    private ConfigurationEntry configuration;
    private DeploymentEntry deployment;

    public Environment() {
        this.execution = ExecutionEntry.DEFAULT_INSTANCE;
        this.configuration = ConfigurationEntry.DEFAULT_INSTANCE;
        this.deployment = DeploymentEntry.DEFAULT_INSTANCE;
    }

    public Map<String, ModuleEntry> getModules() {
        return this.modules;
    }

    public void setModules(List<Map<String, Object>> modules) throws FlinkInitFailedException {
        this.modules = new LinkedHashMap<String, ModuleEntry>(modules.size());
        for (Map<String, Object> config : modules) {
            ModuleEntry entry = ModuleEntry.create(config);
            if (this.modules.containsKey(entry.getName())) {
                throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.CANNOT_MODULE_ALREADY.getErrorDesc(), entry.getName()));
            }
            this.modules.put(entry.getName(), entry);
        }
    }

    public Map<String, CatalogEntry> getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(List<Map<String, Object>> catalogs) throws FlinkInitFailedException {
        this.catalogs = new HashMap<String, CatalogEntry>(catalogs.size());
        for (Map<String, Object> config : catalogs) {
            CatalogEntry catalog = CatalogEntry.create(config);
            if (this.catalogs.containsKey(catalog.getName())) {
                throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.CANNOT_CATALOG_ALREADY.getErrorDesc(), catalog.getName()));
            }
            this.catalogs.put(catalog.getName(), catalog);
        }
    }

    public Map<String, TableEntry> getTables() {
        return this.tables;
    }

    public void setTables(List<Map<String, Object>> tables) throws FlinkInitFailedException {
        this.tables = new LinkedHashMap<String, TableEntry>(tables.size());
        for (Map<String, Object> config : tables) {
            TableEntry table = TableEntry.create(config);
            if (this.tables.containsKey(table.getName())) {
                throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.CANNOT_TABLE_ALREADY.getErrorDesc(), table.getName()));
            }
            this.tables.put(table.getName(), table);
        }
    }

    public Map<String, FunctionEntry> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<Map<String, Object>> functions) throws FlinkInitFailedException {
        this.functions = new HashMap<String, FunctionEntry>(functions.size());
        for (Map<String, Object> config : functions) {
            FunctionEntry function = FunctionEntry.create(config);
            if (this.functions.containsKey(function.getName())) {
                throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.CANNOT_FUNCTION_ALREADY.getErrorDesc(), function.getName()));
            }
            this.functions.put(function.getName(), function);
        }
    }

    public void setExecution(Map<String, Object> config) {
        this.execution = ExecutionEntry.create(config);
    }

    public ExecutionEntry getExecution() {
        return this.execution;
    }

    public void setConfiguration(Map<String, Object> config) {
        this.configuration = ConfigurationEntry.create(config);
    }

    public ConfigurationEntry getConfiguration() {
        return this.configuration;
    }

    public void setDeployment(Map<String, Object> config) {
        this.deployment = DeploymentEntry.create(config);
    }

    public DeploymentEntry getDeployment() {
        return this.deployment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("==================== Session =====================\n");
        sb.append("===================== Modules =====================\n");
        this.modules.forEach((name, module) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            module.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("===================== Catalogs =====================\n");
        this.catalogs.forEach((name, catalog) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            catalog.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("===================== Tables =====================\n");
        this.tables.forEach((name, table) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            table.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Functions ====================\n");
        this.functions.forEach((name, function) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            function.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Execution ====================\n");
        this.execution.asTopLevelMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        sb.append("================== Configuration =================\n");
        this.configuration.asMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        sb.append("=================== Deployment ===================\n");
        this.deployment.asTopLevelMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        return sb.toString();
    }

    public static Environment parse(URL url) throws IOException, FlinkInitFailedException {
        try {
            return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(url, Environment.class);
        }
        catch (JsonMappingException e) {
            throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.BOT_PARSE_ENVIRONMENT.getErrorDesc(), e.getMessage()), e);
        }
    }

    public static Environment parse(String content) throws IOException, FlinkInitFailedException {
        try {
            return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(content, Environment.class);
        }
        catch (JsonMappingException e) {
            throw new FlinkInitFailedException(MessageFormat.format(FlinkErrorCodeSummary.BOT_PARSE_ENVIRONMENT.getErrorDesc(), e.getMessage()), e);
        }
    }

    public static Environment merge(Environment env1, Environment env2) {
        if (null == env2) {
            return env1;
        }
        Environment mergedEnv = new Environment();
        LinkedHashMap<String, ModuleEntry> modules = new LinkedHashMap<String, ModuleEntry>(env1.getModules());
        modules.putAll(env2.getModules());
        mergedEnv.modules = modules;
        HashMap<String, CatalogEntry> catalogs = new HashMap<String, CatalogEntry>(env1.getCatalogs());
        catalogs.putAll(env2.getCatalogs());
        mergedEnv.catalogs = catalogs;
        LinkedHashMap<String, TableEntry> tables = new LinkedHashMap<String, TableEntry>(env1.getTables());
        tables.putAll(env2.getTables());
        mergedEnv.tables = tables;
        HashMap<String, FunctionEntry> functions = new HashMap<String, FunctionEntry>(env1.getFunctions());
        functions.putAll(env2.getFunctions());
        mergedEnv.functions = functions;
        mergedEnv.execution = ExecutionEntry.merge(env1.getExecution(), env2.getExecution());
        mergedEnv.configuration = ConfigurationEntry.merge(env1.getConfiguration(), env2.getConfiguration());
        mergedEnv.deployment = DeploymentEntry.merge(env1.getDeployment(), env2.getDeployment());
        return mergedEnv;
    }

    public Environment clone() {
        return Environment.enrich(this, Collections.emptyMap(), Collections.emptyMap());
    }

    public static Environment enrich(Environment env, Map<String, String> properties, Map<String, ViewEntry> views) {
        Environment enrichedEnv = new Environment();
        enrichedEnv.modules = new LinkedHashMap<String, ModuleEntry>(env.getModules());
        enrichedEnv.catalogs = new LinkedHashMap<String, CatalogEntry>(env.getCatalogs());
        enrichedEnv.tables = new LinkedHashMap<String, TableEntry>(env.getTables());
        enrichedEnv.tables.putAll(views);
        enrichedEnv.functions = new HashMap<String, FunctionEntry>(env.getFunctions());
        enrichedEnv.execution = ExecutionEntry.enrich(env.execution, properties);
        enrichedEnv.configuration = ConfigurationEntry.enrich(env.configuration, properties);
        enrichedEnv.deployment = DeploymentEntry.enrich(env.deployment, properties);
        return enrichedEnv;
    }
}

