/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.shims;

import java.lang.reflect.Constructor;
import java.util.concurrent.CompletableFuture;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;

public abstract class FlinkShims {
    private static FlinkShims flinkShims;
    protected String flinkVersion;

    public FlinkShims(String flinkVersion) {
        this.flinkVersion = flinkVersion;
    }

    private static FlinkShims loadShims(String flinkVersion) throws Exception {
        Class<?> flinkShimsClass;
        if (flinkVersion.equals("1.12.2")) {
            flinkShimsClass = Class.forName("org.apache.linkis.engineconnplugin.flink.client.shims.Flink1122Shims");
        } else if (flinkVersion.equals("1.16.2")) {
            flinkShimsClass = Class.forName("org.apache.linkis.engineconnplugin.flink.client.shims.Flink1162Shims");
        } else {
            throw new Exception("Flink version: '" + flinkVersion + "' is not supported yet");
        }
        Constructor<?> c = flinkShimsClass.getConstructor(String.class);
        return (FlinkShims)c.newInstance(flinkVersion);
    }

    public static FlinkShims getInstance(String flinkVersion) throws Exception {
        if (flinkShims == null) {
            flinkShims = FlinkShims.loadShims(flinkVersion);
        }
        return flinkShims;
    }

    public Object createTableEnvironment(Object flinkConfig, Object streamExecEnv, Object sessionState, ClassLoader classLoader) {
        return null;
    }

    public Object initializeTableEnvironment(Object environmentObject, Object flinkConfigObject, Object streamExecEnvObject, Object sessionStateObject, ClassLoader classLoader) throws SqlExecutionException {
        return null;
    }

    public abstract CompletableFuture<String> triggerSavepoint(Object var1, Object var2, String var3);

    public abstract CompletableFuture<String> cancelWithSavepoint(Object var1, Object var2, String var3);

    public abstract CompletableFuture<String> stopWithSavepoint(Object var1, Object var2, boolean var3, String var4);
}

