/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.validation.constraints.NotNull;
import org.apache.kylin.tool.garbage.StorageCleaner;

public abstract class AbstractComparableCleanTask
implements Runnable,
Comparable<AbstractComparableCleanTask> {
    private final CompletableFuture<Void> watcher = new CompletableFuture();

    public String getName() {
        return this.getClass().getName();
    }

    public String getBrief() {
        return String.format(Locale.ROOT, "Task-%s: {%s}", this.getName(), this.details());
    }

    protected String details() {
        return String.format(Locale.ROOT, "tag: %s, class: %s", new Object[]{this.getCleanerTag(), this.getClass().getName()});
    }

    public CompletableFuture<Void> getWatcher() {
        return this.watcher;
    }

    public abstract StorageCleaner.CleanerTag getCleanerTag();

    @Override
    public void run() {
        try {
            this.doRun();
            this.watcher.complete(null);
        }
        catch (Throwable t) {
            this.watcher.completeExceptionally(t);
        }
    }

    protected void doRun() {
    }

    @Override
    public int compareTo(@NotNull AbstractComparableCleanTask t) {
        if (this == t || this.getCleanerTag() == t.getCleanerTag()) {
            return 0;
        }
        if (this.getCleanerTag().ordinal() > t.getCleanerTag().ordinal()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractComparableCleanTask that = (AbstractComparableCleanTask)o;
        return Objects.equals(this.watcher, that.watcher) && Objects.equals((Object)this.getCleanerTag(), (Object)that.getCleanerTag());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.watcher, this.getCleanerTag()});
    }
}

