/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.kylin.common.BackwardCompatibilityConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfigCLI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinConfigCLI.class);

    public static void main(String[] args) {
        KylinConfigCLI.execute(args);
        Unsafe.systemExit((int)0);
    }

    public static void execute(String[] args) {
        boolean needDec = false;
        if (args.length != 1) {
            if (args.length < 2 || !Objects.equals("DEC", args[1])) {
                System.out.println("Usage: KylinConfigCLI conf_name");
                System.out.println("Example: KylinConfigCLI kylin.server.mode");
                Unsafe.systemExit((int)1);
            } else {
                needDec = true;
            }
        }
        Properties config = KylinConfig.getInstanceFromEnv().exportToProperties();
        BackwardCompatibilityConfig bcc = new BackwardCompatibilityConfig();
        String key = bcc.check(args[0].trim());
        if (!key.endsWith(".")) {
            String value = config.getProperty(key);
            if (value == null) {
                value = "";
            }
            if (needDec && EncryptUtil.isEncrypted((String)value)) {
                System.out.println(EncryptUtil.decryptPassInKylin((String)value));
            } else {
                System.out.println(value.trim());
            }
        } else {
            Map<String, String> props = KylinConfigCLI.getPropertiesByPrefix(config, key);
            for (Map.Entry<String, String> prop : props.entrySet()) {
                System.out.println(prop.getKey() + "=" + prop.getValue().trim());
            }
        }
    }

    private static Map<String, String> getPropertiesByPrefix(Properties props, String prefix) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (!entryKey.startsWith(prefix)) continue;
            result.put(entryKey.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }
}

