/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon.checker;

import java.util.Locale;
import org.apache.kylin.tool.daemon.CheckResult;
import org.apache.kylin.tool.daemon.CheckStateEnum;
import org.apache.kylin.tool.daemon.HealthChecker;
import org.apache.kylin.tool.daemon.Worker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealthChecker
extends Worker
implements HealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHealthChecker.class);
    private int priority = Integer.MAX_VALUE;

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected void preCheck() {
    }

    protected void postCheck(CheckResult result) {
    }

    abstract CheckResult doCheck();

    @Override
    public CheckResult check() {
        String message;
        logger.info("Checker:[{}] start to do check ...", (Object)this.getClass().getName());
        CheckResult result = null;
        try {
            this.preCheck();
            result = this.doCheck();
            this.postCheck(result);
            logger.info("Checker: [{}], do check finished! ", (Object)this.getClass().getName());
        }
        catch (Exception e) {
            logger.error("Checker: [{}], do check failed! ", (Object)this.getClass().getName(), (Object)e);
        }
        if (null == result) {
            message = String.format(Locale.ROOT, "Checker: [%s] check result is null!", this.getClass().getName());
            logger.warn(message);
            result = new CheckResult(CheckStateEnum.OTHER, message);
        }
        if (null == result.getCheckState()) {
            message = String.format(Locale.ROOT, "Checker: [%s] check result state is null!", this.getClass().getName());
            logger.warn(message);
            result.setCheckState(CheckStateEnum.OTHER);
            if (null == result.getReason()) {
                result.setReason(message);
            }
        }
        if (null == result.getReason()) {
            result.setReason("");
        }
        if (null == result.getCheckerName()) {
            result.setCheckerName(this.getClass().getName());
        }
        return result;
    }
}

