/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.domain.JobLock;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.job.util.JobInfoUtil;
import org.apache.kylin.tool.CancelableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobInfoTool
extends CancelableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String JOB_INFO_DIR = "job_info";
    private static final String ZIP_SUFFIX = ".zip";

    public void backup(String dir, String project) throws IOException {
        this.extractToHDFS(dir + "/" + JOB_INFO_DIR, project);
    }

    public void restore(String dir, boolean afterTruncate) throws IOException {
        Path path = new Path(dir + "/" + JOB_INFO_DIR);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        for (FileStatus fileStatus : fs.listStatus(path)) {
            String fileName = fileStatus.getPath().getName();
            String project = fileName.substring(0, fileName.indexOf("."));
            this.restoreProject(dir, project, afterTruncate);
        }
    }

    public void restoreProject(String dir, String project, boolean afterTruncate) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        Path path = new Path(dir + "/" + JOB_INFO_DIR + "/" + project + ZIP_SUFFIX);
        ArrayList jobInfos = Lists.newArrayList();
        try (ZipInputStream zis = new ZipInputStream((InputStream)fs.open(path));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));){
            while (zis.getNextEntry() != null) {
                String value = br.readLine();
                JobInfoHelper jobInfo = (JobInfoHelper)((Object)JsonUtil.readValue((String)value, JobInfoHelper.class));
                jobInfo.setJobContent();
                jobInfos.add(jobInfo);
            }
        }
        JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).restoreJobInfo((List)jobInfos, project, afterTruncate);
    }

    public void extractFull(File dir) {
        JobMapperFilter filter = JobMapperFilter.builder().build();
        List jobs = JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobInfoListByFilter(filter);
        for (JobInfo job : jobs) {
            this.saveJobToFile(job, dir);
        }
    }

    public void extractFull(File dir, long startTime, long endTime) {
        JobMapperFilter filter = JobMapperFilter.builder().timeRange(Arrays.asList(startTime, endTime)).build();
        List jobs = JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobInfoListByFilter(filter);
        for (JobInfo job : jobs) {
            this.saveJobToFile(job, dir);
        }
    }

    public void extractJob(File dir, String project, String jobId) {
        JobMapperFilter filter = JobMapperFilter.builder().project(project).jobId(jobId).build();
        List jobs = JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobInfoListByFilter(filter);
        if (jobs.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Job id {%s} not found.", jobId));
        }
        this.saveJobToFile((JobInfo)jobs.get(0), dir);
    }

    private void saveJobToFile(JobInfo job, File dir) {
        File jobFile = new File(dir, job.getJobId());
        try (OutputStream os = Files.newOutputStream(jobFile.toPath(), new OpenOption[0]);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, Charset.defaultCharset()));){
            bw.write(JsonUtil.writeValueAsString((Object)((Object)new JobInfoHelper(job))));
            bw.newLine();
        }
        catch (Exception e) {
            logger.error("Write error, id is {}", (Object)job.getId(), (Object)e);
        }
    }

    public void extractJobLock(File dir) throws Exception {
        List jobLocks = JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).fetchAllJobLock();
        File jobLockFile = new File(dir, "job_lock");
        try (FileOutputStream os = new FileOutputStream(jobLockFile);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, Charset.defaultCharset()));){
            for (JobLock line : jobLocks) {
                try {
                    bw.write(JsonUtil.writeValueAsString((Object)line));
                    bw.newLine();
                }
                catch (Exception e) {
                    logger.error("Write error, id is {}", (Object)line.getId(), (Object)e);
                }
            }
        }
    }

    public void extractToHDFS(String dir, String project) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        String filePathStr = dir + "/" + project + ZIP_SUFFIX;
        try (FSDataOutputStream fos = fs.create(new Path(filePathStr));
             ZipOutputStream zos = new ZipOutputStream((OutputStream)fos);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)zos, Charset.defaultCharset()));){
            JobMapperFilter filter = JobMapperFilter.builder().project(project).build();
            List jobs = JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobInfoListByFilter(filter);
            Iterator iterator = jobs.iterator();
            while (true) {
                if (iterator.hasNext()) {
                    JobInfo job = (JobInfo)iterator.next();
                    zos.putNextEntry(new ZipEntry(job.getJobId() + ".json"));
                    String value = JsonUtil.writeValueAsString((Object)((Object)new JobInfoHelper(job)));
                    bw.write(value);
                    bw.flush();
                    if (!this.isCanceled()) continue;
                    logger.info("job info backup was canceled.");
                    return;
                    continue;
                }
                break;
            }
        }
    }

    public void backupToLocal(String dir, String project) throws IOException {
        String extractDir = this.prepareLocalBackupDir(dir, project);
        JobMapperFilter filter = JobMapperFilter.builder().project(project).build();
        List jobs = JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobInfoListByFilter(filter);
        for (JobInfo job : jobs) {
            String fileName = extractDir + job.getJobId() + ".json";
            BufferedWriter bf = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(new File(fileName).toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                String value = JsonUtil.writeValueAsString((Object)((Object)new JobInfoHelper(job)));
                bf.write(value);
                bf.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bf == null) continue;
                if (throwable != null) {
                    try {
                        bf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bf.close();
            }
        }
    }

    private String prepareLocalBackupDir(String dir, String project) throws IOException {
        String extractDirPath;
        File extractDir;
        String jobInfoDirPath;
        File jobInfoDir;
        File rootDir = new File(dir);
        if (!rootDir.exists()) {
            FileUtils.forceMkdir((File)rootDir);
        }
        if (!(jobInfoDir = new File(jobInfoDirPath = StringUtils.appendIfMissing((String)dir, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + JOB_INFO_DIR)).exists()) {
            FileUtils.forceMkdir((File)jobInfoDir);
        }
        if (!(extractDir = new File(extractDirPath = jobInfoDirPath + "/" + project + "/")).exists()) {
            FileUtils.forceMkdir((File)extractDir);
        }
        return extractDirPath;
    }

    public void restoreFromLocal(String dir, boolean afterTruncate) throws IOException {
        File[] projectDirs;
        String restorePath = dir + "/" + JOB_INFO_DIR;
        File restoreDir = new File(restorePath);
        if (!restoreDir.exists()) {
            return;
        }
        for (File projectDir : projectDirs = restoreDir.listFiles()) {
            String project = projectDir.getName();
            this.restoreProjectFromLocal(dir, project, afterTruncate);
        }
    }

    public void restoreProjectFromLocal(String dir, String project, boolean afterTruncate) throws IOException {
        String restoreProjectPath = dir + "/" + JOB_INFO_DIR + "/" + project;
        File restoreProjectDir = new File(restoreProjectPath);
        if (!restoreProjectDir.exists()) {
            return;
        }
        File[] jsonFiles = restoreProjectDir.listFiles();
        ArrayList jobInfos = Lists.newArrayList();
        assert (jsonFiles != null);
        for (File jsonFile : jsonFiles) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                String value = br.readLine();
                JobInfoHelper jobInfo = (JobInfoHelper)((Object)JsonUtil.readValue((String)value, JobInfoHelper.class));
                jobInfo.setJobContent();
                jobInfos.add(jobInfo);
            }
        }
        JobContextUtil.getJobInfoDao((KylinConfig)KylinConfig.getInstanceFromEnv()).restoreJobInfo((List)jobInfos, project, afterTruncate);
    }

    static class JobInfoHelper
    extends JobInfo {
        private ExecutablePO jobContentJson;

        public JobInfoHelper() {
        }

        public JobInfoHelper(JobInfo jobInfo) {
            this.setId(jobInfo.getId());
            this.setCreateTime(jobInfo.getCreateTime());
            this.setJobDurationMillis(jobInfo.getJobDurationMillis());
            this.setJobId(jobInfo.getJobId());
            this.setJobStatus(jobInfo.getJobStatus());
            this.setJobType(jobInfo.getJobType());
            this.setModelId(jobInfo.getModelId());
            this.setMvcc(jobInfo.getMvcc());
            this.setProject(jobInfo.getProject());
            this.setSubject(jobInfo.getSubject());
            this.setUpdateTime(jobInfo.getUpdateTime());
            this.setPriority(jobInfo.getPriority());
            this.jobContentJson = JobInfoUtil.deserializeExecutablePO((JobInfo)jobInfo);
        }

        public ExecutablePO getJobContentJson() {
            return this.jobContentJson;
        }

        public void setJobContent() {
            this.setJobContent(JobInfoUtil.serializeExecutablePO((ExecutablePO)this.jobContentJson));
        }
    }
}

