/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import org.apache.spark.TaskSummary;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class TaskSummary$ {
    public static TaskSummary$ MODULE$;

    static {
        new TaskSummary$();
    }

    public TaskSummary apply(TaskData task) {
        long totalExecutionTime = BoxesRunTime.unboxToLong((Object)task.duration().getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> -1L));
        Option metricsOpt = task.taskMetrics();
        long jvmGcTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.jvmGcTime())).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        double jvmGcTimeProportion = TaskSummary$.toProportion$1(jvmGcTime, totalExecutionTime);
        long serializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.resultSerializationTime())).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        double serializationTimeProportion = TaskSummary$.toProportion$1(serializationTime, totalExecutionTime);
        long deserializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.executorDeserializeTime())).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        double deserializationTimeProportion = TaskSummary$.toProportion$1(deserializationTime, totalExecutionTime);
        long shuffleReadTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$8 -> BoxesRunTime.boxToLong((long)TaskSummary$.$anonfun$apply$11(x$8))).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        double shuffleReadTimeProportion = TaskSummary$.toProportion$1(shuffleReadTime, totalExecutionTime);
        long shuffleWriteTime = (long)((double)BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$9 -> BoxesRunTime.boxToLong((long)TaskSummary$.$anonfun$apply$13(x$9))).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L)) / 1000000.0);
        double shuffleWriteTimeProportion = TaskSummary$.toProportion$1(shuffleWriteTime, totalExecutionTime);
        long inputBytes = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$10 -> BoxesRunTime.boxToLong((long)TaskSummary$.$anonfun$apply$15(x$10))).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        long inputRecord = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$11 -> BoxesRunTime.boxToLong((long)TaskSummary$.$anonfun$apply$17(x$11))).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        long outputBytes = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$12 -> BoxesRunTime.boxToLong((long)TaskSummary$.$anonfun$apply$19(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        long outputRecord = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1 & java.io.Serializable & Serializable)x$13 -> BoxesRunTime.boxToLong((long)TaskSummary$.$anonfun$apply$21(x$13))).getOrElse((Function0)(JFunction0.mcJ.sp & java.io.Serializable & Serializable)() -> 0L));
        return new TaskSummary(task.taskId(), task.executorId(), totalExecutionTime, jvmGcTime, jvmGcTimeProportion, serializationTime, serializationTimeProportion, deserializationTime, deserializationTimeProportion, shuffleReadTime, shuffleReadTimeProportion, shuffleWriteTime, shuffleWriteTimeProportion, inputBytes, inputRecord, outputBytes, outputRecord);
    }

    public Seq<String> schema() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"taskId", "executorId", "totalExecutionTime", "jvmGcTime", "jvmGcTimeProportion", "serializationTime", "serializationTimeProportion", "deserializationTime", "deserializationTimeProportion", "shuffleReadTime", "shuffleReadTimeProportion", "shuffleWriteTime", "shuffleWriteTimeProportion", "taskInputBytes", "taskInputRecords", "taskOutputBytes", "taskOutputRecords"}));
    }

    public TaskSummary invalid() {
        return new TaskSummary(-1L, "invalid", -1L, -1L, -1.0, -1L, -1.0, -1L, -1.0, -1L, -1.0, -1L, -1.0, -1L, -1L, -1L, -1L);
    }

    private static final double toProportion$1(long time, long totalExecutionTime$1) {
        return new StringOps(Predef$.MODULE$.augmentString(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)((double)time / (double)totalExecutionTime$1 * (double)100))), "%.2f"))).toDouble();
    }

    public static final /* synthetic */ long $anonfun$apply$11(TaskMetrics x$8) {
        return x$8.shuffleReadMetrics().fetchWaitTime();
    }

    public static final /* synthetic */ long $anonfun$apply$13(TaskMetrics x$9) {
        return x$9.shuffleWriteMetrics().writeTime();
    }

    public static final /* synthetic */ long $anonfun$apply$15(TaskMetrics x$10) {
        return x$10.inputMetrics().bytesRead();
    }

    public static final /* synthetic */ long $anonfun$apply$17(TaskMetrics x$11) {
        return x$11.inputMetrics().recordsRead();
    }

    public static final /* synthetic */ long $anonfun$apply$19(TaskMetrics x$12) {
        return x$12.outputMetrics().bytesWritten();
    }

    public static final /* synthetic */ long $anonfun$apply$21(TaskMetrics x$13) {
        return x$13.outputMetrics().recordsWritten();
    }

    private TaskSummary$() {
        MODULE$ = this;
    }
}

