/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.sdk.datasource.framework.SourceConnectorFactory;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.jdbc.JdbcExplorer;
import org.apache.kylin.source.jdbc.JdbcSourceInput;
import org.apache.kylin.source.jdbc.JdbcTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSource
implements ISource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcSource.class);
    private JdbcConnector dataSource;

    @VisibleForTesting
    public JdbcConnector getDataSource() {
        return this.dataSource;
    }

    public JdbcSource(KylinConfig config) {
        try {
            this.dataSource = SourceConnectorFactory.getJdbcConnector((KylinConfig)config);
        }
        catch (Exception e) {
            log.error("DataSource cannot be connected.");
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_JDBC_SOURCE_CONFIG, MsgPicker.getMsg().getJdbcConnectionInfoWrong(), (Throwable)e);
        }
    }

    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == NSparkCubingEngine.NSparkCubingSource.class) {
            return (I)new JdbcSourceInput();
        }
        throw new IllegalArgumentException("Unsupported engine interface: " + engineInterface);
    }

    public IReadableTable createReadableTable(TableDesc tableDesc) {
        return new JdbcTable(this.dataSource, tableDesc);
    }

    public SegmentRange enrichSourcePartitionBeforeBuild(IBuildable buildable, SegmentRange segmentRange) {
        return segmentRange;
    }

    public ISourceMetadataExplorer getSourceMetadataExplorer() {
        return new JdbcExplorer(this.dataSource);
    }

    public ISampleDataDeployer getSampleDataDeployer() {
        return new JdbcExplorer(this.dataSource);
    }

    public SegmentRange getSegmentRange(String start, String end) {
        start = StringUtils.isEmpty((CharSequence)start) ? "0" : start;
        end = StringUtils.isEmpty((CharSequence)end) ? "9223372036854775807" : end;
        return new SegmentRange.TimePartitionedSegmentRange(Long.valueOf(Long.parseLong(start)), Long.valueOf(Long.parseLong(end)));
    }

    public void close() throws IOException {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    public boolean supportBuildSnapShotByPartition() {
        return false;
    }
}

