/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.HiveTableMetaBuilder;
import org.apache.kylin.source.hive.IHiveClient;

public class BeelineHiveClient
implements IHiveClient {
    private Connection cnct;
    private Statement stmt;
    private DatabaseMetaData metaData;

    public BeelineHiveClient(String beelineParams) {
        if (StringUtils.isEmpty((CharSequence)beelineParams)) {
            throw new IllegalArgumentException("BeelineParames cannot be empty");
        }
        String[] splits = StringUtils.split((String)beelineParams);
        String url = null;
        String username = null;
        String password = null;
        for (int i = 0; i < splits.length; ++i) {
            if ("-u".equals(splits[i])) {
                url = this.stripQuotes(splits[i + 1]);
            }
            if ("-n".equals(splits[i])) {
                username = this.stripQuotes(splits[i + 1]);
            }
            if (!"-p".equals(splits[i])) continue;
            password = this.stripQuotes(splits[i + 1]);
        }
        this.init(url, username, password);
    }

    public static void main(String[] args) throws SQLException {
        BeelineHiveClient loader = new BeelineHiveClient("-n root --hiveconf hive.security.authorization.sqlstd.confwhitelist.append='mapreduce.job.*|dfs.*' -u 'jdbc:hive2://sandbox:10000'");
        HiveTableMeta hiveTableMeta = loader.getHiveTableMeta("default", "test_kylin_fact_part");
        System.out.println(hiveTableMeta);
        loader.close();
    }

    private void init(String url, String username, String password) {
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
            this.cnct = DriverManager.getConnection(url, username, password);
            this.stmt = this.cnct.createStatement();
            this.metaData = this.cnct.getMetaData();
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private String stripQuotes(String input) {
        if (input.startsWith("'") && input.endsWith("'")) {
            return StringUtils.strip((String)input, (String)"'");
        }
        if (input.startsWith("\"") && input.endsWith("\"")) {
            return StringUtils.strip((String)input, (String)"\"");
        }
        return input;
    }

    @Override
    public List<String> getHiveDbNames() throws Exception {
        ArrayList ret = Lists.newArrayList();
        ResultSet schemas = this.metaData.getSchemas();
        while (schemas.next()) {
            ret.add(String.valueOf(schemas.getObject(1)));
        }
        DBUtils.closeQuietly((ResultSet)schemas);
        return ret;
    }

    @Override
    public List<String> getHiveTableNames(String database) throws Exception {
        ArrayList ret = Lists.newArrayList();
        ResultSet tables = this.metaData.getTables(null, database, null, null);
        while (tables.next()) {
            ret.add(String.valueOf(tables.getObject(3)));
        }
        DBUtils.closeQuietly((ResultSet)tables);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHiveTableRows(String database, String tableName) throws Exception {
        ResultSet resultSet = null;
        long count = 0L;
        try {
            resultSet = this.stmt.executeQuery("select count(*) from " + database + "." + tableName);
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(resultSet);
            throw throwable;
        }
        DBUtils.closeQuietly((ResultSet)resultSet);
        return count;
    }

    @Override
    public void executeHQL(String hql) throws CommandNeedRetryException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeHQL(String[] hqls) throws CommandNeedRetryException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public HiveTableMeta getHiveTableMeta(String database, String tableName) throws SQLException {
        ResultSet columns = this.metaData.getColumns(null, database, tableName, null);
        HiveTableMetaBuilder builder = new HiveTableMetaBuilder();
        builder.setTableName(tableName);
        ArrayList allColumns = Lists.newArrayList();
        while (columns.next()) {
            allColumns.add(new HiveTableMeta.HiveTableColumnMeta(columns.getString(4), columns.getString(6), columns.getString(12)));
        }
        builder.setAllColumns(allColumns);
        DBUtils.closeQuietly((ResultSet)columns);
        this.stmt.execute("use " + database);
        ResultSet resultSet = this.stmt.executeQuery("describe formatted " + tableName);
        this.extractHiveTableMeta(resultSet, builder);
        DBUtils.closeQuietly((ResultSet)resultSet);
        return builder.createHiveTableMeta();
    }

    private void extractHiveTableMeta(ResultSet resultSet, HiveTableMetaBuilder builder) throws SQLException {
        while (resultSet.next()) {
            ArrayList partitionColumns = Lists.newArrayList();
            if ("# Partition Information".equals(resultSet.getString(1).trim())) {
                resultSet.next();
                Preconditions.checkArgument((boolean)"# col_name".equals(resultSet.getString(1).trim()));
                resultSet.next();
                Preconditions.checkArgument((boolean)"".equals(resultSet.getString(1).trim()));
                while (resultSet.next() && !"".equals(resultSet.getString(1).trim())) {
                    partitionColumns.add(new HiveTableMeta.HiveTableColumnMeta(resultSet.getString(1).trim(), resultSet.getString(2).trim(), resultSet.getString(3).trim()));
                }
                builder.setPartitionColumns(partitionColumns);
            }
            if ("Owner:".equals(resultSet.getString(1).trim())) {
                builder.setOwner(resultSet.getString(2).trim());
            }
            if ("LastAccessTime:".equals(resultSet.getString(1).trim())) {
                try {
                    int i = Integer.parseInt(resultSet.getString(2).trim());
                    builder.setLastAccessTime(i);
                }
                catch (NumberFormatException e) {
                    builder.setLastAccessTime(0);
                }
            }
            if ("Location:".equals(resultSet.getString(1).trim())) {
                builder.setSdLocation(resultSet.getString(2).trim());
            }
            if ("Table Type:".equals(resultSet.getString(1).trim())) {
                builder.setTableType(resultSet.getString(2).trim());
            }
            if ("Table Parameters:".equals(resultSet.getString(1).trim())) {
                while (resultSet.next() && resultSet.getString(2) != null) {
                    if ("storage_handler".equals(resultSet.getString(2).trim())) {
                        builder.setIsNative(false);
                    }
                    if ("totalSize".equals(resultSet.getString(2).trim())) {
                        builder.setFileSize(Long.parseLong(resultSet.getString(3).trim()));
                    }
                    if ("numFiles".equals(resultSet.getString(2).trim())) {
                        builder.setFileNum(Long.parseLong(resultSet.getString(3).trim()));
                    }
                    if (!"skip.header.line.count".equals(resultSet.getString(2).trim())) continue;
                    builder.setSkipHeaderLineCount(resultSet.getString(3).trim());
                }
            }
            if ("InputFormat:".equals(resultSet.getString(1).trim())) {
                builder.setSdInputFormat(resultSet.getString(2).trim());
            }
            if (!"OutputFormat:".equals(resultSet.getString(1).trim())) continue;
            builder.setSdOutputFormat(resultSet.getString(2).trim());
        }
    }

    public void close() {
        DBUtils.closeQuietly((Statement)this.stmt);
        DBUtils.closeQuietly((Connection)this.cnct);
    }
}

