/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.job.StorageCleanType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanupJob
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(StorageCleanupJob.class);
    public static final int DEFAULT_CLEANUP_HOUR_THRESHOLD = 168;
    public static final boolean DEFAULT_CLEANUP_DICT = true;
    public static final boolean DEFAULT_CLEANUP_SNAPSHOT = true;
    public static final boolean DEFAULT_CLEANUP_JOB_TMP = false;
    public static final boolean DEFAULT_CLEANUP = false;
    private static final String GLOBAL_DICT_PREFIX = "/dict/global_dict/";
    private static final String TABLE_SNAPSHOT_PREFIX = "/table_snapshot/";
    protected static final Option OPTION_HELP;
    protected static final Option OPTION_DELETE;
    protected static final Option OPTION_CLEANUP_TABLE_SNAPSHOT;
    protected static final Option OPTION_CLEANUP_GLOBAL_DICT;
    protected static final Option OPTION_CLEANUP_JOB_TMP;
    protected static final Option OPTION_CLEANUP_THRESHOLD_HOUR;
    protected final KylinConfig config;
    protected final FileSystem fs;
    protected final ExecutableManager executableManager;
    protected boolean delete = false;
    protected boolean cleanupTableSnapshot = true;
    protected boolean cleanupGlobalDict = true;
    protected boolean cleanupJobTmp = false;
    protected int cleanupThreshold = 168;
    protected long storageTimeCut;
    protected static final List<String> protectedDir;
    protected static PathFilter pathFilter;

    public StorageCleanupJob() throws IOException {
        this(KylinConfig.getInstanceFromEnv(), HadoopUtil.getWorkingFileSystem((Configuration)HadoopUtil.getCurrentConfiguration()));
    }

    public StorageCleanupJob(KylinConfig config, FileSystem fs) {
        this.config = config;
        this.fs = fs;
        this.executableManager = ExecutableManager.getInstance((KylinConfig)config);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_HELP);
        options.addOption(OPTION_DELETE);
        options.addOption(OPTION_CLEANUP_GLOBAL_DICT);
        options.addOption(OPTION_CLEANUP_TABLE_SNAPSHOT);
        options.addOption(OPTION_CLEANUP_JOB_TMP);
        options.addOption(OPTION_CLEANUP_THRESHOLD_HOUR);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        logger.info("options: '" + optionsHelper.getOptionsAsString() + "'");
        this.delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        if (optionsHelper.hasOption(OPTION_CLEANUP_TABLE_SNAPSHOT)) {
            this.cleanupTableSnapshot = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_CLEANUP_TABLE_SNAPSHOT));
        }
        if (optionsHelper.hasOption(OPTION_CLEANUP_GLOBAL_DICT)) {
            this.cleanupGlobalDict = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_CLEANUP_GLOBAL_DICT));
        }
        if (optionsHelper.hasOption(OPTION_CLEANUP_JOB_TMP)) {
            this.cleanupJobTmp = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_CLEANUP_JOB_TMP));
        }
        if (optionsHelper.hasOption(OPTION_CLEANUP_THRESHOLD_HOUR)) {
            this.cleanupThreshold = Integer.parseInt(optionsHelper.getOptionValue(OPTION_CLEANUP_THRESHOLD_HOUR));
        }
        this.storageTimeCut = System.currentTimeMillis() - (long)(this.cleanupThreshold * 3600) * 1000L;
        Date cleanBeforeDate = new Date(this.storageTimeCut);
        logger.info("===================================================================\ndelete : {}; cleanupTableSnapshot : {}; cleanupGlobalDict : {}; cleanupJobTmp : {}; cleanBeforeDate : {}.", new Object[]{this.delete, this.cleanupTableSnapshot, this.cleanupGlobalDict, this.cleanupJobTmp, cleanBeforeDate});
        this.cleanup();
    }

    public void cleanup() throws Exception {
        FileStatus[] projectStatus;
        ProjectManager projectManager = ProjectManager.getInstance((KylinConfig)this.config);
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        List projects = projectManager.listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        logger.info("Start to clean up unreferenced projects and cubes ...");
        List cubes = cubeManager.listAllCubes();
        Path metadataPath = new Path(this.config.getHdfsWorkingDirectory());
        if (this.fs.exists(metadataPath) && (projectStatus = this.fs.listStatus(metadataPath, pathFilter)) != null) {
            for (FileStatus status : projectStatus) {
                if (!this.eligibleStorage(status)) continue;
                String projectName = status.getPath().getName();
                if (!projects.contains(projectName)) {
                    this.deleteOp(status.getPath(), StorageCleanType.PROJECT_DIR);
                    continue;
                }
                this.cleanupGlobalDict(projectName, cubes.stream().filter(cube -> projectName.equals(cube.getProject())).collect(Collectors.toList()));
                this.cleanupTableSnapshot(projectName, cubes.stream().filter(cube -> projectName.equals(cube.getProject())).collect(Collectors.toList()));
                this.cleanupDeletedCubes(projectName, cubes.stream().map(CubeInstance::getName).collect(Collectors.toList()));
            }
        }
        logger.info("Start to clean up no unreferenced segments ...");
        for (CubeInstance cube2 : cubes) {
            List segments = cube2.getSegments().stream().map(segment -> segment.getName() + "_" + segment.getStorageLocationIdentifier()).collect(Collectors.toList());
            String project = cube2.getProject();
            Path cubePath = new Path(this.config.getHdfsWorkingDirectory(project) + "/parquet/" + cube2.getName());
            if (this.fs.exists(cubePath)) {
                FileStatus[] segmentStatus = this.fs.listStatus(cubePath);
                if (segmentStatus == null) continue;
                for (FileStatus status : segmentStatus) {
                    String segment2;
                    if (!this.eligibleStorage(status) || segments.contains(segment2 = status.getPath().getName())) continue;
                    this.deleteOp(status.getPath(), StorageCleanType.SEGMENT_DIR);
                }
                continue;
            }
            logger.warn("Cube path doesn't exist! The path is {}", (Object)cubePath);
        }
        if (this.cleanupJobTmp) {
            logger.info("Start to clean up stale job_tmp ...");
            for (String prj : projects) {
                FileStatus[] jobTmpPaths;
                Path prjPath = new Path(this.config.getJobTmpDir(prj));
                for (FileStatus status : jobTmpPaths = this.fs.listStatus(prjPath)) {
                    if (!this.eligibleStorage(status)) continue;
                    this.deleteOp(status.getPath(), StorageCleanType.JOB_TMP);
                }
            }
        }
    }

    private void cleanupDeletedCubes(String project, List<String> cubes) throws Exception {
        FileStatus[] cubeStatus;
        Path parquetPath = new Path(this.config.getHdfsWorkingDirectory(project) + "/parquet");
        if (this.fs.exists(parquetPath) && (cubeStatus = this.fs.listStatus(parquetPath)) != null) {
            for (FileStatus status : cubeStatus) {
                String cubeName;
                if (!this.eligibleStorage(status) || cubes.contains(cubeName = status.getPath().getName())) continue;
                this.deleteOp(status.getPath(), StorageCleanType.CUBE_DIR);
            }
        }
    }

    private void cleanupTableSnapshot(String project, List<CubeInstance> cubes) throws IOException {
        if (!this.cleanupTableSnapshot) {
            return;
        }
        Path tableSnapshotPath = new Path(this.config.getHdfsWorkingDirectory(project) + TABLE_SNAPSHOT_PREFIX);
        ArrayList<Path> toDeleteSnapshot = new ArrayList<Path>();
        if (this.fs.exists(tableSnapshotPath)) {
            for (FileStatus status : this.fs.listStatus(tableSnapshotPath)) {
                for (FileStatus tableSnapshot : this.fs.listStatus(status.getPath())) {
                    if (!this.eligibleStorage(tableSnapshot)) continue;
                    toDeleteSnapshot.add(tableSnapshot.getPath());
                }
            }
        }
        for (CubeInstance cube : cubes) {
            for (CubeSegment segment : cube.getSegments()) {
                for (String snapshotPath : segment.getSnapshotPaths()) {
                    Path path = new Path(this.config.getHdfsWorkingDirectory() + File.separator + snapshotPath);
                    toDeleteSnapshot.remove(path);
                }
            }
        }
        for (Path path : toDeleteSnapshot) {
            this.deleteOp(path, StorageCleanType.TABLE_SNAPSHOT);
        }
    }

    private void cleanupGlobalDict(String project, List<CubeInstance> cubes) throws IOException {
        if (!this.cleanupGlobalDict) {
            return;
        }
        Path dictPath = new Path(this.config.getHdfsWorkingDirectory(project) + GLOBAL_DICT_PREFIX);
        ArrayList<Path> toDeleteDict = new ArrayList<Path>();
        if (this.fs.exists(dictPath)) {
            for (FileStatus tables : this.fs.listStatus(dictPath)) {
                for (FileStatus columns : this.fs.listStatus(tables.getPath())) {
                    if (!this.eligibleStorage(columns)) continue;
                    toDeleteDict.add(columns.getPath());
                }
            }
        }
        for (CubeInstance cube : cubes) {
            if (cube.getDescriptor().getDictionaries() == null) continue;
            for (DictionaryDesc dictionaryDesc : cube.getDescriptor().getDictionaries()) {
                String[] columnInfo = dictionaryDesc.getColumnRef().getColumnWithTable().split("\\.");
                Path globalDictPath = columnInfo.length == 3 ? new Path(dictPath + File.separator + columnInfo[1] + File.separator + columnInfo[2]) : new Path(dictPath + File.separator + columnInfo[0] + File.separator + columnInfo[1]);
                if (globalDictPath == null) continue;
                toDeleteDict.remove(globalDictPath);
            }
        }
        for (Path path : toDeleteDict) {
            this.deleteOp(path, StorageCleanType.GLOBAL_DICTIONARY);
        }
    }

    private void deleteOp(Path path, StorageCleanType type) throws IOException {
        if (this.delete) {
            logger.info("Deleting unreferenced {}, {}", (Object)type, (Object)path);
            this.fs.delete(path, true);
        } else {
            logger.info("Dry run, pending delete unreferenced path {}, {}", (Object)type, (Object)path);
        }
    }

    private boolean eligibleStorage(FileStatus status) {
        return status != null && status.getModificationTime() < this.storageTimeCut;
    }

    static {
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Print supported operations.");
        OPTION_HELP = OptionBuilder.create((String)"help");
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withType((Object)Boolean.class.getName());
        OptionBuilder.withDescription((String)"Boolean, whether or not to do real delete operation. Default value is false, means a dry run.");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        OptionBuilder.withArgName((String)"cleanupTableSnapshot");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withType((Object)Boolean.class.getName());
        OptionBuilder.withDescription((String)"Boolean, whether or not to delete unreferenced snapshot files. Default value is true .");
        OPTION_CLEANUP_TABLE_SNAPSHOT = OptionBuilder.create((String)"cleanupTableSnapshot");
        OptionBuilder.withArgName((String)"cleanupGlobalDict");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withType((Object)Boolean.class.getName());
        OptionBuilder.withDescription((String)"Boolean, whether or not to delete unreferenced global dict files. Default value is true .");
        OPTION_CLEANUP_GLOBAL_DICT = OptionBuilder.create((String)"cleanupGlobalDict");
        OptionBuilder.withArgName((String)"cleanupJobTmp");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withType((Object)Boolean.class.getName());
        OptionBuilder.withDescription((String)"Boolean, whether or not to delete job tmp files. Default value is false .");
        OPTION_CLEANUP_JOB_TMP = OptionBuilder.create((String)"cleanupJobTmp");
        OptionBuilder.withArgName((String)"cleanupThreshold");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withType((Object)Integer.class.getName());
        OptionBuilder.withDescription((String)"Integer, used to specific delete unreferenced storage that have not been modified before how many hours (recent files are protected). Default value is 168 hours.");
        OPTION_CLEANUP_THRESHOLD_HOUR = OptionBuilder.create((String)"cleanupThreshold");
        protectedDir = Arrays.asList("cube_statistics", "resources-jdbc", "_sparder_logs");
        pathFilter = status -> !protectedDir.contains(status.getName());
    }
}

