/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.init;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ServerMode;
import org.apache.spark.sql.SparderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class InitialSparderContext
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(InitialSparderContext.class);

    public void afterPropertiesSet() throws Exception {
        this.runInitialSparder();
    }

    private void runInitialSparder() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!ServerMode.SERVER_MODE.canServeQuery() || !config.isAutoStartSparder()) {
            logger.info("Maybe this is job node, or switch is off, do not need to start Spark, {}", (Object)config.isAutoStartSparder());
            return;
        }
        logger.info("Spark is starting.....");
        SparderContext.init();
    }
}

