/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.CsvColumnDesc;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.response.TableDescResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.KafkaConfigService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.StreamingService;
import org.apache.kylin.rest.service.TableSchemaUpdateChecker;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.base.Predicate;
import org.apache.kylin.shaded.com.google.common.collect.Iterables;
import org.apache.kylin.shaded.com.google.common.collect.LinkedHashMultimap;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component(value="tableService")
public class TableService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableService.class);
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="streamingMgmtService")
    private StreamingService streamingService;
    @Autowired
    @Qualifier(value="kafkaMgmtService")
    private KafkaConfigService kafkaConfigService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public List<TableDesc> getTableDescByProject(String project, boolean withExt) throws IOException {
        this.aclEvaluate.checkProjectReadPermission(project);
        List<TableDesc> tables = this.getProjectManager().listDefinedTables(project);
        if (null == tables) {
            return Collections.emptyList();
        }
        if (withExt) {
            this.aclEvaluate.checkProjectWritePermission(project);
            tables = this.cloneTableDesc(tables, project);
        }
        return tables;
    }

    public TableDesc getTableDescByName(String tableName, boolean withExt, String prj) {
        this.aclEvaluate.checkProjectReadPermission(prj);
        TableDesc table = this.getTableManager().getTableDesc(tableName, prj);
        if (withExt) {
            this.aclEvaluate.checkProjectWritePermission(prj);
            table = this.cloneTableDesc(table, prj);
        }
        return table;
    }

    public String[] loadHiveTablesToProject(String[] hiveTables, String project) throws Exception {
        this.aclEvaluate.checkProjectAdminPermission(project);
        List<Pair<TableDesc, TableExtDesc>> allMeta = this.extractHiveTableMeta(hiveTables, project);
        return this.loadTablesToProject(allMeta, project);
    }

    public String[] loadTableToProject(TableDesc tableDesc, TableExtDesc extDesc, String project) throws IOException {
        return this.loadTablesToProject(Lists.newArrayList((Object[])new Pair[]{Pair.newPair((Object)tableDesc, (Object)extDesc)}), project);
    }

    private String[] loadTablesToProject(List<Pair<TableDesc, TableExtDesc>> allMeta, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        TableMetadataManager metaMgr = this.getTableManager();
        CubeManager cubeMgr = this.getCubeManager();
        TableSchemaUpdateChecker checker = new TableSchemaUpdateChecker(metaMgr, cubeMgr, this.getDataModelManager());
        for (Pair<TableDesc, TableExtDesc> pair : allMeta) {
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            TableSchemaUpdateChecker.CheckResult result = checker.allowReload(tableDesc, project);
            result.raiseExceptionWhenInvalid();
        }
        ArrayList saved = Lists.newArrayList();
        for (Pair<TableDesc, TableExtDesc> pair : allMeta) {
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            TableExtDesc extDesc = (TableExtDesc)pair.getSecond();
            TableDesc origTable = metaMgr.getTableDesc(tableDesc.getIdentity(), project);
            if (origTable == null || origTable.getProject() == null) {
                tableDesc.setUuid(RandomUtil.randomUUID().toString());
                tableDesc.setLastModified(0L);
            } else {
                tableDesc.setUuid(origTable.getUuid());
                tableDesc.setLastModified(origTable.getLastModified());
            }
            metaMgr.saveSourceTable(tableDesc, project);
            if (extDesc != null) {
                TableExtDesc origExt = metaMgr.getTableExt(tableDesc.getIdentity(), project);
                if (origExt == null || origExt.getProject() == null) {
                    extDesc.setUuid(UUID.randomUUID().toString());
                    extDesc.setLastModified(0L);
                } else {
                    extDesc.setUuid(origExt.getUuid());
                    extDesc.setLastModified(origExt.getLastModified());
                }
                extDesc.init(project);
                metaMgr.saveTableExt(extDesc, project);
            }
            saved.add(tableDesc.getIdentity());
        }
        String[] stringArray = saved.toArray(new String[saved.size()]);
        this.addTableToProject(stringArray, project);
        return stringArray;
    }

    public List<Pair<TableDesc, TableExtDesc>> extractHiveTableMeta(String[] tables, String project) throws Exception {
        LinkedHashMultimap db2tables = LinkedHashMultimap.create();
        for (String fullTableName : tables) {
            String[] parts = HadoopUtil.parseHiveTableName((String)fullTableName);
            db2tables.put((Object)parts[0], (Object)parts[1]);
        }
        ArrayList allMeta = Lists.newArrayList();
        ProjectInstance projectInstance = this.getProjectManager().getProject(project);
        ISourceMetadataExplorer explr = SourceManager.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer();
        for (Map.Entry entry : db2tables.entries()) {
            Pair pair = explr.loadTableMetadata((String)entry.getKey(), (String)entry.getValue(), project);
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            Preconditions.checkState((boolean)tableDesc.getDatabase().equals(((String)entry.getKey()).toUpperCase(Locale.ROOT)));
            Preconditions.checkState((boolean)tableDesc.getName().equals(((String)entry.getValue()).toUpperCase(Locale.ROOT)));
            Preconditions.checkState((boolean)tableDesc.getIdentity().equals(((String)entry.getKey()).toUpperCase(Locale.ROOT) + "." + ((String)entry.getValue()).toUpperCase(Locale.ROOT)));
            TableExtDesc extDesc = (TableExtDesc)pair.getSecond();
            Preconditions.checkState((boolean)tableDesc.getIdentity().equals(extDesc.getIdentity()));
            allMeta.add(pair);
        }
        return allMeta;
    }

    private void addTableToProject(String[] tables, String project) throws IOException {
        this.getProjectManager().addTableDescToProject(tables, project);
    }

    protected void removeTableFromProject(String tableName, String projectName) throws IOException {
        tableName = this.normalizeHiveTableName(tableName);
        this.getProjectManager().removeTableDescFromProject(tableName, projectName);
    }

    public boolean unloadHiveTable(String tableName, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        Message msg = MsgPicker.getMsg();
        boolean rtn = false;
        boolean tableType = false;
        tableName = this.normalizeHiveTableName(tableName);
        TableDesc desc = this.getTableManager().getTableDesc(tableName, project);
        if (desc == null || desc.getProject() == null) {
            logger.warn("Unload Table {} in Project {} failed, could not find TableDesc or related Project", (Object)tableName, (Object)project);
            return false;
        }
        if (this.modelService.isTableInModel(desc, project)) {
            List<String> models = this.modelService.getModelsUsingTable(desc, project);
            throw new BadRequestException(String.format(Locale.ROOT, msg.getTABLE_IN_USE_BY_MODEL(), models));
        }
        this.removeTableFromProject(tableName, project);
        rtn = true;
        TableMetadataManager metaMgr = this.getTableManager();
        metaMgr.removeTableExt(tableName, project);
        metaMgr.removeSourceTable(tableName, project);
        SourceManager sourceManager = SourceManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ISource source = sourceManager.getCachedSource((ISourceAware)desc);
        source.unloadTable(tableName, project);
        return rtn;
    }

    public List<String> getSourceDbNames(String project) throws Exception {
        ISourceMetadataExplorer explr = SourceManager.getInstance((KylinConfig)this.getConfig()).getProjectSource(project).getSourceMetadataExplorer();
        return explr.listDatabases();
    }

    public List<String> getSourceTableNames(String project, String database) throws Exception {
        ISourceMetadataExplorer explr = SourceManager.getInstance((KylinConfig)this.getConfig()).getProjectSource(project).getSourceMetadataExplorer();
        List hiveTableNames = explr.listTables(database);
        Iterable kylinApplicationTableNames = Iterables.filter((Iterable)hiveTableNames, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input != null && !input.startsWith(TableService.this.getConfig().getHiveIntermediateTablePrefix());
            }
        });
        return Lists.newArrayList((Iterable)kylinApplicationTableNames);
    }

    private TableDescResponse cloneTableDesc(TableDesc table, String prj) {
        TableExtDesc tableExtDesc = this.getTableManager().getTableExt(table.getIdentity(), prj);
        TableDescResponse rtableDesc = new TableDescResponse(table);
        HashMap<String, Long> cardinality = new HashMap<String, Long>();
        HashMap<String, String> dataSourceProp = new HashMap<String, String>();
        String scard = tableExtDesc.getCardinality();
        if (!StringUtils.isEmpty((String)scard)) {
            String[] cards = StringUtils.split((String)scard, (String)",");
            ColumnDesc[] cdescs = rtableDesc.getColumns();
            for (int i = 0; i < cdescs.length; ++i) {
                ColumnDesc columnDesc = cdescs[i];
                if (cards.length <= i) {
                    logger.error("The result cardinality is not identical with hive table metadata, cardinality : " + scard + " column array length: " + cdescs.length);
                    break;
                }
                cardinality.put(columnDesc.getName(), Long.parseLong(cards[i]));
            }
            rtableDesc.setCardinality(cardinality);
        }
        dataSourceProp.putAll(tableExtDesc.getDataSourceProp());
        rtableDesc.setDescExd(dataSourceProp);
        return rtableDesc;
    }

    private List<TableDesc> cloneTableDesc(List<TableDesc> tables, String prj) throws IOException {
        ArrayList<TableDesc> descs = new ArrayList<TableDesc>();
        for (TableDesc table : tables) {
            TableDescResponse rtableDesc = this.cloneTableDesc(table, prj);
            descs.add(rtableDesc);
        }
        return descs;
    }

    public String normalizeHiveTableName(String tableName) {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        return (dbTableName[0] + "." + dbTableName[1]).toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CsvColumnDesc> parseCsvFile(MultipartFile file, boolean withHeader, String separator) throws IOException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        ArrayList<CsvColumnDesc> result = new ArrayList<CsvColumnDesc>();
        try {
            isr = new InputStreamReader(file.getInputStream(), Charset.defaultCharset());
            br = new BufferedReader(isr);
            String headLine = null;
            String[] headers = null;
            String contentLine = null;
            switch (separator) {
                case "space": {
                    separator = " ";
                    break;
                }
                case "tab": {
                    separator = "\t";
                    break;
                }
                default: {
                    separator = ",";
                }
            }
            if (withHeader) {
                headLine = br.readLine();
                headers = headLine.split(separator);
            }
            contentLine = br.readLine();
            String[] firstLine = contentLine.split(separator);
            if (headers != null && headers.length != firstLine.length) {
                throw new IllegalArgumentException("Csv file's header not match with content.");
            }
            int index = 0;
            for (String content : firstLine) {
                CsvColumnDesc desc = new CsvColumnDesc();
                if (withHeader) {
                    desc.setName(headers[index]);
                } else {
                    desc.setName("");
                }
                desc.setSample((Object)content);
                result.add(desc);
                ++index;
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException ex) {
                logger.warn("Failed to close reader");
            }
        }
        return result;
    }

    public TableDesc generateCsvTableDesc(String tableName, List<String> columnDescList) throws IOException {
        String[] strs = tableName.split("\\.");
        if (strs.length != 2) {
            throw new IllegalArgumentException("Invalid table name '" + tableName + "'");
        }
        TableDesc tableDesc = new TableDesc();
        tableDesc.setDatabase(strs[0]);
        tableDesc.setName(strs[1]);
        tableDesc.setUuid(RandomUtil.randomUUID().toString());
        tableDesc.setLastModified(0L);
        tableDesc.setSourceType(9);
        ArrayList<ColumnDesc> columnDescs = new ArrayList<ColumnDesc>();
        int index = 0;
        for (String csvColumnDescStr : columnDescList) {
            ColumnDesc columnDesc = new ColumnDesc();
            CsvColumnDesc csvColumnDesc = (CsvColumnDesc)JsonUtil.readValue((String)csvColumnDescStr, CsvColumnDesc.class);
            columnDesc.setId("" + ++index);
            columnDesc.setName(csvColumnDesc.getName());
            columnDesc.setDatatype(csvColumnDesc.getType());
            columnDescs.add(columnDesc);
        }
        tableDesc.setColumns(columnDescs.toArray(new ColumnDesc[columnDescs.size()]));
        return tableDesc;
    }

    public TableExtDesc generateTableExtDesc(TableDesc tableDesc, boolean withHeader, String separator) {
        TableExtDesc tableExtDesc = new TableExtDesc();
        tableExtDesc.setIdentity(tableDesc.getIdentity());
        tableExtDesc.setUuid(RandomUtil.randomUUID().toString());
        tableExtDesc.setLastModified(0L);
        tableExtDesc.init(tableDesc.getProject());
        tableExtDesc.addDataSourceProp("withHeader", Boolean.toString(withHeader));
        tableExtDesc.addDataSourceProp("separator", separator);
        return tableExtDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCsvFile(MultipartFile file, String tableName, String project) throws IOException {
        String workDir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory(project) + "csv/";
        FileSystem fs = HadoopUtil.getFileSystem((String)workDir);
        FSDataOutputStream out = null;
        try {
            out = fs.create(new Path(workDir + tableName.toUpperCase(Locale.ROOT) + ".csv"), true);
            out.write(file.getBytes());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }
}

