/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security.springacl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.kylin.rest.security.springacl.AclRecord;
import org.apache.kylin.rest.security.springacl.LegacyAceInfo;
import org.apache.kylin.rest.security.springacl.SidInfo;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AceImpl
implements AccessControlEntry {
    public static final Comparator<AceImpl> SID_ORDER = new Comparator<AceImpl>(){

        @Override
        public int compare(AceImpl o1, AceImpl o2) {
            if (o1.sidOfAuthority == null) {
                return o2.sidOfAuthority == null ? o1.sidOfPrincipal.compareTo(o2.sidOfPrincipal) : 1;
            }
            return o2.sidOfAuthority == null ? -1 : o1.sidOfAuthority.compareTo(o2.sidOfAuthority);
        }
    };
    @JsonProperty(value="p")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String sidOfPrincipal;
    @JsonProperty(value="a")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String sidOfAuthority;
    @JsonProperty(value="m")
    private int permissionMask;
    private AclRecord acl;
    private int indexInAcl;
    private Sid sid;
    private Permission perm;

    public AceImpl() {
    }

    public AceImpl(LegacyAceInfo legacy) {
        this(legacy.getSidInfo(), legacy.getPermissionMask());
    }

    public AceImpl(Sid sid, Permission perm) {
        this(new SidInfo(sid), perm == null ? 0 : perm.getMask());
    }

    public AceImpl(SidInfo sidInfo, int permMask) {
        if (sidInfo.isPrincipal()) {
            this.sidOfPrincipal = sidInfo.getSid();
        } else {
            this.sidOfAuthority = sidInfo.getSid();
        }
        this.permissionMask = permMask;
    }

    void init(AclRecord acl, int index) {
        this.acl = acl;
        this.indexInAcl = index;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public Serializable getId() {
        return Integer.valueOf(this.indexInAcl);
    }

    public Permission getPermission() {
        if (this.perm == null) {
            this.perm = this.acl.aclPermissionFactory.buildFromMask(this.permissionMask);
        }
        return this.perm;
    }

    public int getPermissionMask() {
        return this.permissionMask;
    }

    void setPermission(Permission perm) {
        this.permissionMask = perm.getMask();
        this.perm = null;
    }

    public Sid getSid() {
        if (this.sid == null) {
            if (this.sidOfPrincipal != null) {
                this.sid = new PrincipalSid(this.sidOfPrincipal);
            } else if (this.sidOfAuthority != null) {
                this.sid = new GrantedAuthoritySid(this.sidOfAuthority);
            } else {
                throw new IllegalStateException();
            }
        }
        return this.sid;
    }

    public boolean isGranting() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.permissionMask;
        result = 31 * result + (this.sidOfAuthority == null ? 0 : this.sidOfAuthority.hashCode());
        result = 31 * result + (this.sidOfPrincipal == null ? 0 : this.sidOfPrincipal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AceImpl other = (AceImpl)obj;
        if (this.permissionMask != other.permissionMask) {
            return false;
        }
        if (this.sidOfAuthority == null ? other.sidOfAuthority != null : !this.sidOfAuthority.equals(other.sidOfAuthority)) {
            return false;
        }
        return !(this.sidOfPrincipal == null ? other.sidOfPrincipal != null : !this.sidOfPrincipal.equals(other.sidOfPrincipal));
    }
}

