/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.signature;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.signature.ComponentSignature;
import org.apache.kylin.rest.signature.SegmentSignature;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;

public abstract class RealizationSignature
extends ComponentSignature<RealizationSignature> {

    static class HybridSignature
    extends RealizationSignature {
        public final String name;
        public final Set<RealizationSignature> realizationSignatureSet;

        private HybridSignature(String name, Set<RealizationSignature> realizationSignatureSet) {
            this.name = name;
            this.realizationSignatureSet = realizationSignatureSet;
        }

        @Override
        public String getKey() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HybridSignature that = (HybridSignature)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.realizationSignatureSet != null ? this.realizationSignatureSet.equals(that.realizationSignatureSet) : that.realizationSignatureSet == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.realizationSignatureSet != null ? this.realizationSignatureSet.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.name + ":" + (this.realizationSignatureSet != null ? Sets.newTreeSet(this.realizationSignatureSet) : null);
        }

        static HybridSignature getHybridSignature(KylinConfig config, String realizationName) {
            HybridInstance hybridInstance = HybridManager.getInstance((KylinConfig)config).getHybridInstance(realizationName);
            if (hybridInstance == null) {
                return null;
            }
            IRealization[] realizations = hybridInstance.getRealizations();
            HashSet realizationSignatureSet = Sets.newHashSetWithExpectedSize((int)realizations.length);
            for (IRealization realization : realizations) {
                RealizationSignature realizationSignature = null;
                if (realization.getType() == RealizationType.CUBE) {
                    realizationSignature = CubeSignature.getCubeSignature(config, realization.getName());
                } else if (realization.getType() == RealizationType.HYBRID) {
                    realizationSignature = HybridSignature.getHybridSignature(config, realization.getName());
                }
                if (realizationSignature == null) continue;
                realizationSignatureSet.add(realizationSignature);
            }
            return new HybridSignature(realizationName, realizationSignatureSet);
        }
    }

    static class CubeSignature
    extends RealizationSignature {
        public final String name;
        public final RealizationStatusEnum status;
        public final Set<SegmentSignature> segmentSignatureSet;

        private CubeSignature(String name, RealizationStatusEnum status, Set<SegmentSignature> segmentSignatureSet) {
            this.name = name;
            this.status = status;
            this.segmentSignatureSet = segmentSignatureSet;
        }

        @Override
        public String getKey() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CubeSignature that = (CubeSignature)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.status != that.status) {
                return false;
            }
            return this.segmentSignatureSet != null ? this.segmentSignatureSet.equals(that.segmentSignatureSet) : that.segmentSignatureSet == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.segmentSignatureSet != null ? this.segmentSignatureSet.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.name + "-" + this.status + ":" + (this.segmentSignatureSet != null ? Sets.newTreeSet(this.segmentSignatureSet) : null);
        }

        static CubeSignature getCubeSignature(KylinConfig config, String realizationName) {
            CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)config).getCube(realizationName);
            if (cubeInstance == null) {
                return null;
            }
            if (!cubeInstance.isReady()) {
                return new CubeSignature(realizationName, RealizationStatusEnum.DISABLED, null);
            }
            Segments readySegments = cubeInstance.getSegments(SegmentStatusEnum.READY);
            HashSet segmentSignatureSet = Sets.newHashSetWithExpectedSize((int)readySegments.size());
            for (CubeSegment cubeSeg : readySegments) {
                segmentSignatureSet.add(new SegmentSignature(cubeSeg.getName(), cubeSeg.getLastBuildTime()));
            }
            return new CubeSignature(realizationName, RealizationStatusEnum.READY, segmentSignatureSet);
        }
    }
}

