/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.UserGroupService;
import org.apache.kylin.rest.util.PagingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user_group"})
public class KylinUserGroupController
extends BasicController {
    @Autowired
    @Qualifier(value="userGroupService")
    private UserGroupService userGroupService;

    @RequestMapping(value={"/groups"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<String> listUserAuthorities(@RequestParam(value="project", required=false) String project, @RequestParam(value="name", required=false) String name, @RequestParam(value="isFuzzMatch", required=false) boolean isFuzzMatch, @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit) throws IOException {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        Map<String, List<String>> userGroupMap = this.userGroupService.getGroupMembersMap();
        HashMap<String, HashSet> usersWithGroup = new HashMap<String, HashSet>();
        List<String> groupsByFuzzyMatching = this.getManagedGroupsByFuzzyMatching(name, isFuzzMatch, this.getAllGroups(project));
        List<String> subList = PagingUtil.cutPage(groupsByFuzzyMatching, offset, limit);
        Iterator<String> iterator = subList.iterator();
        while (iterator.hasNext()) {
            String g;
            List<String> userNames = userGroupMap.get(g = iterator.next());
            usersWithGroup.put(g, userNames == null ? Sets.newHashSet() : Sets.newHashSet(userNames));
        }
        data.put("groups", usersWithGroup);
        data.put("size", Integer.valueOf(groupsByFuzzyMatching.size()));
        return new EnvelopeResponse("000", data, "");
    }

    @RequestMapping(value={"/{name:.+}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<String> addUserGroup(@PathVariable String name) throws IOException {
        this.userGroupService.addGroup(name);
        return new EnvelopeResponse<Object>("000", null, "");
    }

    @RequestMapping(value={"/{name:.+}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<String> delUserGroup(@PathVariable String name) throws IOException {
        if (StringUtils.equalsIgnoreCase((String)name, (String)"ALL_USERS") || StringUtils.equalsIgnoreCase((String)name, (String)"ROLE_ADMIN")) {
            throw new InternalErrorException("Can not delete group " + name);
        }
        this.userGroupService.deleteGroup(name);
        return new EnvelopeResponse<Object>("000", null, "");
    }

    @RequestMapping(value={"/users/{name:.+}"}, method={RequestMethod.POST, RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<String> addOrDelUsers(@PathVariable String name, @RequestBody List<String> users) throws IOException {
        if (StringUtil.equals((String)name, (String)"ROLE_ADMIN") && users.size() == 0) {
            throw new InternalErrorException("role_admin must have at least one user");
        }
        this.userGroupService.modifyGroupUsers(name, users);
        return new EnvelopeResponse<Object>("000", null, "");
    }

    @RequestMapping(value={"/users/{name:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse<String> getUsersByGroup(@PathVariable String name) throws IOException {
        HashMap<String, List<ManagedUser>> data = new HashMap<String, List<ManagedUser>>();
        List<ManagedUser> users = this.userGroupService.getGroupMembersByName(name);
        data.put("users", users);
        return new EnvelopeResponse("000", data, "");
    }

    private List<String> getAllGroups(String project) throws IOException {
        return this.userGroupService.listAllAuthorities(project);
    }

    private List<String> getManagedGroupsByFuzzyMatching(String nameSeg, boolean isFuzzyMatch, List<String> groups) {
        if (StringUtils.isBlank((String)nameSeg)) {
            return groups;
        }
        ArrayList<String> groupsByFuzzyMatching = new ArrayList<String>();
        for (String u : groups) {
            if (!isFuzzyMatch && StringUtils.equals((String)u, (String)nameSeg)) {
                groupsByFuzzyMatching.add(u);
            }
            if (!isFuzzyMatch || !StringUtils.containsIgnoreCase((String)u, (String)nameSeg)) continue;
            groupsByFuzzyMatching.add(u);
        }
        return groupsByFuzzyMatching;
    }
}

