/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.security.springacl.MutableAclRecord;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Component(value="validateUtil")
public class ValidateUtil {
    private static final Pattern alphaNumUnderscorePattren = Pattern.compile("[a-zA-Z0-9_]+");
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;

    public static boolean isAlphanumericUnderscore(String toCheck) {
        return toCheck == null ? false : alphaNumUnderscorePattren.matcher(toCheck).matches();
    }

    public void checkIdentifiersExists(String name, boolean isPrincipal) throws IOException {
        if (isPrincipal && !this.userService.userExists(name)) {
            throw new RuntimeException("Operation failed, user:" + name + " not exists, please add first.");
        }
        if (!isPrincipal && !this.userGroupService.exists(name)) {
            throw new RuntimeException("Operation failed, group:" + name + " not exists, please add first.");
        }
    }

    public void validateIdentifiers(String prj, String name, String type) throws IOException {
        Set<String> allIdentifiers = this.getAllIdentifiersInPrj(prj, type);
        if (!allIdentifiers.contains(name)) {
            throw new RuntimeException("Operation failed, " + type + ":" + name + " not exists in project.");
        }
    }

    public Set<String> getAllIdentifiersInPrj(String project, String type) throws IOException {
        List<Sid> allSids = this.getAllSids(project);
        if (type.equalsIgnoreCase("user")) {
            return this.getUsersInPrj(allSids);
        }
        return this.getAuthoritiesInPrj(allSids);
    }

    private Set<String> getAuthoritiesInPrj(List<Sid> allSids) {
        TreeSet<String> allAuthorities = new TreeSet<String>();
        for (Sid sid : allSids) {
            if (!(sid instanceof GrantedAuthoritySid)) continue;
            allAuthorities.add(((GrantedAuthoritySid)sid).getGrantedAuthority());
        }
        return allAuthorities;
    }

    private Set<String> getUsersInPrj(List<Sid> allSids) throws IOException {
        TreeSet<String> allUsers = new TreeSet<String>();
        for (Sid sid : allSids) {
            if (!(sid instanceof PrincipalSid)) continue;
            allUsers.add(((PrincipalSid)sid).getPrincipal());
        }
        return allUsers;
    }

    private List<Sid> getAllSids(String project) {
        ArrayList<Sid> allSids = new ArrayList<Sid>();
        ProjectInstance prj = this.projectService.getProjectManager().getProject(project);
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", prj.getUuid());
        MutableAclRecord acl = this.accessService.getAcl((AclEntity)ae);
        if (acl != null && acl.getEntries() != null) {
            for (AccessControlEntry ace : acl.getEntries()) {
                allSids.add(ace.getSid());
            }
        }
        return allSids;
    }

    public void validateTable(String project, String table) throws IOException {
        List<TableDesc> tableDescs = this.tableService.getTableDescByProject(project, false);
        TreeSet<String> tables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (TableDesc tableDesc : tableDescs) {
            tables.add(tableDesc.getDatabase() + "." + tableDesc.getName());
        }
        if (!tables.contains(table)) {
            throw new RuntimeException("Operation failed, table:" + table + " not exists");
        }
    }

    public void validateColumn(String project, String table, Collection<String> columns) throws IOException {
        Preconditions.checkState((columns != null && !columns.isEmpty() ? 1 : 0) != 0);
        Set<String> cols = this.getAllColumns(project, table);
        for (String c : columns) {
            if (cols.contains(c)) continue;
            throw new RuntimeException("Operation failed, column:" + c + " not exists");
        }
    }

    public void validateArgs(String ... args) {
        for (String arg : args) {
            Preconditions.checkState((!StringUtils.isEmpty((String)arg) ? 1 : 0) != 0);
        }
    }

    private Set<String> getAllColumns(String project, String table) throws IOException {
        List<TableDesc> tableDescByProject = this.tableService.getTableDescByProject(project, true);
        TreeSet<String> cols = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (TableDesc tableDesc : tableDescByProject) {
            String tbl = tableDesc.getDatabase() + "." + tableDesc.getName();
            if (!tbl.equalsIgnoreCase(table)) continue;
            for (ColumnDesc column : tableDesc.getColumns()) {
                cols.add(column.getName());
            }
        }
        return cols;
    }
}

