/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OrderedProperties;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.rest.job.StorageCleanupJob;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="adminService")
public class AdminService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(AdminService.class);

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String getEnv() throws ConfigurationException, UnsupportedEncodingException {
        PropertiesConfiguration tempConfig = new PropertiesConfiguration();
        OrderedProperties orderedProperties = new OrderedProperties(new TreeMap());
        String content = "";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            orderedProperties.setProperty(entry.getKey(), entry.getValue());
        }
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            orderedProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : orderedProperties.entrySet()) {
            tempConfig.addProperty((String)entry.getKey(), entry.getValue());
        }
        tempConfig.save((OutputStream)baos);
        content = baos.toString("UTF-8");
        return content;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void updateConfig(String key, String value) {
        logger.debug("Update Kylin Runtime Config, key=" + key + ", value=" + value);
        KylinConfig.getInstanceFromEnv().setProperty(key, value);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void cleanupStorage() {
        StorageCleanupJob job = null;
        try {
            job = new StorageCleanupJob();
        }
        catch (IOException e) {
            throw new RuntimeException("Can not init StorageCleanupJob", e);
        }
        String[] args = new String[]{"-delete", "true"};
        job.execute(args);
    }

    public String getPublicConfig() throws IOException {
        String whiteListProperties = KylinConfig.getInstanceFromEnv().getPropertiesWhiteList();
        ArrayList propertyKeys = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)whiteListProperties)) {
            propertyKeys.addAll(Arrays.asList(StringUtil.splitByComma((String)whiteListProperties)));
        }
        return KylinConfig.getInstanceFromEnv().exportToString((Collection)propertyKeys);
    }
}

