/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.ExecutableState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCleanupJob {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCleanupJob.class);
    private static final long NEW_RESOURCE_THREADSHOLD_MS = 43200000L;
    final KylinConfig config;
    private List<String> garbageResources = Collections.emptyList();

    public MetadataCleanupJob() {
        this(KylinConfig.getInstanceFromEnv());
    }

    public MetadataCleanupJob(KylinConfig config) {
        this.config = config;
    }

    public List<String> getGarbageResources() {
        return this.garbageResources;
    }

    public List<String> cleanup(boolean delete, int jobOutdatedDays) throws Exception {
        int n;
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        ResourceStore store = ResourceStore.getStore((KylinConfig)this.config);
        long newResourceTimeCut = System.currentTimeMillis() - 43200000L;
        FileSystem fs = HadoopUtil.getWorkingFileSystem((Configuration)HadoopUtil.getCurrentConfiguration());
        ArrayList toDeleteCandidates = Lists.newArrayList();
        String[] stringArray = new String[]{"/table_snapshot", "/cube_statistics", "/ext_table_snapshot"};
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String resourceRoot = stringArray[n];
            for (String dir : this.noNull(store.listResources(resourceRoot))) {
                for (String string : this.noNull(store.listResources(dir))) {
                    if (store.getResourceTimestamp(string) >= newResourceTimeCut) continue;
                    toDeleteCandidates.add(string);
                }
            }
        }
        try {
            Object[] fStatus = new FileStatus[]{};
            fStatus = (FileStatus[])ArrayUtils.addAll((Object[])fStatus, (Object[])fs.listStatus(new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/GlobalDict/dict")));
            Object[] objectArray = fStatus = (FileStatus[])ArrayUtils.addAll((Object[])fStatus, (Object[])fs.listStatus(new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/SegmentDict/dict")));
            n = objectArray.length;
            for (int resourceRoot = 0; resourceRoot < n; ++resourceRoot) {
                FileStatus[] globalDicts;
                Object status = objectArray[resourceRoot];
                String path = status.getPath().toString();
                for (FileStatus globalDict : globalDicts = fs.listStatus(new Path(path))) {
                    String globalDictPath = globalDict.getPath().toString();
                    toDeleteCandidates.add(globalDictPath);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.info("Working Directory does not exist on HDFS. ");
        }
        for (String resourceRoot : new String[]{"/dict"}) {
            for (String dir : this.noNull(store.listResources(resourceRoot))) {
                for (String string : this.noNull(store.listResources(dir))) {
                    for (String res : this.noNull(store.listResources(string))) {
                        if (store.getResourceTimestamp(res) >= newResourceTimeCut) continue;
                        toDeleteCandidates.add(res);
                    }
                }
            }
        }
        HashSet activeResources = Sets.newHashSet();
        for (CubeInstance cube : cubeManager.listAllCubes()) {
            activeResources.addAll(cube.getSnapshots().values());
            for (CubeSegment segment : cube.getSegments()) {
                activeResources.addAll(segment.getSnapshotPaths());
                activeResources.addAll(segment.getDictionaryPaths());
                activeResources.add(segment.getStatisticsResourcePath());
                for (String dictPath : segment.getDictionaryPaths()) {
                    DictionaryInfo dictionaryInfo = (DictionaryInfo)store.getResource(dictPath, (Serializer)DictionaryInfoSerializer.FULL_SERIALIZER);
                    if (!"org.apache.kylin.dict.AppendTrieDictionary".equals(dictionaryInfo != null ? dictionaryInfo.getDictionaryClass() : null)) continue;
                    String dictObj = dictionaryInfo.getDictionaryObject().toString();
                    String basedir = dictObj.substring(dictObj.indexOf("(") + 1, dictObj.indexOf(")") - 1);
                    if (basedir.startsWith(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "/resources/GlobalDict")) {
                        activeResources.add(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/GlobalDict" + dictionaryInfo.getResourceDir());
                        continue;
                    }
                    if (!basedir.startsWith(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "/resources/SegmentDict")) continue;
                    activeResources.add(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "resources/SegmentDict" + dictionaryInfo.getResourceDir());
                }
            }
        }
        toDeleteCandidates.removeAll(activeResources);
        long outdatedJobTimeCut = System.currentTimeMillis() - (long)(jobOutdatedDays * 24 * 3600) * 1000L;
        ExecutableDao executableDao = ExecutableDao.getInstance((KylinConfig)this.config);
        List allExecutable = executableDao.getJobs();
        for (ExecutablePO executable : allExecutable) {
            long l = executable.getLastModified();
            String jobStatus = executableDao.getJobOutput(executable.getUuid()).getStatus();
            if (l >= outdatedJobTimeCut || !ExecutableState.SUCCEED.toString().equals(jobStatus) && !ExecutableState.DISCARDED.toString().equals(jobStatus)) continue;
            toDeleteCandidates.add("/execute/" + executable.getUuid());
            toDeleteCandidates.add("/execute_output/" + executable.getUuid());
            for (ExecutablePO task : executable.getTasks()) {
                toDeleteCandidates.add("/execute_output/" + task.getUuid());
            }
        }
        this.garbageResources = this.cleanupConclude(delete, toDeleteCandidates);
        return this.garbageResources;
    }

    private List<String> cleanupConclude(boolean delete, List<String> toDeleteResources) throws IOException {
        if (toDeleteResources.isEmpty()) {
            logger.info("No metadata resource to clean up");
            return toDeleteResources;
        }
        logger.info(toDeleteResources.size() + " metadata resource to clean up");
        if (delete) {
            ResourceStore store = ResourceStore.getStore((KylinConfig)this.config);
            FileSystem fs = HadoopUtil.getWorkingFileSystem((Configuration)HadoopUtil.getCurrentConfiguration());
            for (String res : toDeleteResources) {
                logger.info("Deleting metadata " + res);
                try {
                    if (res.startsWith(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory())) {
                        fs.delete(new Path(res), true);
                        continue;
                    }
                    store.deleteResource(res);
                }
                catch (IOException e) {
                    logger.error("Failed to delete resource " + res, (Throwable)e);
                }
            }
        } else {
            for (String res : toDeleteResources) {
                logger.info("Dry run, pending delete metadata " + res);
            }
        }
        return toDeleteResources;
    }

    private NavigableSet<String> noNull(NavigableSet<String> list) {
        return list == null ? new TreeSet() : list;
    }
}

