/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.ModifiedOrder;
import org.apache.kylin.metadata.draft.Draft;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinsTree;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.ValidateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="modelMgmtService")
public class ModelService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(ModelService.class);
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public boolean isModelNameValidate(String modelName) {
        if (StringUtils.isEmpty((String)modelName) || !ValidateUtil.isAlphanumericUnderscore(modelName)) {
            return false;
        }
        for (DataModelDesc model : this.getDataModelManager().getModels()) {
            if (!modelName.equalsIgnoreCase(model.getName())) continue;
            return false;
        }
        return true;
    }

    public List<DataModelDesc> listAllModels(String modelName, String projectName, boolean exactMatch) throws IOException {
        List models;
        if (null == projectName) {
            this.aclEvaluate.checkIsGlobalAdmin();
            models = this.getDataModelManager().getModels();
        } else {
            this.aclEvaluate.checkProjectReadPermission(projectName);
            models = this.getDataModelManager().getModels(projectName);
        }
        ArrayList<DataModelDesc> filterModels = new ArrayList<DataModelDesc>();
        for (DataModelDesc modelDesc : models) {
            boolean isModelMatch = null == modelName || modelName.length() == 0 || exactMatch && modelDesc.getName().toLowerCase(Locale.ROOT).equals(modelName.toLowerCase(Locale.ROOT)) || !exactMatch && modelDesc.getName().toLowerCase(Locale.ROOT).contains(modelName.toLowerCase(Locale.ROOT));
            if (!isModelMatch) continue;
            filterModels.add(modelDesc);
        }
        Collections.sort(filterModels, new ModifiedOrder());
        return filterModels;
    }

    public List<DataModelDesc> getModels(String modelName, String projectName, Integer limit, Integer offset) throws IOException {
        List<DataModelDesc> modelDescs = this.listAllModels(modelName, projectName, true);
        if (limit == null || offset == null) {
            return modelDescs;
        }
        if (modelDescs.size() - offset < limit) {
            return modelDescs.subList(offset, modelDescs.size());
        }
        return modelDescs.subList(offset, offset + limit);
    }

    public DataModelDesc createModelDesc(String projectName, DataModelDesc desc) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        Message msg = MsgPicker.getMsg();
        if (this.getDataModelManager().getDataModelDesc(desc.getName()) != null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDUPLICATE_MODEL_NAME(), desc.getName()));
        }
        String factTableName = desc.getRootFactTableName();
        TableDesc tableDesc = this.getTableManager().getTableDesc(factTableName, projectName);
        if (tableDesc.getSourceType() == 1 && (desc.getPartitionDesc() == null || desc.getPartitionDesc().getPartitionDateColumn() == null)) {
            throw new IllegalArgumentException("Must define a partition column.");
        }
        DataModelDesc createdDesc = null;
        String owner = SecurityContextHolder.getContext().getAuthentication().getName();
        createdDesc = this.getDataModelManager().createDataModelDesc(desc, projectName, owner);
        return createdDesc;
    }

    public DataModelDesc updateModelAndDesc(String project, DataModelDesc desc) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.getDataModelManager().updateDataModelDesc(desc);
        return desc;
    }

    public void dropModel(DataModelDesc desc) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(desc.getProjectInstance().getName());
        Message msg = MsgPicker.getMsg();
        List cubeDescs = this.getCubeDescManager().listAllDesc();
        for (CubeDesc cubeDesc : cubeDescs) {
            if (!cubeDesc.getModelName().equals(desc.getName())) continue;
            throw new BadRequestException(String.format(Locale.ROOT, msg.getDROP_REFERENCED_MODEL(), cubeDesc.getName()));
        }
        this.getDataModelManager().dropModel(desc);
    }

    public boolean isTableInAnyModel(TableDesc table) {
        return this.getDataModelManager().isTableInAnyModel(table);
    }

    public boolean isTableInModel(TableDesc table, String project) throws IOException {
        return this.getDataModelManager().getModelsUsingTable(table, project).size() > 0;
    }

    public List<String> getModelsUsingTable(TableDesc table, String project) throws IOException {
        return this.getDataModelManager().getModelsUsingTable(table, project);
    }

    public Map<TblColRef, Set<CubeInstance>> getUsedDimCols(String modelName, String project) {
        HashMap ret = Maps.newHashMap();
        List<CubeInstance> cubeInstances = this.cubeService.listAllCubes(null, project, modelName, true);
        for (CubeInstance cubeInstance : cubeInstances) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            for (TblColRef tblColRef : cubeDesc.listDimensionColumnsIncludingDerived()) {
                if (ret.containsKey(tblColRef)) {
                    ((Set)ret.get(tblColRef)).add(cubeInstance);
                    continue;
                }
                HashSet set = Sets.newHashSet((Object[])new CubeInstance[]{cubeInstance});
                ret.put(tblColRef, set);
            }
        }
        return ret;
    }

    public Map<TblColRef, Set<CubeInstance>> getUsedNonDimCols(String modelName, String project) {
        HashMap ret = Maps.newHashMap();
        List<CubeInstance> cubeInstances = this.cubeService.listAllCubes(null, project, modelName, true);
        for (CubeInstance cubeInstance : cubeInstances) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            HashSet tblColRefs = Sets.newHashSet((Iterable)cubeDesc.listAllColumns());
            tblColRefs.removeAll(cubeDesc.listDimensionColumnsIncludingDerived());
            for (TblColRef tblColRef : tblColRefs) {
                if (ret.containsKey(tblColRef)) {
                    ((Set)ret.get(tblColRef)).add(cubeInstance);
                    continue;
                }
                HashSet set = Sets.newHashSet((Object[])new CubeInstance[]{cubeInstance});
                ret.put(tblColRef, set);
            }
        }
        return ret;
    }

    private List<String> getModelCols(DataModelDesc model) {
        ArrayList<String> dimCols = new ArrayList<String>();
        List dimensions = model.getDimensions();
        for (ModelDimensionDesc dim : dimensions) {
            String table = dim.getTable();
            for (String c : dim.getColumns()) {
                dimCols.add(table + "." + c);
            }
        }
        return dimCols;
    }

    private List<String> getModelMeasures(DataModelDesc model) {
        ArrayList<String> measures = new ArrayList<String>();
        for (String s : model.getMetrics()) {
            measures.add(s);
        }
        return measures;
    }

    private Map<String, List<String>> getInfluencedCubesByDims(List<String> dims, List<CubeInstance> cubes) {
        HashMap<String, List<String>> influencedCubes = new HashMap<String, List<String>>();
        for (CubeInstance cubeInstance : cubes) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            for (TblColRef tblColRef : cubeDesc.listDimensionColumnsIncludingDerived()) {
                if (dims.contains(tblColRef.getIdentity())) continue;
                if (influencedCubes.get(tblColRef.getIdentity()) == null) {
                    ArrayList<String> candidates = new ArrayList<String>();
                    candidates.add(cubeInstance.getName());
                    influencedCubes.put(tblColRef.getIdentity(), candidates);
                    continue;
                }
                ((List)influencedCubes.get(tblColRef.getIdentity())).add(cubeInstance.getName());
            }
        }
        return influencedCubes;
    }

    private Map<String, List<String>> getInfluencedCubesByMeasures(List<String> allCols, List<CubeInstance> cubes) {
        HashMap<String, List<String>> influencedCubes = new HashMap<String, List<String>>();
        for (CubeInstance cubeInstance : cubes) {
            CubeDesc cubeDesc = cubeInstance.getDescriptor();
            HashSet tblColRefs = Sets.newHashSet((Iterable)cubeDesc.listAllColumns());
            tblColRefs.removeAll(cubeDesc.listDimensionColumnsIncludingDerived());
            for (TblColRef tblColRef : tblColRefs) {
                if (allCols.contains(tblColRef.getIdentity())) continue;
                if (influencedCubes.get(tblColRef.getIdentity()) == null) {
                    ArrayList<String> candidates = new ArrayList<String>();
                    candidates.add(cubeInstance.getName());
                    influencedCubes.put(tblColRef.getIdentity(), candidates);
                    continue;
                }
                ((List)influencedCubes.get(tblColRef.getIdentity())).add(cubeInstance.getName());
            }
        }
        return influencedCubes;
    }

    private String checkIfBreakExistingCubes(DataModelDesc dataModelDesc, String project) throws IOException {
        String modelName = dataModelDesc.getName();
        List<CubeInstance> cubes = this.cubeService.listAllCubes(null, project, modelName, true);
        List<DataModelDesc> historyModels = this.listAllModels(modelName, project, true);
        StringBuilder checkRet = new StringBuilder();
        if (cubes != null && cubes.size() != 0 && !historyModels.isEmpty()) {
            JoinsTree originJoinsTree;
            JoinsTree joinsTree;
            dataModelDesc.init(this.getConfig(), this.getTableManager().getAllTablesMap(project), this.getDataModelManager().getModels(project), false);
            List<String> curModelDims = this.getModelCols(dataModelDesc);
            List<String> curModelMeasures = this.getModelMeasures(dataModelDesc);
            ArrayList<String> curModelDimsAndMeasures = new ArrayList<String>();
            curModelDimsAndMeasures.addAll(curModelDims);
            curModelDimsAndMeasures.addAll(curModelMeasures);
            Map<String, List<String>> influencedCubesByDims = this.getInfluencedCubesByDims(curModelDims, cubes);
            Map<String, List<String>> influencedCubesByMeasures = this.getInfluencedCubesByMeasures(curModelDimsAndMeasures, cubes);
            for (Map.Entry<String, List<String>> e : influencedCubesByDims.entrySet()) {
                checkRet.append("Dimension: ");
                checkRet.append(e.getKey());
                checkRet.append(" can't be removed, It is referred in Cubes: ");
                checkRet.append(e.getValue().toString());
                checkRet.append("\r\n");
            }
            for (Map.Entry<String, List<String>> e : influencedCubesByMeasures.entrySet()) {
                checkRet.append("Measure: ");
                checkRet.append(e.getKey());
                checkRet.append(" can't be removed, It is referred in Cubes: ");
                checkRet.append(e.getValue().toString());
                checkRet.append("\r\n");
            }
            DataModelDesc originDataModelDesc = historyModels.get(0);
            if (!dataModelDesc.getRootFactTable().equals((Object)originDataModelDesc.getRootFactTable())) {
                checkRet.append("Root fact table can't be modified. \r\n");
            }
            if ((joinsTree = dataModelDesc.getJoinsTree()).matchNum(originJoinsTree = originDataModelDesc.getJoinsTree()) != originDataModelDesc.getJoinTables().length + 1) {
                checkRet.append("The join shouldn't be modified in this model.");
            }
        }
        return checkRet.toString();
    }

    public void primaryCheck(DataModelDesc modelDesc) {
        Message msg = MsgPicker.getMsg();
        if (modelDesc == null) {
            throw new BadRequestException(msg.getINVALID_MODEL_DEFINITION());
        }
        String modelName = modelDesc.getName();
        if (StringUtils.isEmpty((String)modelName)) {
            logger.info("Model name should not be empty.");
            throw new BadRequestException(msg.getEMPTY_MODEL_NAME());
        }
        if (!ValidateUtil.isAlphanumericUnderscore(modelName)) {
            logger.info("Invalid model name {}, only letters, numbers and underscore supported.", (Object)modelDesc.getName());
            throw new BadRequestException(String.format(Locale.ROOT, msg.getINVALID_MODEL_NAME(), modelName));
        }
    }

    public DataModelDesc updateModelToResourceStore(DataModelDesc modelDesc, String projectName) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        Message msg = MsgPicker.getMsg();
        modelDesc.setDraft(false);
        if (modelDesc.getUuid() == null) {
            modelDesc.updateRandomUuid();
        }
        try {
            if (modelDesc.getLastModified() == 0L) {
                modelDesc = this.createModelDesc(projectName, modelDesc);
            } else {
                String error = this.checkIfBreakExistingCubes(modelDesc, projectName);
                if (!error.isEmpty()) {
                    throw new BadRequestException(error);
                }
                modelDesc = this.updateModelAndDesc(projectName, modelDesc);
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            throw new ForbiddenException(msg.getUPDATE_MODEL_NO_RIGHT());
        }
        if (!modelDesc.getError().isEmpty()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getBROKEN_MODEL_DESC(), modelDesc.getName()));
        }
        return modelDesc;
    }

    public DataModelDesc getModel(String modelName, String projectName) throws IOException {
        if (null == projectName) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectReadPermission(projectName);
        }
        return this.getDataModelManager().getDataModelDesc(modelName);
    }

    public Draft getModelDraft(String modelName, String projectName) throws IOException {
        Iterator<Draft> iterator = this.listModelDrafts(modelName, projectName).iterator();
        if (iterator.hasNext()) {
            Draft d = iterator.next();
            return d;
        }
        return null;
    }

    public List<Draft> listModelDrafts(String modelName, String projectName) throws IOException {
        if (null == projectName) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectReadPermission(projectName);
        }
        ArrayList<Draft> result = new ArrayList<Draft>();
        for (Draft d : this.getDraftManager().list(projectName)) {
            RootPersistentEntity e = d.getEntity();
            if (!(e instanceof DataModelDesc)) continue;
            DataModelDesc m = (DataModelDesc)e;
            if (!StringUtils.isEmpty((String)modelName) && !modelName.equals(m.getName())) continue;
            result.add(d);
        }
        return result;
    }
}

