/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class KylinUserService
implements UserService {
    private Logger logger = LoggerFactory.getLogger(KylinUserService.class);
    public static final String DIR_PREFIX = "/user/";
    public static final String SUPER_ADMIN = "ADMIN";
    public static final Serializer<ManagedUser> SERIALIZER = new JsonSerializer(ManagedUser.class);
    protected ResourceStore aclStore;
    private boolean evictCacheFlag = false;

    @Override
    public boolean isEvictCacheFlag() {
        return this.evictCacheFlag;
    }

    @Override
    public void setEvictCacheFlag(boolean evictCacheFlag) {
        this.evictCacheFlag = evictCacheFlag;
    }

    @PostConstruct
    public void init() throws IOException {
        this.aclStore = ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    public void createUser(UserDetails user) {
        this.updateUser(user);
    }

    public void updateUser(UserDetails user) {
        Preconditions.checkState((boolean)(user instanceof ManagedUser), (String)"User {} is not ManagedUser", (Object[])new Object[]{user});
        ManagedUser managedUser = (ManagedUser)user;
        try {
            String id = KylinUserService.getId(user.getUsername());
            this.aclStore.putResourceWithoutCheck(id, (RootPersistentEntity)managedUser, System.currentTimeMillis(), SERIALIZER);
            this.logger.trace("update user : {}", (Object)user.getUsername());
            this.setEvictCacheFlag(true);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public void deleteUser(String userName) {
        if (userName.equals(SUPER_ADMIN)) {
            throw new InternalErrorException("User " + userName + " is not allowed to be deleted.");
        }
        try {
            String id = KylinUserService.getId(userName);
            this.aclStore.deleteResource(id);
            this.logger.trace("delete user : {}", (Object)userName);
            this.setEvictCacheFlag(true);
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public boolean userExists(String userName) {
        try {
            this.logger.trace("judge user exist: {}", (Object)userName);
            return this.aclStore.exists(KylinUserService.getId(userName));
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        Message msg = MsgPicker.getMsg();
        try {
            ManagedUser managedUser = (ManagedUser)this.aclStore.getResource(KylinUserService.getId(userName), ManagedUser.class, SERIALIZER);
            if (managedUser == null) {
                throw new UsernameNotFoundException(String.format(msg.getUSER_NOT_FOUND(), userName));
            }
            this.logger.trace("load user : {}", (Object)userName);
            return managedUser;
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    @Override
    public List<ManagedUser> listUsers() throws IOException {
        return this.aclStore.getAllResources(DIR_PREFIX, ManagedUser.class, SERIALIZER);
    }

    @Override
    public List<String> listAdminUsers() throws IOException {
        ArrayList<String> adminUsers = new ArrayList<String>();
        for (ManagedUser managedUser : this.listUsers()) {
            if (!managedUser.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN"))) continue;
            adminUsers.add(managedUser.getUsername());
        }
        return adminUsers;
    }

    @Override
    public void completeUserInfo(ManagedUser user) {
    }

    public static String getId(String userName) {
        return DIR_PREFIX + userName;
    }
}

