/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.security.AclHBaseStorage;
import org.apache.kylin.rest.util.Serializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Component;

@Component(value="userService")
public class UserService
implements UserDetailsManager {
    private static final String PWD_PREFIX = "PWD:";
    private Serializer<UserGrantedAuthority[]> ugaSerializer = new Serializer<UserGrantedAuthority[]>(UserGrantedAuthority[].class);
    private String userTableName = null;
    @Autowired
    protected AclHBaseStorage aclHBaseStorage;

    @PostConstruct
    public void init() throws IOException {
        this.userTableName = this.aclHBaseStorage.prepareHBaseTable(UserService.class);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user;
        Table htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.userTableName);
            Get get = new Get(Bytes.toBytes((String)username));
            get.addFamily(Bytes.toBytes((String)"a"));
            Result result = htable.get(get);
            User user2 = this.hbaseRowToUser(result);
            if (user2 == null) {
                throw new UsernameNotFoundException("User " + username + " not found.");
            }
            user = user2;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return user;
    }

    private User hbaseRowToUser(Result result) throws JsonParseException, JsonMappingException, IOException {
        if (null == result || result.isEmpty()) {
            return null;
        }
        String username = Bytes.toString((byte[])result.getRow());
        byte[] valueBytes = result.getValue(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c"));
        UserGrantedAuthority[] deserialized = this.ugaSerializer.deserialize(valueBytes);
        String password = "";
        List<Object> authorities = Collections.emptyList();
        if (deserialized != null) {
            if (deserialized.length > 0 && deserialized[0].getAuthority().startsWith(PWD_PREFIX)) {
                password = deserialized[0].getAuthority().substring(PWD_PREFIX.length());
                authorities = Arrays.asList(deserialized).subList(1, deserialized.length);
            } else {
                authorities = Arrays.asList(deserialized);
            }
        }
        return new User(username, password, authorities);
    }

    private Pair<byte[], byte[]> userToHBaseRow(UserDetails user) throws JsonProcessingException {
        byte[] key = Bytes.toBytes((String)user.getUsername());
        List<GrantedAuthority> authorities = user.getAuthorities();
        if (authorities == null) {
            authorities = Collections.emptyList();
        }
        UserGrantedAuthority[] serializing = new UserGrantedAuthority[authorities.size() + 1];
        serializing[0] = new UserGrantedAuthority(PWD_PREFIX + user.getPassword());
        int i = 1;
        for (GrantedAuthority a : authorities) {
            serializing[i++] = new UserGrantedAuthority(a.getAuthority());
        }
        byte[] value = this.ugaSerializer.serialize(serializing);
        return Pair.newPair((Object)key, (Object)value);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void createUser(UserDetails user) {
        this.updateUser(user);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void updateUser(UserDetails user) {
        Table htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.userTableName);
            Pair<byte[], byte[]> pair = this.userToHBaseRow(user);
            Put put = new Put((byte[])pair.getKey());
            put.addColumn(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c"), (byte[])pair.getSecond());
            htable.put(put);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteUser(String username) {
        Table htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.userTableName);
            Delete delete = new Delete(Bytes.toBytes((String)username));
            htable.delete(delete);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public boolean userExists(String username) {
        boolean bl;
        Table htable = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.userTableName);
            Result result = htable.get(new Get(Bytes.toBytes((String)username)));
            bl = null != result && !result.isEmpty();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return bl;
    }

    public List<String> listUserAuthorities() {
        ArrayList<String> all = new ArrayList<String>();
        for (UserDetails user : this.listUsers()) {
            for (GrantedAuthority auth : user.getAuthorities()) {
                if (all.contains(auth.getAuthority())) continue;
                all.add(auth.getAuthority());
            }
        }
        return all;
    }

    public List<UserDetails> listUsers() {
        Scan s = new Scan();
        s.addColumn(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c"));
        ArrayList<UserDetails> all = new ArrayList<UserDetails>();
        Table htable = null;
        ResultScanner scanner = null;
        try {
            htable = this.aclHBaseStorage.getTable(this.userTableName);
            scanner = htable.getScanner(s);
            Result result = scanner.next();
            while (result != null) {
                User user = this.hbaseRowToUser(result);
                all.add((UserDetails)user);
                result = scanner.next();
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to scan users", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(scanner);
                IOUtils.closeQuietly((Closeable)htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)scanner);
        IOUtils.closeQuietly((Closeable)htable);
        return all;
    }

    public static class UserGrantedAuthority
    implements GrantedAuthority {
        private static final long serialVersionUID = -5128905636841891058L;
        private String authority;

        public UserGrantedAuthority() {
        }

        public UserGrantedAuthority(String authority) {
            this.setAuthority(authority);
        }

        public String getAuthority() {
            return this.authority;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.authority == null ? 0 : this.authority.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserGrantedAuthority other = (UserGrantedAuthority)obj;
            return !(this.authority == null ? other.authority != null : !this.authority.equals(other.authority));
        }

        public String toString() {
            return this.authority;
        }
    }
}

