/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.Collection;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.HybridRequest;
import org.apache.kylin.rest.service.HybridService;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hybrids"})
public class HybridController
extends BasicController {
    @Autowired
    private HybridService hybridService;

    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public HybridInstance create(@RequestBody HybridRequest request) {
        this.checkRequiredArg("hybrid", request.getHybrid());
        this.checkRequiredArg("project", request.getProject());
        this.checkRequiredArg("model", request.getModel());
        this.checkRequiredArg("cubes", request.getCubes());
        HybridInstance instance = this.hybridService.createHybridCube(request.getHybrid(), request.getProject(), request.getModel(), request.getCubes());
        return instance;
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT})
    @ResponseBody
    public HybridInstance update(@RequestBody HybridRequest request) {
        this.checkRequiredArg("hybrid", request.getHybrid());
        this.checkRequiredArg("project", request.getProject());
        this.checkRequiredArg("model", request.getModel());
        this.checkRequiredArg("cubes", request.getCubes());
        HybridInstance instance = this.hybridService.updateHybridCube(request.getHybrid(), request.getProject(), request.getModel(), request.getCubes());
        return instance;
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@RequestBody HybridRequest request) {
        this.checkRequiredArg("hybrid", request.getHybrid());
        this.checkRequiredArg("project", request.getProject());
        this.checkRequiredArg("model", request.getModel());
        this.hybridService.deleteHybridCube(request.getHybrid(), request.getProject(), request.getModel());
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public Collection<HybridInstance> list(@RequestParam(required=false) String project, @RequestParam(required=false) String model) {
        return this.hybridService.listHybrids(project, model);
    }

    @RequestMapping(value={"{hybrid}"}, method={RequestMethod.GET})
    @ResponseBody
    public HybridInstance get(@PathVariable String hybrid) {
        return this.hybridService.getHybridInstance(hybrid);
    }
}

