/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.SQLValidateRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.SQLParserResponse;
import org.apache.kylin.rest.response.SQLValidateResponse;
import org.apache.kylin.rest.service.FavoriteRuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/query/favorite_queries"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class FavoriteQueryController
extends NBasicController {
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    @Autowired
    private FavoriteRuleService favoriteRuleService;

    protected Logger getLogger() {
        return logger;
    }

    @ApiOperation(value="importSqls (response)", tags={"AI"}, notes="sql_advices")
    @PostMapping(value={"/sql_files"})
    @ResponseBody
    public EnvelopeResponse<SQLParserResponse> importSqls(@RequestParam(value="project") String project, @RequestParam(value="files") MultipartFile[] files) {
        this.checkProjectName(project);
        this.checkProjectUnmodifiable(project);
        SQLParserResponse data = this.favoriteRuleService.importSqls(files, project);
        return new EnvelopeResponse("000", (Object)data, "");
    }

    @ApiOperation(value="sqlValidate", tags={"AI"}, notes="Update Response: incapable_reason, sql_advices")
    @PutMapping(value={"/sql_validation"})
    @ResponseBody
    public EnvelopeResponse<SQLValidateResponse> sqlValidate(@RequestBody SQLValidateRequest request) {
        this.checkProjectName(request.getProject());
        this.checkProjectUnmodifiable(request.getProject());
        return new EnvelopeResponse("000", (Object)this.favoriteRuleService.sqlValidate(request.getProject(), request.getSql()), "");
    }
}

