/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.NoStreamingRealizationFoundException;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.routing.RealizationChooser;
import org.apache.kylin.query.util.ContextInitialCutStrategy;
import org.apache.kylin.query.util.ContextReCutStrategy;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContextCutter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryContextCutter.class);

    private QueryContextCutter() {
    }

    public static void analyzeOlapContext(RelNode root) {
        QueryContextCutter.cutContext(new ContextInitialCutStrategy(), (OlapRel)root.getInput(0), root);
        QueryContextCutter.fillOlapContextPropertiesWithRelTree(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OlapContext> selectRealization(String project, RelNode root, boolean isReCutBanned) {
        ContextInitialCutStrategy firstRoundStrategy = new ContextInitialCutStrategy();
        ContextReCutStrategy reCutStrategy = new ContextReCutStrategy();
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        boolean printPlan = projectConfig.isPrintQueryPlanEnabled();
        int maxRetryTimesOfContextCut = projectConfig.getMaxRetryTimesOfContextCut();
        if (printPlan) {
            log.info("The relNode before cutting:\n{}\n", (Object)RelOptUtil.toString((RelNode)root));
        }
        QueryContextCutter.cutContext(firstRoundStrategy, (OlapRel)root.getInput(0), root);
        int retryCutTimes = 0;
        while (retryCutTimes++ < maxRetryTimesOfContextCut) {
            if (printPlan) {
                log.info("The {} time{} of cutting OlapContext\n{}\n", new Object[]{retryCutTimes, retryCutTimes > 1 ? "s" : "", RelOptUtil.toString((RelNode)root)});
            }
            try {
                QueryContextCutter.fillOlapContextPropertiesWithRelTree(root);
                List<OlapContext> olapContexts = QueryContextCutter.chooseCandidate(project);
                if (isReCutBanned) {
                    throw new NoRealizationFoundException("There is no need to select realizations for OlapContexts.");
                }
                List<OlapContext> list = olapContexts;
                return list;
            }
            catch (NoRealizationFoundException | NoStreamingRealizationFoundException e) {
                QueryContextCutter.throwIfReCutBanned(isReCutBanned, (RuntimeException)e);
                reCutStrategy.tryCutToSmallerContexts(root, (RuntimeException)e);
            }
            finally {
                if (!isReCutBanned) continue;
                ContextUtil.listContextsHavingScan().forEach(olapContext -> {
                    if (olapContext.getRealization() != null) {
                        olapContext.unfixModel();
                    }
                });
            }
        }
        String errorMsg = "too many unmatched joins in this query, please check it or create corresponding realization.";
        ContextUtil.dumpCalcitePlan((String)("cannot find proper realizations After re-cut " + maxRetryTimesOfContextCut + " times. \nError: " + errorMsg), (RelNode)root, (Logger)log);
        throw new NoRealizationFoundException(errorMsg);
    }

    private static void throwIfReCutBanned(boolean isReCutBanned, RuntimeException e) {
        if (isReCutBanned && e instanceof NoStreamingRealizationFoundException) {
            QueryContextCutter.checkStreamingTableWithAutoModeling();
        } else if (isReCutBanned || e instanceof NoStreamingRealizationFoundException) {
            throw e;
        }
    }

    private static void fillOlapContextPropertiesWithRelTree(RelNode queryRoot) {
        OlapRel.OlapImpl kapImplementor = new OlapRel.OlapImpl();
        kapImplementor.visitChild(queryRoot.getInput(0), queryRoot);
        QueryContext.current().record("collect_olap_context_info");
    }

    private static List<OlapContext> chooseCandidate(String project) {
        List contexts = ContextUtil.listContextsHavingScan();
        contexts.forEach(olapContext -> {
            olapContext.setHasSelected(true);
            log.info("Context to be match {},  {}", (Object)olapContext.getId(), olapContext);
        });
        long selectLayoutStartTime = System.currentTimeMillis();
        RealizationChooser.selectLayoutCandidate((String)project, (List)contexts);
        log.info("select layout candidate for {} olapContext cost {} ms", (Object)contexts.size(), (Object)(System.currentTimeMillis() - selectLayoutStartTime));
        QueryContext.current().record("end_select_realization");
        return contexts;
    }

    static void cutContext(ICutContextStrategy strategy, OlapRel rootOfSubCtxTree, RelNode queryRoot) {
        if (strategy.needCutOff(rootOfSubCtxTree)) {
            strategy.cutOffContext(rootOfSubCtxTree, queryRoot);
        }
        if (strategy instanceof ContextInitialCutStrategy) {
            ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER OLAPCONTEXT IS SET IN FIRST ROUND", (RelNode)queryRoot, (Logger)log);
        } else {
            ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER OLAPCONTEXT IS RE-CUT OFF ", (RelNode)queryRoot, (Logger)log);
        }
    }

    private static void checkStreamingTableWithAutoModeling() {
        for (OlapContext context : ContextUtil.listContextsHavingScan()) {
            for (OlapTableScan tableScan : context.getAllTableScans()) {
                TableDesc tableDesc = tableScan.getTableRef().getTableDesc();
                if (1 != tableDesc.getSourceType() || !tableDesc.getKafkaConfig().hasBatchTable()) continue;
                throw new NoStreamingRealizationFoundException((ErrorCodeSupplier)ServerErrorCode.STREAMING_TABLE_NOT_SUPPORT_AUTO_MODELING, String.format(Locale.ROOT, MsgPicker.getMsg().getStreamingTableNotSupportAutoModeling(), new Object[0]));
            }
        }
        throw new NoRealizationFoundException("No realization found for auto modeling.");
    }
}

