/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.relnode.OlapUnionRel;

public class UnionTypeCastRule
extends RelOptRule {
    public static final UnionTypeCastRule INSTANCE = new UnionTypeCastRule(UnionTypeCastRule.operand(OlapUnionRel.class, (RelOptRuleOperandChildren)UnionTypeCastRule.any()), RelFactories.LOGICAL_BUILDER, "UnionTypeCastRule");

    public UnionTypeCastRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public boolean matches(RelOptRuleCall call) {
        return !((SetOp)call.rel(0)).isHomogeneous(true);
    }

    public void onMatch(RelOptRuleCall call) {
        OlapUnionRel logicalUnion = (OlapUnionRel)call.rel(0);
        RelDataType rowType = logicalUnion.getRowType();
        ArrayList<OlapProjectRel> projects = new ArrayList<OlapProjectRel>();
        for (RelNode relNode : logicalUnion.getInputs()) {
            OlapProjectRel castProject;
            RelNode origin = ((HepRelVertex)relNode).getCurrentRel();
            if (origin instanceof OlapProjectRel) {
                OlapProjectRel project = (OlapProjectRel)origin;
                List<RexNode> castExpressions = RexUtil.generateCastExpressions((RexBuilder)project.getCluster().getRexBuilder(), (RelDataType)rowType, (List)project.getProjects());
                castExpressions = this.checkNullability(project.getCluster().getRexBuilder(), rowType, castExpressions);
                castProject = new OlapProjectRel(project.getCluster(), project.getTraitSet(), project.getInput(), castExpressions, rowType);
            } else {
                List<RexNode> castExpressions = RexUtil.generateCastExpressions((RexBuilder)origin.getCluster().getRexBuilder(), (RelDataType)rowType, (RelDataType)origin.getRowType());
                castExpressions = this.checkNullability(origin.getCluster().getRexBuilder(), rowType, castExpressions);
                castProject = new OlapProjectRel(origin.getCluster(), origin.getTraitSet(), origin, castExpressions, rowType);
            }
            projects.add(castProject);
        }
        call.transformTo((RelNode)new OlapUnionRel(logicalUnion.getCluster(), logicalUnion.getTraitSet(), projects, logicalUnion.all));
    }

    private List<RexNode> checkNullability(RexBuilder rexBuilder, RelDataType rowType, List<RexNode> castExpressions) {
        ArrayList<RexNode> newCastExpressions = new ArrayList<RexNode>();
        for (Pair pair : Pair.zip((List)rowType.getFieldList(), castExpressions, (boolean)true)) {
            if (((RelDataTypeField)pair.left).getType().isNullable() != ((RexNode)pair.right).getType().isNullable()) {
                newCastExpressions.add(rexBuilder.makeAbstractCast(((RelDataTypeField)pair.left).getType(), (RexNode)pair.right));
                continue;
            }
            newCastExpressions.add((RexNode)pair.right);
        }
        return newCastExpressions;
    }
}

