/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.FileSystemUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.query.exception.NAsyncQueryIllegalParamException;
import org.apache.kylin.query.util.AsyncQueryUtil;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.RouteService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="asyncQueryService")
public class AsyncQueryService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    @Autowired
    private RouteService routeService;

    public void saveQueryUsername(String project, String queryId) throws IOException {
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        Path asyncQueryResultDir = this.getAsyncQueryResultDir(project, queryId);
        try (FSDataOutputStream os = fileSystem.create(new Path(asyncQueryResultDir, AsyncQueryUtil.getUserFileName()));
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());){
            osw.write(AsyncQueryService.getUsername());
        }
    }

    public List<List<String>> getMetaData(String project, String queryId) throws IOException {
        this.checkStatus(queryId, QueryStatus.SUCCESS, project, MsgPicker.getMsg().getQueryResultNotFound());
        Path asyncQueryResultDir = this.getAsyncQueryResultDir(project, queryId);
        ArrayList result = Lists.newArrayList();
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        try (FSDataInputStream is = fileSystem.open(new Path(asyncQueryResultDir, AsyncQueryUtil.getMetaDataFileName()));
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)is, Charset.defaultCharset()));){
            result.add(Lists.newArrayList((Object[])bufferedReader.readLine().split(",")));
            result.add(Lists.newArrayList((Object[])bufferedReader.readLine().split(",")));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public FileInfo getFileInfo(String project, String queryId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void retrieveSavedQueryResult(String project, String queryId, HttpServletResponse response, String fileFormat, String encode) throws IOException {
        this.checkStatus(queryId, QueryStatus.SUCCESS, project, MsgPicker.getMsg().getQueryResultNotFound());
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        Path dataPath = this.getAsyncQueryResultDir(project, queryId);
        if (!fileSystem.exists(dataPath)) {
            throw new NotFoundException(MsgPicker.getMsg().getQueryResultFileNotFound());
        }
        try (ServletOutputStream outputStream = response.getOutputStream();){
            switch (fileFormat) {
                case "csv": 
                case "xlsx": 
                case "parquet": {
                    this.processFile((OutputStream)outputStream, dataPath);
                    return;
                }
                case "json": {
                    this.processJSON((OutputStream)outputStream, dataPath, encode);
                    return;
                }
                default: {
                    logger.info("Query:{}, processed", (Object)queryId);
                    return;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public String retrieveSavedQueryException(String project, String queryId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String searchQueryResultProject(String queryId) throws IOException {
        for (ProjectInstance projectInstance : NProjectManager.getInstance((KylinConfig)this.getConfig()).listAllProjects()) {
            FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
            if (!fileSystem.exists(this.getAsyncQueryResultDir(projectInstance.getName(), queryId))) continue;
            return projectInstance.getName();
        }
        return null;
    }

    public QueryStatus queryStatus(String project, String queryId) throws IOException {
        Path asyncQueryResultDir = this.getAsyncQueryResultDir(project, queryId);
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        if (fileSystem.exists(asyncQueryResultDir)) {
            if (fileSystem.exists(new Path(asyncQueryResultDir, AsyncQueryUtil.getFailureFlagFileName()))) {
                return QueryStatus.FAILED;
            }
            if (fileSystem.exists(new Path(asyncQueryResultDir, AsyncQueryUtil.getSuccessFlagFileName())) && fileSystem.exists(new Path(asyncQueryResultDir, AsyncQueryUtil.getFileInfo())) && fileSystem.exists(new Path(asyncQueryResultDir, AsyncQueryUtil.getMetaDataFileName()))) {
                return QueryStatus.SUCCESS;
            }
            return QueryStatus.RUNNING;
        }
        return QueryStatus.MISS;
    }

    /*
     * Exception decompiling
     */
    public String getQueryUsername(String queryId, String project) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasPermission(String queryId, String project) throws IOException {
        if (this.getQueryUsername(queryId, project) != null && SecurityContextHolder.getContext().getAuthentication().getName().equals(this.getQueryUsername(queryId, project))) {
            return true;
        }
        return AclPermissionUtil.isAdmin();
    }

    public long fileStatus(String project, String queryId) throws IOException {
        this.checkStatus(queryId, QueryStatus.SUCCESS, project, MsgPicker.getMsg().getQueryResultNotFound());
        Path asyncQueryResultDir = this.getAsyncQueryResultDir(project, queryId);
        if (AsyncQueryUtil.getFileSystem().exists(asyncQueryResultDir) && AsyncQueryUtil.getFileSystem().isDirectory(asyncQueryResultDir)) {
            FileStatus[] fileStatuses;
            long totalFileSize = 0L;
            for (FileStatus fileStatus : fileStatuses = AsyncQueryUtil.getFileSystem().listStatus(asyncQueryResultDir)) {
                if (fileStatus.getPath().getName().startsWith("_")) continue;
                totalFileSize += fileStatus.getLen();
            }
            return totalFileSize;
        }
        throw new NotFoundException(MsgPicker.getMsg().getQueryResultNotFound());
    }

    public boolean batchDelete(String project, String time, HttpServletRequest request) throws IOException, ParseException {
        if (project == null && time == null) {
            return this.deleteAllFolder(request);
        }
        return this.deleteOldQueryResult(project, time);
    }

    public boolean deleteAllFolder(HttpServletRequest request) throws IOException {
        if (this.routeService.needRoute()) {
            return this.routeService.deleteAllFolderMultiTenantMode(request);
        }
        return this.deleteAllFolder();
    }

    public boolean deleteAllFolder() throws IOException {
        NProjectManager projectManager = (NProjectManager)KylinConfig.getInstanceFromEnv().getManager(NProjectManager.class);
        List projectInstances = projectManager.listAllProjects();
        boolean allSuccess = true;
        HashSet<Path> asyncQueryResultPaths = new HashSet<Path>();
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        for (ProjectInstance projectInstance : projectInstances) {
            Path asyncQueryResultBaseDir = this.getAsyncQueryResultBaseDir(projectInstance.getName());
            if (!fileSystem.exists(asyncQueryResultBaseDir)) continue;
            asyncQueryResultPaths.add(asyncQueryResultBaseDir);
        }
        logger.info("clean all async result dir");
        for (Path path : asyncQueryResultPaths) {
            if (AsyncQueryUtil.getFileSystem().delete(path, true)) continue;
            allSuccess = false;
        }
        return allSuccess;
    }

    public boolean deleteByQueryId(String project, String queryId) throws IOException {
        Path resultDir = this.getAsyncQueryResultDir(project, queryId);
        if (this.queryStatus(project, queryId) == QueryStatus.MISS) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
        logger.info("clean async query result for query id [{}]", (Object)queryId);
        return AsyncQueryUtil.getFileSystem().delete(resultDir, true);
    }

    public boolean deleteOldQueryResult(String project, long time) throws IOException {
        FileStatus[] fileStatuses;
        boolean isAllSucceed = true;
        Path asyncQueryResultBaseDir = this.getAsyncQueryResultBaseDir(project);
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        if (!fileSystem.exists(asyncQueryResultBaseDir)) {
            return true;
        }
        for (FileStatus fileStatus : fileStatuses = FileSystemUtil.listStatus((FileSystem)fileSystem, (Path)asyncQueryResultBaseDir)) {
            if (fileStatus.getModificationTime() >= time) continue;
            try {
                fileSystem.delete(fileStatus.getPath(), true);
            }
            catch (Exception e) {
                logger.error("Fail to delete async query result for [{}]", (Object)fileStatus.getPath(), (Object)e);
                isAllSucceed = false;
            }
        }
        return isAllSucceed;
    }

    public boolean deleteOldQueryResult(String project, String timeString) throws IOException, ParseException {
        if (project == null || timeString == null) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
        long time = format.parse(timeString).getTime();
        return this.deleteOldQueryResult(project, time);
    }

    public boolean cleanOldQueryResult(String project, long days) throws IOException {
        return this.deleteOldQueryResult(project, System.currentTimeMillis() - days * 24L * 60L * 60L * 1000L);
    }

    public String asyncQueryResultPath(String project, String queryId) throws IOException {
        if (this.queryStatus(project, queryId) == QueryStatus.MISS) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
        return this.getAsyncQueryResultDir(project, queryId).toString();
    }

    public void checkStatus(String queryId, QueryStatus queryStatus, String project, String message) throws IOException {
        if (queryStatus == QueryStatus.SUCCESS && this.queryStatus(project, queryId) != QueryStatus.SUCCESS) {
            throw new NAsyncQueryIllegalParamException(message);
        }
    }

    public Path getAsyncQueryResultBaseDir(String project) {
        return new Path(KapConfig.getInstanceFromEnv().getAsyncResultBaseDir(project));
    }

    public Path getAsyncQueryResultDir(String project, String queryId) {
        return new Path(KapConfig.getInstanceFromEnv().getAsyncResultBaseDir(project), queryId);
    }

    private void processJSON(OutputStream outputStream, Path dataPath, String encode) throws IOException {
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        FileStatus[] fileStatuses = fileSystem.listStatus(dataPath);
        ArrayList rowResults = Lists.newArrayList();
        for (FileStatus f : fileStatuses) {
            if (f.getPath().getName().startsWith("_")) continue;
            try (FSDataInputStream inputStream = fileSystem.open(f.getPath());){
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName(encode)));
                rowResults.addAll(Lists.newArrayList((Iterable)bufferedReader.lines().collect(Collectors.toList())));
            }
        }
        String json = new ObjectMapper().writeValueAsString((Object)rowResults);
        IOUtils.copy((InputStream)IOUtils.toInputStream((String)json), (OutputStream)outputStream);
    }

    private void processFile(OutputStream outputStream, Path dataPath) throws IOException {
        FileStatus[] fileStatuses;
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        for (FileStatus f : fileStatuses = fileSystem.listStatus(dataPath)) {
            if (f.getPath().getName().startsWith("_")) continue;
            try (FSDataInputStream inputStream = fileSystem.open(f.getPath());){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
    }

    public static class FileInfo {
        private String format;
        private String encode;
        private String fileName;
        private String separator;

        public FileInfo() {
        }

        public FileInfo(String format, String encode, String fileName, String separator) {
            this.format = format;
            this.encode = encode;
            this.fileName = fileName;
            this.separator = separator;
        }

        public FileInfo(String format, String encode, String fileName) {
            this(format, encode, fileName, ",");
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public String getEncode() {
            return this.encode;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public String getSeparator() {
            return this.separator;
        }

        @Generated
        public void setFormat(String format) {
            this.format = format;
        }

        @Generated
        public void setEncode(String encode) {
            this.encode = encode;
        }

        @Generated
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Generated
        public void setSeparator(String separator) {
            this.separator = separator;
        }
    }

    public static enum QueryStatus {
        RUNNING,
        FAILED,
        SUCCESS,
        MISS;

    }
}

