/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.rest.response.SQLResponseTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResponse
implements Serializable {
    protected static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SQLResponse.class);
    private List<SelectedColumnMeta> columnMetas;
    private Iterable<List<String>> results;
    @JsonProperty(value="query_plan")
    private QueryContext.QueryPlan queryPlan;
    @JsonProperty(value="is_explain")
    private boolean isExplain;
    protected int affectedRowCount;
    @JsonProperty(value="isException")
    protected boolean isException;
    protected String exceptionMessage;
    protected Throwable throwable;
    protected long duration;
    @JsonProperty(value="cpu_time")
    protected long cpuTime;
    protected boolean isPartial = false;
    @JsonProperty(value="vacant")
    private boolean isVacant;
    private List<Long> scanRows;
    private List<Long> scanBytes;
    private String appMasterURL = "";
    protected int failTimes = -1;
    protected long resultRowCount;
    protected int shufflePartitions;
    protected boolean hitExceptionCache = false;
    protected boolean storageCacheUsed = false;
    protected String storageCacheType;
    @JsonProperty(value="dataFetchTime")
    protected long dataFetchTime;
    @JsonProperty(value="pushDown")
    protected boolean queryPushDown = false;
    @JsonProperty(value="is_prepare")
    private boolean isPrepare = false;
    @JsonProperty(value="is_timeout")
    private boolean isTimeout;
    @JsonProperty(value="is_refused")
    private boolean isRefused;
    protected byte[] queryStatistics;
    protected String queryId;
    private String server;
    @JsonProperty(value="is_stop_by_user")
    private boolean isStopByUser;
    private String signature;
    @JsonProperty(value="realizations")
    private List<NativeQueryRealization> nativeRealizations;
    private String engineType;
    private List<SQLResponseTrace> traces;
    @JsonProperty(value="executed_plan")
    private String executedPlan;
    private boolean isBigQuery = false;

    @JsonProperty(value="appMasterURL")
    public String getAppMasterURL() {
        if (this.storageCacheUsed) {
            return "";
        }
        return this.appMasterURL;
    }

    public SQLResponse() {
        this(new LinkedList<SelectedColumnMeta>(), new LinkedList<List<String>>(), 0, false, null);
    }

    public SQLResponse(List<SelectedColumnMeta> columnMetas, List<List<String>> results, int affectedRowCount, boolean isException, String exceptionMessage) {
        this.columnMetas = columnMetas;
        this.results = results;
        this.affectedRowCount = affectedRowCount;
        this.isException = isException;
        this.exceptionMessage = exceptionMessage;
        if (results != null) {
            this.resultRowCount = results.size();
        }
    }

    public SQLResponse(List<SelectedColumnMeta> columnMetas, List<List<String>> results, int affectedRowCount, boolean isException, String exceptionMessage, boolean isPartial, boolean isPushDown) {
        this.columnMetas = columnMetas;
        this.results = results;
        this.affectedRowCount = affectedRowCount;
        this.isException = isException;
        this.exceptionMessage = exceptionMessage;
        this.isPartial = isPartial;
        this.queryPushDown = isPushDown;
        this.isPrepare = BackdoorToggles.getPrepareOnly();
        if (results != null) {
            this.resultRowCount = results.size();
        }
    }

    public SQLResponse(List<SelectedColumnMeta> columnMetas, Iterable<List<String>> results, int resultSize, int affectedRowCount, boolean isException, String exceptionMessage, boolean isPartial, boolean isPushDown) {
        this.columnMetas = columnMetas;
        this.results = results;
        this.affectedRowCount = affectedRowCount;
        this.isException = isException;
        this.exceptionMessage = exceptionMessage;
        this.isPartial = isPartial;
        this.queryPushDown = isPushDown;
        this.isPrepare = BackdoorToggles.getPrepareOnly();
        if (results != null) {
            this.resultRowCount = resultSize;
        }
    }

    @JsonIgnore
    public Throwable getThrowable() {
        return this.throwable;
    }

    public SQLResponse wrapResultOfQueryContext(QueryContext queryContext) {
        Preconditions.checkNotNull((Object)queryContext, (Object)"queryContext is null");
        this.setQueryId(queryContext.getQueryId());
        this.setScanRows(queryContext.getMetrics().getScanRows());
        this.setScanBytes(queryContext.getMetrics().getScanBytes());
        this.setShufflePartitions(queryContext.getShufflePartitions());
        return this;
    }

    public long getTotalScanRows() {
        return QueryContext.calValueWithDefault(this.scanRows);
    }

    public long getTotalScanBytes() {
        return QueryContext.calValueWithDefault(this.scanBytes);
    }

    public void readAllRows() {
        if (!(this.results instanceof Collection)) {
            this.results = ImmutableList.copyOf(this.results);
        }
    }

    public void updateDataFetchTime(QueryContext queryContext) {
        this.dataFetchTime = queryContext.getMetrics().getDataFetchTime();
        if (this.nativeRealizations != null) {
            for (NativeQueryRealization real : this.nativeRealizations) {
                this.dataFetchTime = Math.max(this.dataFetchTime, real.getLastDataRefreshTime());
            }
        }
    }

    public void addNativeRealizationIfNotExist(String modelId) {
        if (this.nativeRealizations == null) {
            this.nativeRealizations = new ArrayList<NativeQueryRealization>();
        }
        if (this.nativeRealizations.stream().anyMatch(real -> real.getModelId().equals(modelId))) {
            return;
        }
        this.nativeRealizations.add(new NativeQueryRealization(modelId, null, null));
    }

    @Generated
    public List<SelectedColumnMeta> getColumnMetas() {
        return this.columnMetas;
    }

    @Generated
    public Iterable<List<String>> getResults() {
        return this.results;
    }

    @Generated
    public QueryContext.QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    @Generated
    public boolean isExplain() {
        return this.isExplain;
    }

    @Generated
    public int getAffectedRowCount() {
        return this.affectedRowCount;
    }

    @Generated
    public boolean isException() {
        return this.isException;
    }

    @Generated
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Generated
    public boolean isPartial() {
        return this.isPartial;
    }

    @Generated
    public boolean isVacant() {
        return this.isVacant;
    }

    @Generated
    public List<Long> getScanRows() {
        return this.scanRows;
    }

    @Generated
    public List<Long> getScanBytes() {
        return this.scanBytes;
    }

    @Generated
    public int getFailTimes() {
        return this.failTimes;
    }

    @Generated
    public long getResultRowCount() {
        return this.resultRowCount;
    }

    @Generated
    public int getShufflePartitions() {
        return this.shufflePartitions;
    }

    @Generated
    public boolean isHitExceptionCache() {
        return this.hitExceptionCache;
    }

    @Generated
    public boolean isStorageCacheUsed() {
        return this.storageCacheUsed;
    }

    @Generated
    public String getStorageCacheType() {
        return this.storageCacheType;
    }

    @Generated
    public long getDataFetchTime() {
        return this.dataFetchTime;
    }

    @Generated
    public boolean isQueryPushDown() {
        return this.queryPushDown;
    }

    @Generated
    public boolean isPrepare() {
        return this.isPrepare;
    }

    @Generated
    public boolean isTimeout() {
        return this.isTimeout;
    }

    @Generated
    public boolean isRefused() {
        return this.isRefused;
    }

    @Generated
    public byte[] getQueryStatistics() {
        return this.queryStatistics;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public boolean isStopByUser() {
        return this.isStopByUser;
    }

    @Generated
    public List<NativeQueryRealization> getNativeRealizations() {
        return this.nativeRealizations;
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }

    @Generated
    public List<SQLResponseTrace> getTraces() {
        return this.traces;
    }

    @Generated
    public String getExecutedPlan() {
        return this.executedPlan;
    }

    @Generated
    public boolean isBigQuery() {
        return this.isBigQuery;
    }

    @Generated
    public void setColumnMetas(List<SelectedColumnMeta> columnMetas) {
        this.columnMetas = columnMetas;
    }

    @Generated
    public void setResults(Iterable<List<String>> results) {
        this.results = results;
    }

    @Generated
    public void setQueryPlan(QueryContext.QueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    @Generated
    public void setExplain(boolean isExplain) {
        this.isExplain = isExplain;
    }

    @Generated
    public void setAffectedRowCount(int affectedRowCount) {
        this.affectedRowCount = affectedRowCount;
    }

    @Generated
    public void setException(boolean isException) {
        this.isException = isException;
    }

    @Generated
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @Generated
    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    @Generated
    public void setPartial(boolean isPartial) {
        this.isPartial = isPartial;
    }

    @Generated
    public void setVacant(boolean isVacant) {
        this.isVacant = isVacant;
    }

    @Generated
    public void setScanRows(List<Long> scanRows) {
        this.scanRows = scanRows;
    }

    @Generated
    public void setScanBytes(List<Long> scanBytes) {
        this.scanBytes = scanBytes;
    }

    @Generated
    public void setAppMasterURL(String appMasterURL) {
        this.appMasterURL = appMasterURL;
    }

    @Generated
    public void setFailTimes(int failTimes) {
        this.failTimes = failTimes;
    }

    @Generated
    public void setResultRowCount(long resultRowCount) {
        this.resultRowCount = resultRowCount;
    }

    @Generated
    public void setShufflePartitions(int shufflePartitions) {
        this.shufflePartitions = shufflePartitions;
    }

    @Generated
    public void setHitExceptionCache(boolean hitExceptionCache) {
        this.hitExceptionCache = hitExceptionCache;
    }

    @Generated
    public void setStorageCacheUsed(boolean storageCacheUsed) {
        this.storageCacheUsed = storageCacheUsed;
    }

    @Generated
    public void setStorageCacheType(String storageCacheType) {
        this.storageCacheType = storageCacheType;
    }

    @Generated
    public void setDataFetchTime(long dataFetchTime) {
        this.dataFetchTime = dataFetchTime;
    }

    @Generated
    public void setQueryPushDown(boolean queryPushDown) {
        this.queryPushDown = queryPushDown;
    }

    @Generated
    public void setPrepare(boolean isPrepare) {
        this.isPrepare = isPrepare;
    }

    @Generated
    public void setTimeout(boolean isTimeout) {
        this.isTimeout = isTimeout;
    }

    @Generated
    public void setRefused(boolean isRefused) {
        this.isRefused = isRefused;
    }

    @Generated
    public void setQueryStatistics(byte[] queryStatistics) {
        this.queryStatistics = queryStatistics;
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setStopByUser(boolean isStopByUser) {
        this.isStopByUser = isStopByUser;
    }

    @Generated
    public void setNativeRealizations(List<NativeQueryRealization> nativeRealizations) {
        this.nativeRealizations = nativeRealizations;
    }

    @Generated
    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    @Generated
    public void setTraces(List<SQLResponseTrace> traces) {
        this.traces = traces;
    }

    @Generated
    public void setExecutedPlan(String executedPlan) {
        this.executedPlan = executedPlan;
    }

    @Generated
    public void setBigQuery(boolean isBigQuery) {
        this.isBigQuery = isBigQuery;
    }

    @Generated
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }
}

