/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.StopQueryBroadcastEventNotifier;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.fileseg.FileSegments;
import org.apache.kylin.fileseg.FileSegmentsDetector;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.query.QueryHistoryRequest;
import org.apache.kylin.metadata.query.util.QueryHisTransformStandardUtil;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.querymeta.TableMetaWithType;
import org.apache.kylin.query.plugin.profiler.AsyncProfiling;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.model.Query;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.QueryDetectRequest;
import org.apache.kylin.rest.request.SQLFormatRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.request.SaveSqlRequest;
import org.apache.kylin.rest.request.SyncFileSegmentsRequest;
import org.apache.kylin.rest.response.BigQueryResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.QueryDetectResponse;
import org.apache.kylin.rest.response.QueryHistoryFiltersResponse;
import org.apache.kylin.rest.response.QueryStatisticsResponse;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.response.ServerExtInfoResponse;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.apache.kylin.rest.response.SyncFileSegmentsResponse;
import org.apache.kylin.rest.response.TableRefresh;
import org.apache.kylin.rest.response.TableRefreshAll;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.QueryCacheManager;
import org.apache.kylin.rest.service.QueryHistoryService;
import org.apache.kylin.rest.service.QueryService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.util.DataRangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;
import redis.clients.jedis.exceptions.JedisException;

@RestController
@RequestMapping(value={"/api/query"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class NQueryController
extends NBasicController {
    public static final String CN = "zh-cn";
    private static final Logger logger = LoggerFactory.getLogger(NQueryController.class);
    private static final Pattern queryNamePattern = Pattern.compile("^[a-zA-Z0-9_]*$");
    @Autowired
    @Qualifier(value="queryService")
    private QueryService queryService;
    @Autowired
    @Qualifier(value="queryHistoryService")
    private QueryHistoryService queryHistoryService;
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private QueryCacheManager queryCacheManager;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    private ModelService modelService;

    protected Logger getLogger() {
        return logger;
    }

    @ApiOperation(value="query", tags={"QE"}, notes="")
    @GetMapping(value={"/profile/start"})
    @ResponseBody
    public EnvelopeResponse<String> profile(@RequestParam(value="params", required=false) String params) {
        this.aclEvaluate.checkIsGlobalAdmin();
        if (!KylinConfig.getInstanceFromEnv().asyncProfilingEnabled()) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.PROFILING_NOT_ENABLED, "async profiling is not enabled");
        }
        AsyncProfiling.start((String)params);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="query", tags={"QE"}, notes="")
    @GetMapping(value={"/profile/dump"})
    @ResponseBody
    public EnvelopeResponse<String> stopProfile(@RequestParam(value="params", required=false) String params, HttpServletResponse response) throws IOException {
        this.aclEvaluate.checkIsGlobalAdmin();
        if (!KylinConfig.getInstanceFromEnv().asyncProfilingEnabled()) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.PROFILING_NOT_ENABLED, "async profiling is not enabled");
        }
        AsyncProfiling.dump((String)params);
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"ke-async-prof-result-" + System.currentTimeMillis() + ".zip\"");
        AsyncProfiling.waitForResult((OutputStream)response.getOutputStream());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="query", tags={"QE"}, notes="Update Param: query_id, accept_partial, backdoor_toggles, cache_key")
    @PostMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<SQLResponse> query(@Valid @RequestBody PrepareSqlRequest sqlRequest, @RequestHeader(value="User-Agent") String userAgent) {
        this.checkForcedToParams(sqlRequest);
        this.checkProjectName(sqlRequest.getProject());
        sqlRequest.setUserAgent(userAgent != null ? userAgent : "");
        QueryContext.current().record("end_http_proc");
        boolean detectFileSegments = sqlRequest.isForcedToPushDown();
        if (detectFileSegments) {
            FileSegmentsDetector.startLocally((String)sqlRequest.getProject());
        }
        try {
            SQLResponse sqlResponse = this.queryService.queryWithCache((SQLRequest)sqlRequest);
            if (detectFileSegments) {
                FileSegmentsDetector.report(finding -> {
                    if (FileSegments.isSyncFileSegSql((String)sqlRequest.getSql())) {
                        sqlResponse.addNativeRealizationIfNotExist(finding.modelId);
                    }
                    this.modelService.forceFileSegments(finding.project, finding.modelId, finding.storageLocation, Optional.of(finding.fileHashs), SegmentStatusEnum.NEW);
                });
            }
            EnvelopeResponse envelopeResponse = new EnvelopeResponse("000", (Object)sqlResponse, "");
            return envelopeResponse;
        }
        finally {
            if (detectFileSegments) {
                FileSegmentsDetector.endLocally();
            }
        }
    }

    @PostMapping(value={"/sync_file_segments"})
    @ResponseBody
    public EnvelopeResponse<SyncFileSegmentsResponse> syncFileSegments(@RequestBody SyncFileSegmentsRequest req) {
        String project = req.getProject();
        this.checkProjectName(project);
        String inputSql = req.getSql();
        List inputModels = FileSegments.findModelsOfFileSeg((String)project, (List)req.getModelAliasOrFactTables());
        StringBuilder probeSql = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)inputSql)) {
            probeSql.append(FileSegments.makeSyncFileSegSql((String)inputSql));
        }
        if (inputModels.size() > 0) {
            if (probeSql.length() > 0) {
                probeSql.append("\n union all \n");
            }
            probeSql.append(FileSegments.makeSyncFileSegSql((List)inputModels));
        }
        if (probeSql.length() == 0) {
            return new EnvelopeResponse("000", null, "");
        }
        PrepareSqlRequest sqlRequest = new PrepareSqlRequest();
        sqlRequest.setProject(project);
        sqlRequest.setForcedToPushDown(Boolean.valueOf(true));
        sqlRequest.setSql(probeSql.toString());
        EnvelopeResponse<SQLResponse> probeResponse = this.query(sqlRequest, "");
        HashSet<String> touchedModelIds = new HashSet<String>();
        for (NDataModel inputModel : inputModels) {
            touchedModelIds.add(inputModel.getId());
        }
        if (probeResponse.getData() != null && ((SQLResponse)probeResponse.getData()).getNativeRealizations() != null) {
            for (NativeQueryRealization real : ((SQLResponse)probeResponse.getData()).getNativeRealizations()) {
                touchedModelIds.add(real.getModelId());
            }
        }
        SyncFileSegmentsResponse resp = new SyncFileSegmentsResponse();
        resp.setProject(project);
        resp.setModels(touchedModelIds.stream().map(modelId -> FileSegments.getModelFileSegments((String)project, (String)modelId)).collect(Collectors.toList()));
        return new EnvelopeResponse("000", (Object)resp, "");
    }

    @ApiOperation(value="cancelQuery", tags={"QE"})
    @DeleteMapping(value={"/{id:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> stopQuery(@PathVariable(value="id") String id) {
        this.queryService.stopQuery(id);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new StopQueryBroadcastEventNotifier(id));
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="clearCache", tags={"QE"})
    @DeleteMapping(value={"/cache"})
    @ResponseBody
    public EnvelopeResponse<String> clearCache(@RequestParam(value="project", required=false) String project) {
        if (!NQueryController.isAdmin()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, "Please make sure you have the admin authority to clear project cache.");
        }
        try {
            this.queryCacheManager.clearProjectCache(project);
        }
        catch (JedisException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.REDIS_CLEAR_ERROR, "Please make sure your redis service is online.");
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="recoverCache", tags={"QE"})
    @PostMapping(value={"/cache/recovery"})
    @ResponseBody
    public EnvelopeResponse<String> recoverCache() {
        if (!NQueryController.isAdmin()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, "Please make sure you have the admin authority to recover cache.");
        }
        this.queryCacheManager.recoverCache();
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="prepareStatement", tags={"QE"})
    @PostMapping(value={"/prestate"})
    @ResponseBody
    public EnvelopeResponse<SQLResponse> prepareQuery(@Valid @RequestBody PrepareSqlRequest sqlRequest) {
        this.checkProjectName(sqlRequest.getProject());
        HashMap newToggles = Maps.newHashMap();
        if (sqlRequest.getBackdoorToggles() != null) {
            newToggles.putAll(sqlRequest.getBackdoorToggles());
        }
        newToggles.put("DEBUG_TOGGLE_PREPARE_ONLY", "true");
        sqlRequest.setBackdoorToggles((Map)newToggles);
        return new EnvelopeResponse("000", (Object)this.queryService.queryWithCache((SQLRequest)sqlRequest), "");
    }

    @ApiOperation(value="savedQueries", tags={"QE"})
    @PostMapping(value={"/saved_queries"})
    public EnvelopeResponse<String> saveQuery(@RequestBody SaveSqlRequest sqlRequest) {
        String queryName = sqlRequest.getName();
        this.checkRequiredArg("name", queryName);
        this.checkQueryName(queryName);
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        Query newQuery = new Query(queryName, sqlRequest.getProject(), sqlRequest.getSql(), sqlRequest.getDescription());
        this.queryService.saveQuery(creator, sqlRequest.getProject(), newQuery);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="removeSavedQueries", tags={"QE"})
    @DeleteMapping(value={"/saved_queries/{id:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> removeSavedQuery(@PathVariable(value="id") String id, @RequestParam(value="project") String project) {
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        this.queryService.removeSavedQuery(creator, project, id);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getSavedQueries", tags={"QE"})
    @GetMapping(value={"/saved_queries"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<Query>>> getSavedQueries(@RequestParam(value="project") String project, @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit) {
        this.checkProjectName(project);
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        List savedQueries = this.queryService.getSavedQueries(creator, project).getQueries();
        return new EnvelopeResponse("000", (Object)DataResult.get((List)savedQueries, (int)offset, (int)limit), "");
    }

    @ApiOperation(value="downloadQueryHistories", tags={"QE"})
    @GetMapping(value={"/download_query_histories"})
    @ResponseBody
    public EnvelopeResponse<String> downloadQueryHistories(@RequestParam(value="project") String project, @RequestParam(value="timezone_offset_hour") Integer timeZoneOffsetHour, @RequestParam(value="language", required=false) String language, @RequestParam(value="start_time_from", required=false) String startTimeFrom, @RequestParam(value="start_time_to", required=false) String startTimeTo, @RequestParam(value="latency_from", required=false) String latencyFrom, @RequestParam(value="latency_to", required=false) String latencyTo, @RequestParam(value="query_status", required=false) List<String> queryStatus, @RequestParam(value="sql", required=false) String sql, @RequestParam(value="realization", required=false) List<String> realizations, @RequestParam(value="exclude_realization", required=false) List<String> excludeRealization, @RequestParam(value="server", required=false) String server, @RequestParam(value="submitter", required=false) List<String> submitter, HttpServletResponse response) {
        ZoneOffset zoneOffset;
        try {
            zoneOffset = ZoneOffset.ofHours(timeZoneOffsetHour);
        }
        catch (Exception e) {
            logger.error("Download file error", (Throwable)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, e.getMessage());
        }
        if (CN.equals(language)) {
            MsgPicker.setMsg((String)"cn");
        }
        this.checkProjectName(project);
        QueryHistoryRequest request = new QueryHistoryRequest(project, startTimeFrom, startTimeTo, latencyFrom, latencyTo, sql, server, submitter, null, null, queryStatus, realizations, excludeRealization, null, false, null, true);
        this.checkGetQueryHistoriesParam(request);
        response.setContentType("text/csv;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        String name = "\"query-history-" + System.currentTimeMillis() + ".csv\"";
        response.setHeader("Content-Disposition", "attachment; filename=" + name);
        try {
            this.queryHistoryService.downloadQueryHistories(request, response, zoneOffset, timeZoneOffsetHour, false);
        }
        catch (TimeoutException e) {
            throw new KylinTimeoutException(MsgPicker.getMsg().getDownloadQueryHistoryTimeout());
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, e.getMessage());
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="downloadQueryHistoriesSql", tags={"QE"})
    @GetMapping(value={"/download_query_histories_sql"})
    @ResponseBody
    public EnvelopeResponse<String> downloadQueryHistoriesSql(@RequestParam(value="project") String project, @RequestParam(value="start_time_from", required=false) String startTimeFrom, @RequestParam(value="start_time_to", required=false) String startTimeTo, @RequestParam(value="latency_from", required=false) String latencyFrom, @RequestParam(value="latency_to", required=false) String latencyTo, @RequestParam(value="query_status", required=false) List<String> queryStatus, @RequestParam(value="sql", required=false) String sql, @RequestParam(value="realization", required=false) List<String> realizations, @RequestParam(value="exclude_realization", required=false) List<String> excludeRealization, @RequestParam(value="server", required=false) String server, @RequestParam(value="submitter", required=false) List<String> submitter, HttpServletResponse response) {
        this.checkProjectName(project);
        QueryHistoryRequest request = new QueryHistoryRequest(project, startTimeFrom, startTimeTo, latencyFrom, latencyTo, sql, server, submitter, null, null, queryStatus, realizations, excludeRealization, null, false, null, true);
        this.checkGetQueryHistoriesParam(request);
        response.setContentType("text/csv;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        String name = "\"sql-" + System.currentTimeMillis() + ".txt\"";
        response.setHeader("Content-Disposition", "attachment; filename=" + name);
        try {
            this.queryHistoryService.downloadQueryHistories(request, response, null, null, true);
        }
        catch (TimeoutException e) {
            throw new KylinTimeoutException(MsgPicker.getMsg().getDownloadQueryHistoryTimeout());
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, e.getMessage());
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getQueryHistories", tags={"QE"})
    @GetMapping(value={"/history_queries"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getQueryHistories(@RequestParam(value="project") String project, @RequestParam(value="start_time_from", required=false) String startTimeFrom, @RequestParam(value="start_time_to", required=false) String startTimeTo, @RequestParam(value="latency_from", required=false) String latencyFrom, @RequestParam(value="latency_to", required=false) String latencyTo, @RequestParam(value="query_status", required=false) List<String> queryStatus, @RequestParam(value="sql", required=false) String sql, @RequestParam(value="realization", required=false) List<String> realizations, @RequestParam(value="exclude_realization", required=false) List<String> excludeRealization, @RequestParam(value="server", required=false) String server, @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit, @RequestParam(value="submitter", required=false) List<String> submitter) {
        this.checkProjectName(project);
        QueryHistoryRequest request = new QueryHistoryRequest(project, startTimeFrom, startTimeTo, latencyFrom, latencyTo, sql, server, submitter, null, null, queryStatus, realizations, excludeRealization, null, false, null, true);
        this.checkGetQueryHistoriesParam(request);
        return new EnvelopeResponse("000", (Object)QueryHisTransformStandardUtil.transformQueryHistorySqlForDisplay((Map)this.queryHistoryService.getQueryHistories(request, limit.intValue(), offset.intValue())), "");
    }

    @ApiOperation(value="getQueryHistories", tags={"QE"}, notes="Update Param: start_time_from, start_time_to")
    @GetMapping(value={"/query_histories"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getQueryHistories(@RequestParam(value="project") String project, @RequestParam(value="start_time_from", required=false) String startTimeFrom, @RequestParam(value="start_time_to", required=false) String startTimeTo, @RequestParam(value="sql", required=false) String sql, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer size) {
        this.checkProjectName(project);
        QueryHistoryRequest request = new QueryHistoryRequest(project, startTimeFrom, startTimeTo);
        Optional.ofNullable(sql).ifPresent(arg_0 -> ((QueryHistoryRequest)request).setSql(arg_0));
        DataRangeUtils.validateDataRange((String)startTimeFrom, (String)startTimeTo, null);
        Map queryHistories = QueryHisTransformStandardUtil.transformQueryHistory((Map)this.queryHistoryService.getQueryHistories(request, size.intValue(), offset.intValue()));
        return new EnvelopeResponse("000", (Object)queryHistories, "");
    }

    @ApiOperation(value="getQueryHistoryUsernames", tags={"QE"}, notes="Update Param: project, user_name")
    @GetMapping(value={"/query_history_submitters"})
    @ResponseBody
    public EnvelopeResponse<List<String>> getQueryHistorySubmitters(@RequestParam(value="project") String project, @RequestParam(value="submitter", required=false) List<String> submitter, @RequestParam(value="page_size", required=false, defaultValue="100") Integer size) {
        this.checkProjectName(project);
        QueryHistoryRequest request = new QueryHistoryRequest();
        request.setProject(project);
        request.setFilterSubmitter(submitter);
        request.setSubmitterExactlyMatch(false);
        this.checkGetQueryHistoriesParam(request);
        return new EnvelopeResponse("000", (Object)this.queryHistoryService.getQueryHistoryUsernames(request, size.intValue()), "");
    }

    @ApiOperation(value="getQueryHistoryModels", tags={"QE"}, notes="Update Param: project, model_name")
    @GetMapping(value={"/query_history_models"})
    @ResponseBody
    public EnvelopeResponse<QueryHistoryFiltersResponse> getQueryHistoryModels(@RequestParam(value="project") String project, @RequestParam(value="model_name", required=false) String modelAlias, @RequestParam(value="page_size", required=false, defaultValue="100") Integer size) {
        this.checkProjectName(project);
        QueryHistoryRequest request = new QueryHistoryRequest();
        request.setProject(project);
        request.setFilterModelName(modelAlias);
        return new EnvelopeResponse("000", (Object)this.queryHistoryService.getQueryHistoryModels(request, size.intValue()), "");
    }

    @ApiOperation(value="queryHistoryTiredStorageMetrics", tags={"QE"}, notes="Update Param: project, query_id")
    @GetMapping(value={"/query_history/tired_storage_metrics"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Long>> queryHistoryTiredStorageMetrics(@RequestParam(value="project") String project, @RequestParam(value="query_id") String queryId) {
        this.checkProjectName(project);
        this.checkRequiredArg("query_id", queryId);
        QueryHistoryRequest request = new QueryHistoryRequest();
        request.setProject(project);
        request.setSql(queryId);
        return new EnvelopeResponse("000", (Object)this.queryHistoryService.queryTiredStorageMetric(request), "");
    }

    @ApiOperation(value="getServers", tags={"QE"})
    @GetMapping(value={"/servers"})
    @ResponseBody
    public EnvelopeResponse<List<?>> getServers(@RequestParam(value="ext", required=false, defaultValue="false") boolean ext) {
        if (ext) {
            List serverInfo = this.clusterManager.getServers().stream().map(server -> new ServerExtInfoResponse().setServer(server).setSecretName(this.encodeHost(server.getHost()))).collect(Collectors.toList());
            return new EnvelopeResponse("000", serverInfo, "");
        }
        return new EnvelopeResponse("000", this.clusterManager.getServers().stream().map(ServerInfoResponse::getHost).collect(Collectors.toList()), "");
    }

    private void checkGetQueryHistoriesParam(QueryHistoryRequest request) {
        Preconditions.checkArgument((boolean)this.allEmptyOrNotAllEmpty(request.getStartTimeFrom(), request.getStartTimeTo()), (Object)"'start time from' and 'start time to' must be used together.");
        Preconditions.checkArgument((boolean)this.allEmptyOrNotAllEmpty(request.getLatencyFrom(), request.getLatencyTo()), (Object)"'latency from ' and 'latency to' must be used together.");
    }

    private boolean allEmptyOrNotAllEmpty(String param1, String param2) {
        if (StringUtils.isEmpty((CharSequence)param1) && StringUtils.isEmpty((CharSequence)param2)) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)param1) && StringUtils.isNotEmpty((CharSequence)param2);
    }

    @PostMapping(value={"/format/{format:.+}"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public void downloadQueryResult(@PathVariable(value="format") String format, SQLRequest sqlRequest, HttpServletResponse response) {
        ArrayList<String> headerList;
        CsvListWriter csvWriter;
        SQLResponse result;
        block8: {
            this.checkProjectName(sqlRequest.getProject());
            KylinConfig config = this.queryService.getConfig();
            Message msg = MsgPicker.getMsg();
            if (NQueryController.isAdmin() && !config.isAdminUserExportAllowed() || !NQueryController.isAdmin() && !config.isNoneAdminUserExportAllowed()) {
                throw new ForbiddenException(msg.getExportResultNotAllowed());
            }
            result = this.queryService.queryWithCache(sqlRequest);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.getDefault(Locale.Category.FORMAT));
            String nowStr = sdf.format(new Date());
            response.setContentType("text/" + format + ";charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + nowStr + ".result." + format + "\"");
            csvWriter = null;
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);
            ((Writer)writer).write(65279);
            csvWriter = new CsvListWriter((Writer)writer, CsvPreference.STANDARD_PREFERENCE);
            headerList = new ArrayList<String>();
            if (!result.isException()) break block8;
            logger.warn("Download query result failed, exception is {}", (Object)result.getExceptionMessage());
            IOUtils.closeQuietly((Closeable)csvWriter, null);
            return;
        }
        try {
            for (SelectedColumnMeta column : result.getColumnMetas()) {
                headerList.add(column.getLabel());
            }
            String[] headers = new String[headerList.size()];
            csvWriter.writeHeader(headerList.toArray(headers));
            for (List strings : result.getResults()) {
                csvWriter.write(strings);
            }
        }
        catch (IOException e) {
            try {
                logger.error("Download query result failed...", (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvWriter, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvWriter, null);
    }

    @ApiOperation(value="getMetadata", notes="Update Param: project")
    @GetMapping(value={"/tables_and_columns"})
    @ResponseBody
    public EnvelopeResponse<List<TableMetaWithType>> getMetadata(@RequestParam(value="project") String project, @RequestParam(value="cube", required=false) String modelAlias) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.queryService.getMetadataV2(project, modelAlias), "");
    }

    @GetMapping(value={"/statistics"})
    public EnvelopeResponse<QueryStatisticsResponse> getQueryStatistics(@RequestParam(value="project") String project, @RequestParam(value="start_time") long startTime, @RequestParam(value="end_time") long endTime) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.queryHistoryService.getQueryStatistics(project, startTime, endTime), "");
    }

    @GetMapping(value={"/statistics/count"})
    public EnvelopeResponse<Map<String, Object>> getQueryCount(@RequestParam(value="project") String project, @RequestParam(value="start_time") long startTime, @RequestParam(value="end_time") long endTime, @RequestParam(value="dimension") String dimension) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.queryHistoryService.getQueryCount(project, startTime, endTime, dimension), "");
    }

    @GetMapping(value={"/statistics/duration"})
    public EnvelopeResponse<Map<String, Object>> getAvgDuration(@RequestParam(value="project") String project, @RequestParam(value="start_time") long startTime, @RequestParam(value="end_time") long endTime, @RequestParam(value="dimension") String dimension) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.queryHistoryService.getAvgDuration(project, startTime, endTime, dimension), "");
    }

    @Deprecated
    @GetMapping(value={"/history_queries/table_names"})
    public EnvelopeResponse<Map<String, String>> getQueryHistoryTableNames(@RequestParam(value="projects", required=false) List<String> projects) {
        return new EnvelopeResponse("000", (Object)this.queryHistoryService.getQueryHistoryTableMap(projects), "");
    }

    @PutMapping(value={"/format"})
    public EnvelopeResponse<List<String>> formatQuery(@RequestBody SQLFormatRequest request) {
        return new EnvelopeResponse("000", (Object)this.queryService.format(request.getSqls()), "");
    }

    @ApiOperation(value="queryDetect", tags={"QE"})
    @PostMapping(value={"/detection"})
    public EnvelopeResponse<QueryDetectResponse> queryDetect(@RequestBody QueryDetectRequest request) {
        this.checkProjectName(request.getProject());
        return new EnvelopeResponse("000", (Object)this.queryService.queryDetect(request), "");
    }

    private void checkQueryName(String queryName) {
        if (!queryNamePattern.matcher(queryName).matches()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_NAME, MsgPicker.getMsg().getInvalidQueryName());
        }
    }

    private void checkForcedToParams(PrepareSqlRequest sqlRequest) {
        if (sqlRequest.isForcedToIndex() && sqlRequest.isForcedToPushDown()) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.INVALID_QUERY_PARAMS, MsgPicker.getMsg().getCannotForceToBothPushdodwnAndIndex());
        }
    }

    @ApiOperation(value="catalogCache", tags={"DW"})
    @PutMapping(value={"single_catalog_cache"}, produces={"application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<TableRefresh> refreshSingleCatalogCache(@RequestBody HashMap refreshRequest) {
        this.checkRefreshParam(refreshRequest);
        TableRefresh response = this.tableService.refreshSingleCatalogCache((Map)refreshRequest);
        return new EnvelopeResponse(response.getCode(), (Object)response, response.getMsg());
    }

    @ApiOperation(value="catalogCache", tags={"DW"})
    @PutMapping(value={"catalog_cache"}, produces={"application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse refreshCatalogCache(HttpServletRequest refreshRequest) {
        TableRefreshAll response = this.tableService.refreshAllCatalogCache(refreshRequest);
        return new EnvelopeResponse(response.getCode(), (Object)response, response.getMsg());
    }

    private void checkRefreshParam(Map refreshRequest) {
        Message message = MsgPicker.getMsg();
        Object tables = refreshRequest.get("tables");
        if (tables == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_REFRESH_PARAMETER, message.getTableRefreshParamInvalid(), false);
        }
        if (refreshRequest.keySet().size() > 1) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_REFRESH_PARAMETER, message.getTableRefreshParamMore(), false);
        }
        if (!(tables instanceof List)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_REFRESH_PARAMETER, message.getTableRefreshParamInvalid(), false);
        }
    }

    @ApiOperation(value="ifBigQuery", tags={"QE"}, notes="Update Param: query_id, accept_partial, backdoor_toggles, cache_key")
    @PostMapping(value={"/if_big_query"})
    @ResponseBody
    public EnvelopeResponse<BigQueryResponse> ifBigQuery(@Valid @RequestBody PrepareSqlRequest sqlRequest, @RequestHeader(value="User-Agent") String userAgent) {
        sqlRequest.setIfBigQuery(true);
        this.checkForcedToParams(sqlRequest);
        this.checkProjectName(sqlRequest.getProject());
        sqlRequest.setUserAgent(userAgent != null ? userAgent : "");
        QueryContext.current().record("end_http_proc");
        BigQueryResponse bigQueryResponse = this.queryService.ifBigQuery((SQLRequest)sqlRequest);
        return new EnvelopeResponse("000", (Object)bigQueryResponse, "");
    }
}

