/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.util.RexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterConditionExpander {
    public static final Logger logger = LoggerFactory.getLogger(FilterConditionExpander.class);
    private final OlapContext context;
    private final OlapRel currentRel;
    private final RexBuilder rexBuilder;
    private final Map<String, RexNode> cachedConvertedRelMap = Maps.newHashMap();

    public FilterConditionExpander(OlapContext context, OlapRel currentRel) {
        this.context = context;
        this.currentRel = currentRel;
        this.rexBuilder = currentRel.getCluster().getRexBuilder();
    }

    public List<RexNode> convert(RexNode node) {
        if (!(node instanceof RexCall)) {
            return new LinkedList<RexNode>();
        }
        try {
            LinkedList<RexNode> results = new LinkedList<RexNode>();
            RexCall call = (RexCall)node;
            for (RexNode conjunction : RelOptUtil.conjunctions((RexNode)RexUtil.toCnf((RexBuilder)this.rexBuilder, (int)100, (RexNode)call))) {
                RexNode converted = this.convertDisjunctionCall(conjunction);
                if (converted == null) continue;
                results.add(converted);
            }
            return results;
        }
        catch (KylinException e) {
            logger.warn("Filter condition is too complex to be converted");
            return new LinkedList<RexNode>();
        }
    }

    public RexNode convertDisjunctionCall(RexNode node) {
        if (!(node instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)node;
        if (call.getOperator() == SqlStdOperatorTable.OR) {
            LinkedList<RexNode> convertedList = new LinkedList<RexNode>();
            for (RexNode operand : call.getOperands()) {
                RexNode converted = this.convertDisjunctionCall(operand);
                if (converted == null) {
                    return null;
                }
                convertedList.add(converted);
            }
            return convertedList.isEmpty() ? null : this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, convertedList);
        }
        if (call.getOperator() == SqlStdOperatorTable.AND) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.UNSUPPORTED_EXPRESSION, "filter expression not in CNF");
        }
        if (call.getOperator() == SqlStdOperatorTable.NOT) {
            RexNode converted = this.convertDisjunctionCall((RexNode)call.getOperands().get(0));
            return converted == null ? null : this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{converted});
        }
        return this.convertSimpleCall(call);
    }

    public RexNode convertSimpleCall(RexCall call) {
        RexInputRef lInputRef = this.convertInputRef(call);
        if (lInputRef == null) {
            return null;
        }
        if (call.getOperands().size() == 1) {
            return call.isA(SqlKind.CAST) ? lInputRef : this.rexBuilder.makeCall(call.getOperator(), new RexNode[]{lInputRef});
        }
        if (call.getOperands().size() > 1) {
            SqlOperator operator;
            if (call.getOperands().get(0) instanceof RexInputRef && ((operator = call.getOperator()).equals((Object)SqlStdOperatorTable.IN) || operator.equals((Object)SqlStdOperatorTable.NOT_IN))) {
                return this.convertLiterals(lInputRef, call.getOperands().subList(1, call.getOperands().size()), operator);
            }
            if (this.cachedConvertedRelMap.containsKey(call.toString())) {
                return this.cachedConvertedRelMap.get(call.toString());
            }
            RexNode simplified = this.simplify(call, lInputRef);
            this.cachedConvertedRelMap.put(call.toString(), simplified);
            return simplified;
        }
        return null;
    }

    private RexNode simplify(RexCall call, RexInputRef lInputRef) {
        RexNode op1 = (RexNode)call.getOperands().get(1);
        if (call.getOperands().size() == 2) {
            RexCall c;
            RexNode rexNode;
            if (op1 instanceof RexLiteral) {
                RexLiteral rLit = (RexLiteral)op1;
                rLit = this.transformRexLiteral(lInputRef, rLit);
                return this.rexBuilder.makeCall(call.getOperator(), new RexNode[]{lInputRef, rLit});
            }
            if (op1.isA(SqlKind.CAST) && (rexNode = (RexNode)(c = (RexCall)op1).getOperands().get(0)) instanceof RexLiteral) {
                RexLiteral rLit = this.transformRexLiteral(lInputRef, (RexLiteral)rexNode);
                return this.rexBuilder.makeCall(call.getOperator(), new RexNode[]{lInputRef, rLit});
            }
        }
        return null;
    }

    private RexNode convertLiterals(RexInputRef rexInputRef, List<RexNode> rexLiterals, SqlOperator operator) {
        ArrayList transformedOperands = Lists.newArrayList();
        transformedOperands.add(rexInputRef);
        for (RexNode operand : rexLiterals) {
            if (!(operand instanceof RexLiteral)) {
                return null;
            }
            transformedOperands.add(operand);
        }
        return this.rexBuilder.makeCall(operator, (List)transformedOperands);
    }

    private RexLiteral transformRexLiteral(RexInputRef inputRef, RexLiteral operand2) {
        Comparable c;
        DataType dataType = DataType.getType((String)inputRef.getType().getSqlTypeName().getName());
        String value = operand2.getValue() instanceof NlsString ? RexLiteral.stringValue((RexNode)operand2) : ((c = RexLiteral.value((RexNode)operand2)) == null ? null : c.toString());
        try {
            return (RexLiteral)RexUtils.transformValue2RexLiteral(this.rexBuilder, value, dataType);
        }
        catch (Exception ex) {
            logger.warn("transform rexLiteral({}) failed: {}", (Object)RexLiteral.value((RexNode)operand2), (Object)ex.getMessage());
            return operand2;
        }
    }

    private RexInputRef convertInputRef(RexCall call) {
        RexInputRef rexInputRef;
        RexInputRef resultInputRef = null;
        RexInputRef originInputRef = this.extractInputRef((RexNode)call.getOperands().get(0));
        if (originInputRef != null && (rexInputRef = this.extractTableScanInputRef(originInputRef, this.currentRel)) != null) {
            String tableAliasColName = this.currentRel.getColumnRowType().getColumnByIndex(originInputRef.getIndex()).getTableAliasColName();
            RelDataType targetType = call.isA(SqlKind.CAST) ? call.getType() : rexInputRef.getType();
            resultInputRef = tableAliasColName == null ? new RexInputRef(rexInputRef.getName(), rexInputRef.getIndex(), targetType) : new RexInputRef(tableAliasColName, rexInputRef.getIndex(), targetType);
        }
        return resultInputRef;
    }

    private RexInputRef extractInputRef(RexNode node) {
        RexNode operand;
        if (node instanceof RexInputRef) {
            return (RexInputRef)node;
        }
        if (node instanceof RexCall && ((RexCall)node).getOperator() == SqlStdOperatorTable.CAST && (operand = (RexNode)((RexCall)node).getOperands().get(0)) instanceof RexInputRef) {
            return (RexInputRef)operand;
        }
        return null;
    }

    private RexInputRef extractTableScanInputRef(RexInputRef rexInputRef, RelNode relNode) {
        if (relNode instanceof TableScan) {
            return ContextUtil.createUniqueInputRefAmongTables((OlapTableScan)relNode, rexInputRef.getIndex(), this.context.getAllTableScans());
        }
        if (relNode instanceof Project) {
            return this.extractProjectInputRef((Project)relNode, rexInputRef);
        }
        int index = rexInputRef.getIndex();
        int currentSize = 0;
        for (int i = 0; i < relNode.getInputs().size(); ++i) {
            Join join;
            if (relNode instanceof Join && ((join = (Join)relNode).getJoinType() == JoinRelType.LEFT && i == 1 || join.getJoinType() == JoinRelType.RIGHT && i == 0 || join.getJoinType() == JoinRelType.FULL)) continue;
            OlapRel child = (OlapRel)relNode.getInput(i);
            int childRowTypeSize = child.getColumnRowType().size();
            if (index < currentSize + childRowTypeSize) {
                return this.extractTableScanInputRef(RexInputRef.of((int)(index - currentSize), (RelDataType)child.getRowType()), child);
            }
            currentSize += childRowTypeSize;
        }
        return null;
    }

    private RexInputRef extractProjectInputRef(Project projectRel, RexInputRef rexInputRef) {
        RexNode expression = (RexNode)projectRel.getProjects().get(rexInputRef.getIndex());
        return expression instanceof RexInputRef ? this.extractTableScanInputRef((RexInputRef)expression, projectRel.getInput(0)) : null;
    }
}

