/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.alibaba.ttl.TtlRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.cuboid.NLookupCandidate;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.HybridRealization;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.NoStreamingRealizationFoundException;
import org.apache.kylin.metadata.realization.RealizationRuntimeException;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapContextProp;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.QueryRouter;
import org.apache.kylin.query.util.RelAggPushDownUtil;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.util.FilterConditionExpander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationChooser {
    private static final Logger logger = LoggerFactory.getLogger(RealizationChooser.class);
    private static final ExecutorService selectCandidateService = new ThreadPoolExecutor(KylinConfig.getInstanceFromEnv().getQueryRealizationChooserThreadCoreNum(), KylinConfig.getInstanceFromEnv().getQueryRealizationChooserThreadMaxNum(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("RealChooser"), new ThreadPoolExecutor.CallerRunsPolicy());

    private RealizationChooser() {
    }

    public static void selectLayoutCandidate(String project, List<OlapContext> contexts) {
        if (!NProjectManager.getProjectConfig((String)project).isRealizationChooserUsingMultiThread()) {
            contexts.forEach(RealizationChooser::attemptSelectCandidate);
            return;
        }
        ArrayList futureList = Lists.newArrayList();
        try {
            CountDownLatch latch = new CountDownLatch(contexts.size());
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            for (OlapContext ctx : contexts) {
                TtlRunnable r = Objects.requireNonNull(TtlRunnable.get(() -> RealizationChooser.selectCandidate0(project, latch, ctx, config)));
                Future<?> future = selectCandidateService.submit((Runnable)r);
                futureList.add(future);
            }
            latch.await();
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoRealizationFoundException) {
                throw (NoRealizationFoundException)e.getCause();
            }
            if (e.getCause() instanceof NoStreamingRealizationFoundException) {
                throw (NoStreamingRealizationFoundException)e.getCause();
            }
            throw new RealizationRuntimeException("unexpected error when choose layout", (Throwable)e);
        }
        catch (InterruptedException e) {
            for (Future future : futureList) {
                future.cancel(true);
            }
            QueryContext.current().getQueryTagInfo().setTimeout(true);
            Thread.currentThread().interrupt();
            throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. Current step: Realization chooser. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void selectCandidate0(String project, CountDownLatch latch, OlapContext ctx, KylinConfig kylinConfig) {
        String queryId = QueryContext.current().getQueryId();
        try (KylinConfig.SetAndUnsetThreadLocalConfig ignored0 = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)kylinConfig);
             SetThreadName ignored1 = new SetThreadName(Thread.currentThread().getName() + " QueryId %s", new Object[]{queryId});
             SetLogCategory ignored2 = new SetLogCategory("query");){
            NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)project);
            NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
            NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
            NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
            RealizationChooser.attemptSelectCandidate(ctx);
        }
        catch (KylinTimeoutException e) {
            logger.error("realization chooser thread task interrupted due to query [{}] timeout", (Object)queryId);
        }
        finally {
            latch.countDown();
        }
    }

    @VisibleForTesting
    public static void attemptSelectCandidate(OlapContext context) {
        if (context.isInvalidContext()) {
            context.markInvalid();
            return;
        }
        if (context.getAllTableScans().isEmpty() || context.isConstantQueryWithAggregations()) {
            return;
        }
        NLookupCandidate.Policy policy = context.deduceLookupTableType();
        if (policy != NLookupCandidate.Policy.NONE && policy != NLookupCandidate.Policy.AGG_THEN_INTERNAL_TABLE && policy != NLookupCandidate.Policy.AGG_THEN_SNAPSHOT) {
            RealizationChooser.matchLookupCandidate(context, policy);
            return;
        }
        String project = context.getOlapSchema().getProject();
        KylinConfig olapConfig = context.getOlapSchema().getConfig();
        Multimap<NDataModel, IRealization> modelMap = RealizationChooser.filterQualifiedModelMap(context);
        RealizationChooser.checkNoRealizationFound(context, modelMap, policy);
        List<Candidate> candidates = RealizationChooser.trySelectCandidates(context, modelMap, false, false);
        if (CollectionUtils.isEmpty(candidates)) {
            boolean partialMatch = olapConfig.isQueryMatchPartialInnerJoinModel();
            boolean nonEquiPartialMatch = olapConfig.partialMatchNonEquiJoins();
            if (partialMatch || nonEquiPartialMatch) {
                candidates = RealizationChooser.trySelectCandidates(context, modelMap, partialMatch, nonEquiPartialMatch);
                context.getStorageContext().setPartialMatch(CollectionUtils.isNotEmpty(candidates));
            }
        }
        if (candidates.isEmpty()) {
            if (RealizationChooser.isLookupCandidateMatched(context, policy)) {
                return;
            }
            RealizationChooser.checkNoRealizationWithStreaming(context);
            RelAggPushDownUtil.registerUnmatchedJoinDigest(context.getTopNode());
            throw new NoRealizationFoundException("No realization found for " + context.incapableMsg());
        }
        QueryRouter.sortCandidates(project, candidates);
        logger.trace("Cost Sorted Realizations {}", candidates);
        Candidate candidate = candidates.get(0);
        RealizationChooser.restoreOlapContextProps(context, candidate.getRewrittenCtx());
        context.fixModel(candidate.getRealization().getModel(), candidate.getMatchedJoinsGraphAliasMap());
        RealizationChooser.adjustForCapabilityInfluence(candidate, context);
        context.setRealization(candidate.getRealization());
        if (candidate.getCapability().isVacant()) {
            QueryContext.current().getQueryTagInfo().setVacant(true);
            NLayoutCandidate layoutCandidate = (NLayoutCandidate)candidate.capability.getSelectedCandidate();
            context.getStorageContext().setBatchCandidate(layoutCandidate);
            context.getStorageContext().setDataSkipped(true);
            return;
        }
        HashSet dimensions = Sets.newHashSet();
        HashSet metrics = Sets.newHashSet();
        RealizationChooser.buildDimensionsAndMetrics(context, dimensions, metrics);
        RealizationChooser.buildStorageContext(context, dimensions, metrics, candidate);
        if (!QueryContext.current().isForModeling()) {
            RealizationChooser.fixContextForTableIndexAnswerNonRawQuery(context);
        }
    }

    public static boolean isLookupCandidateMatched(OlapContext context, NLookupCandidate.Policy policy) {
        if (policy == NLookupCandidate.Policy.AGG_THEN_INTERNAL_TABLE) {
            RealizationChooser.matchLookupCandidate(context, NLookupCandidate.Policy.INTERNAL_TABLE);
            return true;
        }
        if (policy == NLookupCandidate.Policy.AGG_THEN_SNAPSHOT) {
            RealizationChooser.matchLookupCandidate(context, NLookupCandidate.Policy.SNAPSHOT);
            return true;
        }
        return false;
    }

    private static void matchLookupCandidate(OlapContext context, NLookupCandidate.Policy policy) {
        NLookupCandidate lookupCandidate = new NLookupCandidate(context.getSQLDigest().getFactTable(), policy);
        CapabilityResult result = new CapabilityResult();
        result.setCapable(true);
        result.setCandidate(false, (IRealizationCandidate)lookupCandidate);
        result.setCost(lookupCandidate.getCost());
        lookupCandidate.setCapabilityResult(result);
        context.getStorageContext().setLookupCandidate(lookupCandidate);
    }

    private static void checkNoRealizationFound(OlapContext context, Multimap<NDataModel, IRealization> modelMap, NLookupCandidate.Policy policy) {
        if (!modelMap.isEmpty() || RealizationChooser.isLookupCandidateMatched(context, policy)) {
            return;
        }
        RealizationChooser.checkNoRealizationWithStreaming(context);
        RelAggPushDownUtil.registerUnmatchedJoinDigest(context.getTopNode());
        throw new NoRealizationFoundException("No model found for " + context.incapableMsg());
    }

    private static List<Candidate> trySelectCandidates(OlapContext context, Multimap<NDataModel, IRealization> modelMap, boolean partialMatch, boolean nonEquiPartialMatch) {
        ArrayList candidates = Lists.newArrayList();
        for (NDataModel model : modelMap.keySet()) {
            Map<String, String> matchedAliasMap = context.matchJoins(model, partialMatch, nonEquiPartialMatch);
            if (MapUtils.isEmpty(matchedAliasMap)) continue;
            OlapContextProp preservedOlapProps = RealizationChooser.preservePropsBeforeRewrite(context);
            List<Candidate> list = RealizationChooser.selectRealizations(model, context, matchedAliasMap, modelMap.get((Object)model));
            RealizationChooser.restoreOlapContextProps(context, preservedOlapProps);
            if (!CollectionUtils.isNotEmpty(list)) continue;
            candidates.addAll(list);
            logger.info("context & model({}/{}/{}) match info: {}", new Object[]{context.getOlapSchema().getProject(), model.getUuid(), model.getAlias(), true});
        }
        return candidates;
    }

    private static void checkNoRealizationWithStreaming(OlapContext context) {
        String projectName = context.getOlapSchema().getProject();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)projectName);
        for (OlapTableScan tableScan : context.getAllTableScans()) {
            TableDesc tableDesc = tableManager.getTableDesc(tableScan.getTableName());
            if (tableDesc.getSourceType() != 1) continue;
            throw new NoStreamingRealizationFoundException((ErrorCodeSupplier)ServerErrorCode.STREAMING_MODEL_NOT_FOUND, MsgPicker.getMsg().getNoStreamingModelFound());
        }
    }

    private static List<Candidate> selectRealizations(NDataModel model, OlapContext context, Map<String, String> matchedGraphAliasMap, Collection<IRealization> realizations) {
        context.fixModel(model, matchedGraphAliasMap);
        RealizationChooser.preprocessSpecialAggregations(context);
        ArrayList candidates = Lists.newArrayListWithCapacity((int)realizations.size());
        for (IRealization real : realizations) {
            Candidate candidate = RealizationChooser.selectRealization(context, real, matchedGraphAliasMap);
            if (candidate != null) {
                candidates.add(candidate);
                logger.trace("Model {} QueryRouter matched", (Object)model);
                continue;
            }
            logger.trace("Model {} failed in QueryRouter matching", (Object)model);
        }
        context.setNeedToManyDerived(RealizationChooser.needToManyDerived(model));
        context.unfixModel();
        return candidates;
    }

    public static Candidate selectRealization(OlapContext olapContext, IRealization realization, Map<String, String> matchedJoinGraphAliasMap) {
        if (!realization.isOnline()) {
            logger.warn("Realization {} is not ready", (Object)realization);
            return null;
        }
        Candidate candidate = new Candidate(realization, olapContext, matchedJoinGraphAliasMap);
        logger.info("Find candidates by table {} and project={} : {}", new Object[]{olapContext.getFirstTableScan().getTableName(), olapContext.getOlapSchema().getProject(), candidate});
        for (OlapFilterRel filterRel : olapContext.getAllFilterRels()) {
            List<RexNode> filterConditions = new FilterConditionExpander(olapContext, filterRel).convert(filterRel.getCondition());
            olapContext.getExpandedFilterConditions().addAll(filterConditions);
        }
        QueryRouter.applyRules(candidate);
        if (!candidate.getCapability().isCapable()) {
            return null;
        }
        logger.info("The realizations remaining: {}, and the final chosen one for current olap context {} is {}", new Object[]{candidate.getRealization().getCanonicalName(), olapContext.getId(), candidate.getRealization().getCanonicalName()});
        return candidate;
    }

    static OlapContextProp preservePropsBeforeRewrite(OlapContext oriOlapContext) {
        OlapContextProp preserved = new OlapContextProp(-1);
        preserved.setAllColumns(Sets.newHashSet(oriOlapContext.getAllColumns()));
        preserved.setSortColumns(Lists.newArrayList(oriOlapContext.getSortColumns()));
        preserved.setInnerGroupByColumns(Sets.newHashSet(oriOlapContext.getInnerGroupByColumns()));
        preserved.setGroupByColumns(Sets.newLinkedHashSet(oriOlapContext.getGroupByColumns()));
        preserved.setInnerFilterColumns(Sets.newHashSet(oriOlapContext.getInnerFilterColumns()));
        for (FunctionDesc agg : oriOlapContext.getAggregations()) {
            preserved.getReservedMap().put(agg, FunctionDesc.newInstance((String)agg.getExpression(), (List)agg.getParameters(), (String)agg.getReturnType()));
        }
        return preserved;
    }

    static void restoreOlapContextProps(OlapContext oriOlapContext, OlapContextProp preservedOlapContext) {
        oriOlapContext.setAllColumns(preservedOlapContext.getAllColumns());
        oriOlapContext.setSortColumns(preservedOlapContext.getSortColumns());
        HashMap map = Maps.newHashMap(preservedOlapContext.getReservedMap());
        oriOlapContext.getAggregations().forEach(agg -> {
            if (map.containsKey(agg)) {
                FunctionDesc functionDesc = (FunctionDesc)map.get(agg);
                agg.setExpression(functionDesc.getExpression());
                agg.setParameters(functionDesc.getParameters());
                agg.setReturnType(functionDesc.getReturnType());
            }
        });
        oriOlapContext.setGroupByColumns(preservedOlapContext.getGroupByColumns());
        oriOlapContext.setInnerGroupByColumns(preservedOlapContext.getInnerGroupByColumns());
        oriOlapContext.setInnerFilterColumns(preservedOlapContext.getInnerFilterColumns());
        oriOlapContext.resetSQLDigest();
    }

    private static boolean needToManyDerived(NDataModel model) {
        return model.getJoinTables().stream().anyMatch(JoinTableDesc::isDerivedToManyJoinRelation);
    }

    private static boolean hasReadySegments(NDataModel model) {
        if (QueryContext.current().isDryRun()) {
            return true;
        }
        KylinConfig kylinConfig = model.getConfig();
        String project = model.getProject();
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).getDataflow(model.getUuid());
        if (model.isFusionModel()) {
            FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
            String batchId = fusionModelManager.getFusionModel(model.getFusionId()).getBatchModel().getUuid();
            NDataflow batchDataflow = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).getDataflow(batchId);
            return dataflow.hasReadySegments() || batchDataflow.hasReadySegments();
        }
        return dataflow.hasReadySegments();
    }

    public static void fixContextForTableIndexAnswerNonRawQuery(OlapContext context) {
        if (context.getRealization().getConfig().isUseTableIndexAnswerNonRawQuery() && !context.getStorageContext().isDataSkipped() && context.isAnsweredByTableIndex()) {
            if (!context.getAggregations().isEmpty()) {
                List<FunctionDesc> aggregations = context.getAggregations();
                HashSet needDimensions = Sets.newHashSet();
                for (FunctionDesc aggregation : aggregations) {
                    List parameters = aggregation.getParameters();
                    for (ParameterDesc aggParameter : parameters) {
                        needDimensions.addAll(aggParameter.getColRef().getSourceColumns());
                    }
                }
                context.getStorageContext().getDimensions().addAll(needDimensions);
                context.getAggregations().clear();
            }
            if (context.getSQLDigest().getAggregations() != null) {
                context.getSQLDigest().getAggregations().clear();
            }
            if (context.getStorageContext().getMetrics() != null) {
                context.getStorageContext().getMetrics().clear();
            }
        }
    }

    private static void adjustForCapabilityInfluence(Candidate chosen, OlapContext olapContext) {
        CapabilityResult capability = chosen.getCapability();
        for (CapabilityResult.CapabilityInfluence inf : capability.influences) {
            if (inf instanceof CapabilityResult.DimensionAsMeasure) {
                FunctionDesc functionDesc = ((CapabilityResult.DimensionAsMeasure)inf).getMeasureFunction();
                functionDesc.setDimensionAsMetric(true);
                RealizationChooser.addToContextGroupBy(functionDesc.getSourceColRefs(), olapContext);
                olapContext.resetSQLDigest();
                olapContext.getSQLDigest();
                logger.info("Adjust DimensionAsMeasure for {}", (Object)functionDesc);
                continue;
            }
            MeasureDesc involvedMeasure = inf.getInvolvedMeasure();
            if (involvedMeasure == null) continue;
            involvedMeasure.getFunction().getMeasureType().adjustSqlDigest(involvedMeasure, olapContext.getSQLDigest());
        }
    }

    private static void addToContextGroupBy(Collection<TblColRef> colRefs, OlapContext context) {
        for (TblColRef col : colRefs) {
            if (col.isInnerColumn() || !context.belongToContextTables(col)) continue;
            context.getGroupByColumns().add(col);
        }
    }

    private static void preprocessSpecialAggregations(OlapContext context) {
        if (CollectionUtils.isEmpty(context.getAggregations())) {
            return;
        }
        Iterator<FunctionDesc> it = context.getAggregations().iterator();
        while (it.hasNext()) {
            FunctionDesc func = it.next();
            if ("GROUPING".equalsIgnoreCase(func.getExpression())) {
                it.remove();
                continue;
            }
            if (!"INTERSECT_COUNT".equalsIgnoreCase(func.getExpression())) continue;
            TblColRef col = (TblColRef)func.getColRefs().get(1);
            context.getGroupByColumns().add(col);
        }
    }

    private static void buildStorageContext(OlapContext olapContext, Set<TblColRef> dimensions, Set<FunctionDesc> metrics, Candidate candidate) {
        boolean isBatchQuery;
        boolean bl = isBatchQuery = !(olapContext.getRealization() instanceof HybridRealization) && !olapContext.getRealization().isStreaming();
        if (isBatchQuery) {
            RealizationChooser.buildBatchStorageContext(olapContext.getStorageContext(), dimensions, metrics, candidate);
        } else {
            RealizationChooser.buildHybridStorageContext(olapContext.getStorageContext(), dimensions, metrics, candidate);
        }
    }

    private static void buildBatchStorageContext(StorageContext storageContext, Set<TblColRef> dimensions, Set<FunctionDesc> metrics, Candidate candidate) {
        NLayoutCandidate layoutCandidate = (NLayoutCandidate)candidate.getCapability().getSelectedCandidate();
        layoutCandidate.setPrunedSegments(candidate.getQueryableSeg().getBatchSegments());
        if (layoutCandidate.isEmpty()) {
            storageContext.setDataSkipped(true);
            logger.info("The context({}) matches the batch-model with empty storage.", (Object)storageContext.getCtxId());
            return;
        }
        storageContext.setBatchCandidate(layoutCandidate);
        storageContext.setDimensions(dimensions);
        storageContext.setMetrics(metrics);
        storageContext.setPrunedPartitions(candidate.getPrunedPartitions());
        LayoutEntity layout = layoutCandidate.getLayoutEntity();
        logger.info("The context {}, chosen model: {}, its join: {}, layout: {}, dimensions: {}, measures: {}, segments: {}", new Object[]{storageContext.getCtxId(), layout.getModel().getAlias(), layout.getModel().getJoinsGraph(), layout.getId(), layout.getOrderedDimensions(), layout.getOrderedMeasures(), candidate.getQueryableSeg().getPrunedSegmentIds(true)});
    }

    private static void buildHybridStorageContext(StorageContext storageContext, Set<TblColRef> dimensions, Set<FunctionDesc> metrics, Candidate candidate) {
        LayoutEntity layout;
        boolean noCandidate;
        storageContext.setDimensions(dimensions);
        storageContext.setMetrics(metrics);
        storageContext.setPrunedPartitions(candidate.getPrunedPartitions());
        NLayoutCandidate streamCandidate = (NLayoutCandidate)candidate.getCapability().getSelectedStreamCandidate();
        NLayoutCandidate batchCandidate = (NLayoutCandidate)candidate.getCapability().getSelectedCandidate();
        boolean bl = noCandidate = batchCandidate.isEmpty() && streamCandidate.isEmpty();
        if (candidate.getCapability().isCapable() && noCandidate) {
            storageContext.setDataSkipped(true);
            logger.info("The context({}) matches the hybrid-model with empty storage.", (Object)storageContext.getCtxId());
            return;
        }
        if (noCandidate || RealizationChooser.differentTypeofIndex(batchCandidate, streamCandidate)) {
            throw new NoStreamingRealizationFoundException((ErrorCodeSupplier)ServerErrorCode.STREAMING_MODEL_NOT_FOUND, String.format(Locale.ROOT, MsgPicker.getMsg().getNoStreamingModelFound(), new Object[0]));
        }
        streamCandidate.setPrunedSegments(candidate.getQueryableSeg().getStreamingSegments());
        storageContext.setStreamCandidate(streamCandidate);
        batchCandidate.setPrunedSegments(candidate.getQueryableSeg().getBatchSegments());
        storageContext.setBatchCandidate(batchCandidate);
        NDataModel model = candidate.getRealization().getModel();
        if (!batchCandidate.isEmpty()) {
            layout = batchCandidate.getLayoutEntity();
            logger.info("The context {}, chosen model: {}, its join: {}, batch layout: {}, batch layout dimensions: {}, batch layout measures: {}, batch segments: {}", new Object[]{storageContext.getCtxId(), model.getAlias(), model.getJoinsGraph(), layout.getId(), layout.getOrderedDimensions(), layout.getOrderedMeasures(), candidate.getQueryableSeg().getPrunedSegmentIds(true)});
        }
        if (!streamCandidate.isEmpty()) {
            layout = streamCandidate.getLayoutEntity();
            logger.info("The context {}, chosen model: {}, its join: {}, streaming layout: {}, streaming layout dimensions: {},  streaming layout measures: {}, streaming segments: {}", new Object[]{storageContext.getCtxId(), model.getAlias(), model.getJoinsGraph(), layout.getId(), layout.getOrderedDimensions(), layout.getOrderedMeasures(), candidate.getQueryableSeg().getPrunedSegmentIds(false)});
        }
    }

    private static boolean differentTypeofIndex(NLayoutCandidate batchLayout, NLayoutCandidate streamLayout) {
        return !batchLayout.isEmpty() && !streamLayout.isEmpty() && batchLayout.isTableIndex() != streamLayout.isTableIndex();
    }

    private static void buildDimensionsAndMetrics(OlapContext context, Collection<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        SQLDigest sqlDigest = context.getSQLDigest();
        IRealization realization = context.getRealization();
        for (FunctionDesc func : sqlDigest.getAggregations()) {
            if (!func.isDimensionAsMetric() && !func.isGrouping()) {
                if ("INTERSECT_COUNT".equalsIgnoreCase(func.getExpression())) {
                    realization.getMeasures().stream().filter(measureDesc -> measureDesc.getFunction().getReturnType().equals("bitmap") && ((ParameterDesc)func.getParameters().get(0)).equals(measureDesc.getFunction().getParameters().get(0))).forEach(measureDesc -> metrics.add(measureDesc.getFunction()));
                    dimensions.add(((ParameterDesc)func.getParameters().get(1)).getColRef());
                    continue;
                }
                if ("BITMAP_UUID".equalsIgnoreCase(func.getExpression()) || "BITMAP_BUILD".equalsIgnoreCase(func.getExpression())) {
                    realization.getMeasures().stream().filter(measureDesc -> measureDesc.getFunction().getReturnType().equals("bitmap") && ((ParameterDesc)func.getParameters().get(0)).equals(measureDesc.getFunction().getParameters().get(0))).forEach(measureDesc -> metrics.add(measureDesc.getFunction()));
                    continue;
                }
                FunctionDesc aggrFuncFromDataflowDesc = realization.findAggrFunc(func);
                metrics.add(aggrFuncFromDataflowDesc);
                continue;
            }
            if (!func.isDimensionAsMetric()) continue;
            FunctionDesc funcUsedDimenAsMetric = RealizationChooser.findAggrFuncFromRealization(func, realization);
            dimensions.addAll(funcUsedDimenAsMetric.getColRefs());
            LinkedHashSet groupByCols = Sets.newLinkedHashSet((Iterable)sqlDigest.getGroupByColumns());
            groupByCols.addAll(funcUsedDimenAsMetric.getColRefs());
            sqlDigest.setGroupByColumns((List)Lists.newArrayList((Iterable)groupByCols));
        }
        if (sqlDigest.isRawQuery) {
            dimensions.addAll(sqlDigest.getAllColumns());
        } else {
            dimensions.addAll(sqlDigest.getGroupByColumns());
            dimensions.addAll(sqlDigest.getFilterColumns());
        }
    }

    private static FunctionDesc findAggrFuncFromRealization(FunctionDesc aggrFunc, IRealization realization) {
        for (MeasureDesc measure : realization.getMeasures()) {
            if (!measure.getFunction().equals((Object)aggrFunc)) continue;
            return measure.getFunction();
        }
        return aggrFunc;
    }

    private static Multimap<NDataModel, IRealization> filterQualifiedModelMap(OlapContext context) {
        HashMultimap multimap = HashMultimap.create();
        KylinConfig olapConfig = context.getOlapSchema().getConfig();
        String project = context.getOlapSchema().getProject();
        String boundedModel = context.getBoundedModelAlias();
        if (boundedModel != null) {
            logger.info("The query is bounded to a certain model({}/{}).", (Object)project, (Object)boundedModel);
        }
        String tableName = context.getFirstTableScan().getOlapTable().getTableName();
        boolean streamingEnabled = olapConfig.isStreamingEnabled();
        for (IRealization real : NProjectManager.getRealizations((KylinConfig)olapConfig, (String)project, (String)tableName)) {
            NDataModel model = real.getModel();
            if (!real.isOnline() || !context.isBoundedModel(model) || RealizationChooser.skipFusionModel(streamingEnabled, model)) continue;
            multimap.put((Object)model, (Object)real);
        }
        if (multimap.isEmpty()) {
            logger.warn("No realization found for project {} with fact table {}", (Object)project, (Object)tableName);
            return multimap;
        }
        if (!QueryContext.current().isForModeling()) {
            List noReadySegEntries = multimap.entries().stream().filter(entry -> !RealizationChooser.hasReadySegments((NDataModel)entry.getKey())).collect(Collectors.toList());
            multimap.entries().removeAll(noReadySegEntries);
        }
        Object[] modelPriorities = QueryContext.current().getModelPriorities();
        if (olapConfig.useOnlyModelsInPriorities() && modelPriorities.length > 0) {
            HashSet modelSet = Sets.newHashSet((Object[])modelPriorities);
            multimap.entries().removeIf(entry -> !modelSet.contains(StringUtils.upperCase((String)((NDataModel)entry.getKey()).getAlias())));
            List usedModels = multimap.keys().stream().map(NDataModel::getAlias).collect(Collectors.toList());
            logger.info("Use only models in priorities: {}", usedModels);
        }
        return multimap;
    }

    private static boolean skipFusionModel(boolean turnOnStreaming, NDataModel model) {
        boolean b;
        boolean bl = b = !turnOnStreaming && model.isFusionModel();
        if (b) {
            logger.debug("Fusion model({}/{}) is skipped.", (Object)model.getProject(), (Object)model.getUuid());
        }
        return b;
    }
}

