/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.util.scd2.Scd2Simplifier;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinDesc;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinTableDesc;

public class SCD2SimplificationConvertUtil {
    private SCD2SimplificationConvertUtil() {
    }

    private static void fillSimplifiedCond(@Nonnull List<SimplifiedJoinTableDesc> simplifiedJoinTableDescs, @Nonnull List<JoinTableDesc> joinTables) {
        Preconditions.checkNotNull(simplifiedJoinTableDescs);
        Preconditions.checkNotNull(joinTables);
        for (int i = 0; i < joinTables.size(); ++i) {
            JoinTableDesc joinTableDesc = joinTables.get(i);
            JoinDesc joinDesc = joinTableDesc.getJoin();
            if (Objects.isNull(joinDesc.getNonEquiJoinCondition())) continue;
            try {
                SimplifiedJoinDesc convertedJoinDesc = Scd2Simplifier.INSTANCE.simplifyScd2Conditions(joinDesc);
                SimplifiedJoinDesc responseJoinDesc = simplifiedJoinTableDescs.get(i).getSimplifiedJoinDesc();
                responseJoinDesc.setSimplifiedNonEquiJoinConditions(convertedJoinDesc.getSimplifiedNonEquiJoinConditions());
                responseJoinDesc.setForeignKey(convertedJoinDesc.getForeignKey());
                responseJoinDesc.setPrimaryKey(convertedJoinDesc.getPrimaryKey());
                continue;
            }
            catch (KylinException e) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SCD2_MODEL_UNKNOWN_EXCEPTION, new Object[]{"only support scd2 join condition"});
            }
        }
    }

    public static List<SimplifiedJoinTableDesc> simplifiedJoinTablesConvert(List<JoinTableDesc> joinTables) {
        List<Object> simplifiedJoinTableDescs;
        if (Objects.isNull(joinTables)) {
            return Collections.emptyList();
        }
        try {
            simplifiedJoinTableDescs = Arrays.asList((Object[])JsonUtil.readValue((String)JsonUtil.writeValueAsString(joinTables), SimplifiedJoinTableDesc[].class));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        SCD2SimplificationConvertUtil.fillSimplifiedCond(simplifiedJoinTableDescs, joinTables);
        return simplifiedJoinTableDescs;
    }

    public static List<JoinTableDesc> convertSimplified2JoinTables(List<SimplifiedJoinTableDesc> simplifiedJoinTableDescs) {
        List<Object> joinTableDescs;
        if (Objects.isNull(simplifiedJoinTableDescs)) {
            return Collections.emptyList();
        }
        try {
            joinTableDescs = Arrays.asList((Object[])JsonUtil.readValue((String)JsonUtil.writeValueAsString(simplifiedJoinTableDescs), JoinTableDesc[].class));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return joinTableDescs;
    }

    public static List<JoinTableDesc> deepCopyJoinTables(List<JoinTableDesc> joinTables) {
        return SCD2SimplificationConvertUtil.convertSimplified2JoinTables(SCD2SimplificationConvertUtil.simplifiedJoinTablesConvert(joinTables));
    }
}

