/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.params;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.rest.request.SegmentTimeRequest;
import org.apache.kylin.rest.service.params.FullBuildSegmentParams;

public class IncrementBuildSegmentParams
extends FullBuildSegmentParams {
    private SegmentRange<?> specifiedSegmentRange;
    private String start;
    private String end;
    private PartitionDesc partitionDesc;
    private MultiPartitionDesc multiPartitionDesc;
    private List<SegmentTimeRequest> segmentHoles;
    private String partitionColFormat;
    private List<String[]> multiPartitionValues;
    private boolean buildAllSubPartitions;

    public IncrementBuildSegmentParams(String project, String modelId, SegmentRange<?> specifiedSegmentRange, boolean needBuild) {
        super(project, modelId, needBuild);
        this.specifiedSegmentRange = specifiedSegmentRange;
    }

    public IncrementBuildSegmentParams(String project, String modelId, String start, String end, String partitionColFormat, boolean needBuild, List<String[]> multiPartitionValues) {
        super(project, modelId, needBuild);
        this.start = start;
        this.end = end;
        this.partitionColFormat = partitionColFormat;
        this.multiPartitionValues = multiPartitionValues;
    }

    public IncrementBuildSegmentParams(String project, String modelId, String start, String end, PartitionDesc partitionDesc, MultiPartitionDesc multiPartitionDesc, List<SegmentTimeRequest> segmentHoles, boolean needBuild, List<String[]> multiPartitionValues) {
        super(project, modelId, needBuild);
        this.start = start;
        this.end = end;
        this.partitionDesc = partitionDesc;
        this.segmentHoles = segmentHoles;
        this.multiPartitionValues = multiPartitionValues;
        this.multiPartitionDesc = multiPartitionDesc;
    }

    public IncrementBuildSegmentParams(String project, String modelId, String start, String end, PartitionDesc partitionDesc, MultiPartitionDesc multiPartitionDesc, String partitionColFormat, List<SegmentTimeRequest> segmentHoles, boolean needBuild, List<String[]> multiPartitionValues) {
        super(project, modelId, needBuild);
        this.start = start;
        this.end = end;
        this.partitionDesc = partitionDesc;
        this.segmentHoles = segmentHoles;
        this.partitionColFormat = partitionColFormat;
        this.multiPartitionValues = multiPartitionValues;
        this.multiPartitionDesc = multiPartitionDesc;
    }

    @Override
    public IncrementBuildSegmentParams withIgnoredSnapshotTables(Set<String> ignoredSnapshotTables) {
        this.ignoredSnapshotTables = ignoredSnapshotTables;
        return this;
    }

    @Override
    public IncrementBuildSegmentParams withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public IncrementBuildSegmentParams withPartialBuild(boolean partialBuild) {
        this.partialBuild = partialBuild;
        return this;
    }

    @Override
    public IncrementBuildSegmentParams withBatchIndexIds(List<Long> batchIndexIds) {
        this.batchIndexIds = batchIndexIds;
        return this;
    }

    @Override
    public IncrementBuildSegmentParams withYarnQueue(String yarnQueue) {
        this.yarnQueue = yarnQueue;
        return this;
    }

    @Override
    public IncrementBuildSegmentParams withTag(Object tag) {
        this.tag = tag;
        return this;
    }

    public IncrementBuildSegmentParams withBuildAllSubPartitions(boolean buildAllSubPartitions) {
        this.buildAllSubPartitions = buildAllSubPartitions;
        return this;
    }

    public List<String[]> getMultiPartitionValues() {
        ArrayList mixedMultiPartitionValues = this.multiPartitionValues;
        if (this.buildAllSubPartitions) {
            NDataModel model = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project).getDataModelDesc(this.modelId);
            MultiPartitionDesc modelMultiPartitionDesc = model.getMultiPartitionDesc();
            List<Object> allPartitionValues = Lists.newArrayList();
            if (modelMultiPartitionDesc != null) {
                allPartitionValues = modelMultiPartitionDesc.getPartitions().stream().map(MultiPartitionDesc.PartitionInfo::getValues).collect(Collectors.toList());
            }
            if (mixedMultiPartitionValues != null) {
                mixedMultiPartitionValues.addAll(allPartitionValues);
            } else {
                mixedMultiPartitionValues = allPartitionValues;
            }
        }
        return mixedMultiPartitionValues;
    }

    @Generated
    public IncrementBuildSegmentParams() {
    }

    @Generated
    public SegmentRange<?> getSpecifiedSegmentRange() {
        return this.specifiedSegmentRange;
    }

    @Generated
    public String getStart() {
        return this.start;
    }

    @Generated
    public String getEnd() {
        return this.end;
    }

    @Generated
    public PartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    @Generated
    public MultiPartitionDesc getMultiPartitionDesc() {
        return this.multiPartitionDesc;
    }

    @Generated
    public List<SegmentTimeRequest> getSegmentHoles() {
        return this.segmentHoles;
    }

    @Generated
    public String getPartitionColFormat() {
        return this.partitionColFormat;
    }

    @Generated
    public boolean isBuildAllSubPartitions() {
        return this.buildAllSubPartitions;
    }

    @Generated
    public void setSpecifiedSegmentRange(SegmentRange<?> specifiedSegmentRange) {
        this.specifiedSegmentRange = specifiedSegmentRange;
    }

    @Generated
    public void setStart(String start) {
        this.start = start;
    }

    @Generated
    public void setEnd(String end) {
        this.end = end;
    }

    @Generated
    public void setPartitionDesc(PartitionDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    @Generated
    public void setMultiPartitionDesc(MultiPartitionDesc multiPartitionDesc) {
        this.multiPartitionDesc = multiPartitionDesc;
    }

    @Generated
    public void setSegmentHoles(List<SegmentTimeRequest> segmentHoles) {
        this.segmentHoles = segmentHoles;
    }

    @Generated
    public void setPartitionColFormat(String partitionColFormat) {
        this.partitionColFormat = partitionColFormat;
    }

    @Generated
    public void setMultiPartitionValues(List<String[]> multiPartitionValues) {
        this.multiPartitionValues = multiPartitionValues;
    }

    @Generated
    public void setBuildAllSubPartitions(boolean buildAllSubPartitions) {
        this.buildAllSubPartitions = buildAllSubPartitions;
    }
}

