/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.rest.response.NDataModelResponse;

public class NDataModelOldParams
implements Serializable {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="lookups")
    private List<JoinTableDesc> joinTables;
    @JsonProperty(value="is_streaming")
    private boolean streaming;
    @JsonProperty(value="size_kb")
    private long sizeKB;
    @JsonProperty(value="input_records_count")
    private long inputRecordCnt = 0L;
    @JsonProperty(value="input_records_size")
    private long inputRecordSizeBytes = 0L;
    @JsonProperty(value="project")
    private String projectName;
    @JsonProperty(value="dimensions")
    private List<ModelDimensionDesc> dimensions;

    public void setDimensions(List<NDataModelResponse.SimplifiedNamedColumn> simplifiedDimensions) {
        if (CollectionUtils.isEmpty(simplifiedDimensions)) {
            return;
        }
        HashMap<String, Set<String>> dimCandidate = new HashMap<String, Set<String>>();
        for (NDataModelResponse.SimplifiedNamedColumn dimension : simplifiedDimensions) {
            String[] tableColumn = dimension.getAliasDotColumn().split("\\.");
            String table = tableColumn[0];
            String column = tableColumn[1];
            NDataModelOldParams.addCandidate(dimCandidate, table, column);
        }
        ArrayList<ModelDimensionDesc> dims = new ArrayList<ModelDimensionDesc>();
        for (Map.Entry dimensionEntry : dimCandidate.entrySet()) {
            ModelDimensionDesc dimension = new ModelDimensionDesc();
            dimension.setTable((String)dimensionEntry.getKey());
            dimension.setColumns(((Set)dimensionEntry.getValue()).toArray(new String[0]));
            dims.add(dimension);
        }
        this.dimensions = dims;
    }

    private static void addCandidate(Map<String, Set<String>> tblColMap, String table, String column) {
        tblColMap.computeIfAbsent(table, k -> Sets.newHashSet());
        tblColMap.get(table).add(column);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<JoinTableDesc> getJoinTables() {
        return this.joinTables;
    }

    @Generated
    public boolean isStreaming() {
        return this.streaming;
    }

    @Generated
    public long getSizeKB() {
        return this.sizeKB;
    }

    @Generated
    public long getInputRecordCnt() {
        return this.inputRecordCnt;
    }

    @Generated
    public long getInputRecordSizeBytes() {
        return this.inputRecordSizeBytes;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public List<ModelDimensionDesc> getDimensions() {
        return this.dimensions;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setJoinTables(List<JoinTableDesc> joinTables) {
        this.joinTables = joinTables;
    }

    @Generated
    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    @Generated
    public void setSizeKB(long sizeKB) {
        this.sizeKB = sizeKB;
    }

    @Generated
    public void setInputRecordCnt(long inputRecordCnt) {
        this.inputRecordCnt = inputRecordCnt;
    }

    @Generated
    public void setInputRecordSizeBytes(long inputRecordSizeBytes) {
        this.inputRecordSizeBytes = inputRecordSizeBytes;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

