/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.request;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.insensitive.ModelInsensitiveRequest;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.util.scd2.SimplifiedJoinTableDesc;
import org.apache.kylin.rest.response.LayoutRecDetailResponse;
import org.apache.kylin.rest.response.SimplifiedMeasure;
import org.apache.kylin.rest.util.SCD2SimplificationConvertUtil;

public class ModelRequest
extends NDataModel
implements ModelInsensitiveRequest {
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="start")
    private String start;
    @JsonProperty(value="end")
    private String end;
    @JsonProperty(value="simplified_measures")
    private List<SimplifiedMeasure> simplifiedMeasures = Lists.newArrayList();
    @JsonProperty(value="simplified_dimensions")
    private List<NDataModel.NamedColumn> simplifiedDimensions = Lists.newArrayList();
    @JsonProperty(value="other_columns")
    private List<NDataModel.NamedColumn> otherColumns = Lists.newArrayList();
    @JsonProperty(value="rec_items")
    private List<LayoutRecDetailResponse> recItems = Lists.newArrayList();
    @JsonProperty(value="index_plan")
    private IndexPlan indexPlan;
    @JsonProperty(value="save_only")
    private boolean saveOnly = false;
    @JsonProperty(value="with_rec_job")
    private boolean withRecJob = false;
    @JsonProperty(value="with_segment")
    private boolean withEmptySegment = true;
    @JsonProperty(value="with_model_online")
    private boolean withModelOnline = false;
    @JsonProperty(value="with_base_index")
    private boolean withBaseIndex = false;
    @JsonProperty(value="base_index_type")
    private Set<IndexEntity.Source> baseIndexType;
    @JsonProperty(value="computed_column_name_auto_adjust")
    private boolean computedColumnNameAutoAdjust = false;
    private List<SimplifiedJoinTableDesc> simplifiedJoinTableDescs;
    private transient BiFunction<TableDesc, Boolean, Collection<ColumnDesc>> columnsFetcher = TableRef::filterColumns;

    @JsonGetter(value="computed_columns")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ComputedColumnDesc> getComputedColumnDescs() {
        return this.computedColumnDescs;
    }

    @JsonSetter(value="computed_columns")
    public void setComputedColumnDescs(List<ComputedColumnDesc> computedColumnDescs) {
        this.computedColumnDescs = computedColumnDescs;
    }

    @JsonProperty(value="join_tables")
    public void setSimplifiedJoinTableDescs(List<SimplifiedJoinTableDesc> simplifiedJoinTableDescs) {
        this.simplifiedJoinTableDescs = simplifiedJoinTableDescs;
        this.setJoinTables(SCD2SimplificationConvertUtil.convertSimplified2JoinTables(simplifiedJoinTableDescs));
    }

    @JsonProperty(value="join_tables")
    public List<SimplifiedJoinTableDesc> getSimplifiedJoinTableDescs() {
        return this.simplifiedJoinTableDescs;
    }

    @JsonSetter(value="dimensions")
    public void setDimensions(List<NDataModel.NamedColumn> dimensions) {
        this.setSimplifiedDimensions(dimensions);
    }

    @JsonSetter(value="all_measures")
    public void setMeasures(List<NDataModel.Measure> inputMeasures) {
        ArrayList measures = inputMeasures != null ? inputMeasures : Lists.newArrayList();
        ArrayList simpleMeasureList = Lists.newArrayList();
        for (NDataModel.Measure measure : measures) {
            SimplifiedMeasure simplifiedMeasure = SimplifiedMeasure.fromMeasure(measure);
            simpleMeasureList.add(simplifiedMeasure);
        }
        this.setAllMeasures(measures);
        this.setSimplifiedMeasures(simpleMeasureList);
    }

    public BiFunction<TableDesc, Boolean, Collection<ColumnDesc>> getColumnsFetcher() {
        return this.columnsFetcher != null ? this.columnsFetcher : TableRef::filterColumns;
    }

    public ModelRequest() {
    }

    public ModelRequest(NDataModel dataModel) {
        super(dataModel);
        this.setSimplifiedJoinTableDescs(SCD2SimplificationConvertUtil.simplifiedJoinTablesConvert(dataModel.getJoinTables()));
    }

    private String[] toUpperCase(String[] arr) {
        if (ArrayUtils.isEmpty((Object[])arr)) {
            return arr;
        }
        return (String[])Arrays.stream(arr).map(StringUtils::toRootUpperCase).toArray(String[]::new);
    }

    public void toUpperCaseModelRequest() {
        this.setRootFactTableName(StringUtils.toRootUpperCase((String)this.getRootFactTableName()));
        this.getSimplifiedDimensions().forEach(dim -> dim.setAliasDotColumn(StringUtils.toRootUpperCase((String)dim.getAliasDotColumn())));
        if (CollectionUtils.isEmpty((Collection)this.getJoinTables())) {
            return;
        }
        this.getJoinTables().forEach(join -> {
            join.setTable(StringUtils.toRootUpperCase((String)join.getTable()));
            join.getJoin().setForeignKey(this.toUpperCase(join.getJoin().getForeignKey()));
            join.getJoin().setPrimaryKey(this.toUpperCase(join.getJoin().getPrimaryKey()));
        });
        this.getSimplifiedJoinTableDescs().forEach(join -> {
            join.setTable(StringUtils.toRootUpperCase((String)join.getTable()));
            join.getSimplifiedJoinDesc().setForeignKey(this.toUpperCase(join.getSimplifiedJoinDesc().getForeignKey()));
            join.getSimplifiedJoinDesc().setPrimaryKey(this.toUpperCase(join.getSimplifiedJoinDesc().getPrimaryKey()));
            if (CollectionUtils.isNotEmpty((Collection)join.getSimplifiedJoinDesc().getSimplifiedNonEquiJoinConditions())) {
                join.getSimplifiedJoinDesc().getSimplifiedNonEquiJoinConditions().forEach(nonEqual -> {
                    nonEqual.setForeignKey(StringUtils.toRootUpperCase((String)nonEqual.getForeignKey()));
                    nonEqual.setPrimaryKey(StringUtils.toRootUpperCase((String)nonEqual.getPrimaryKey()));
                });
            }
        });
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getStart() {
        return this.start;
    }

    @Generated
    public String getEnd() {
        return this.end;
    }

    @Generated
    public List<SimplifiedMeasure> getSimplifiedMeasures() {
        return this.simplifiedMeasures;
    }

    @Generated
    public List<NDataModel.NamedColumn> getSimplifiedDimensions() {
        return this.simplifiedDimensions;
    }

    @Generated
    public List<NDataModel.NamedColumn> getOtherColumns() {
        return this.otherColumns;
    }

    @Generated
    public List<LayoutRecDetailResponse> getRecItems() {
        return this.recItems;
    }

    @Generated
    public IndexPlan getIndexPlan() {
        return this.indexPlan;
    }

    @Generated
    public boolean isSaveOnly() {
        return this.saveOnly;
    }

    @Generated
    public boolean isWithRecJob() {
        return this.withRecJob;
    }

    @Generated
    public boolean isWithEmptySegment() {
        return this.withEmptySegment;
    }

    @Generated
    public boolean isWithModelOnline() {
        return this.withModelOnline;
    }

    @Generated
    public boolean isWithBaseIndex() {
        return this.withBaseIndex;
    }

    @Generated
    public Set<IndexEntity.Source> getBaseIndexType() {
        return this.baseIndexType;
    }

    @Generated
    public boolean isComputedColumnNameAutoAdjust() {
        return this.computedColumnNameAutoAdjust;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setStart(String start) {
        this.start = start;
    }

    @Generated
    public void setEnd(String end) {
        this.end = end;
    }

    @Generated
    public void setSimplifiedMeasures(List<SimplifiedMeasure> simplifiedMeasures) {
        this.simplifiedMeasures = simplifiedMeasures;
    }

    @Generated
    public void setSimplifiedDimensions(List<NDataModel.NamedColumn> simplifiedDimensions) {
        this.simplifiedDimensions = simplifiedDimensions;
    }

    @Generated
    public void setOtherColumns(List<NDataModel.NamedColumn> otherColumns) {
        this.otherColumns = otherColumns;
    }

    @Generated
    public void setRecItems(List<LayoutRecDetailResponse> recItems) {
        this.recItems = recItems;
    }

    @Generated
    public void setIndexPlan(IndexPlan indexPlan) {
        this.indexPlan = indexPlan;
    }

    @Generated
    public void setSaveOnly(boolean saveOnly) {
        this.saveOnly = saveOnly;
    }

    @Generated
    public void setWithRecJob(boolean withRecJob) {
        this.withRecJob = withRecJob;
    }

    @Generated
    public void setWithEmptySegment(boolean withEmptySegment) {
        this.withEmptySegment = withEmptySegment;
    }

    @Generated
    public void setWithModelOnline(boolean withModelOnline) {
        this.withModelOnline = withModelOnline;
    }

    @Generated
    public void setWithBaseIndex(boolean withBaseIndex) {
        this.withBaseIndex = withBaseIndex;
    }

    @Generated
    public void setBaseIndexType(Set<IndexEntity.Source> baseIndexType) {
        this.baseIndexType = baseIndexType;
    }

    @Generated
    public void setComputedColumnNameAutoAdjust(boolean computedColumnNameAutoAdjust) {
        this.computedColumnNameAutoAdjust = computedColumnNameAutoAdjust;
    }

    @Generated
    public void setColumnsFetcher(BiFunction<TableDesc, Boolean, Collection<ColumnDesc>> columnsFetcher) {
        this.columnsFetcher = columnsFetcher;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelRequest)) {
            return false;
        }
        ModelRequest other = (ModelRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$start = this.getStart();
        String other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        String this$end = this.getEnd();
        String other$end = other.getEnd();
        if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
            return false;
        }
        List<SimplifiedMeasure> this$simplifiedMeasures = this.getSimplifiedMeasures();
        List<SimplifiedMeasure> other$simplifiedMeasures = other.getSimplifiedMeasures();
        if (this$simplifiedMeasures == null ? other$simplifiedMeasures != null : !((Object)this$simplifiedMeasures).equals(other$simplifiedMeasures)) {
            return false;
        }
        List<NDataModel.NamedColumn> this$simplifiedDimensions = this.getSimplifiedDimensions();
        List<NDataModel.NamedColumn> other$simplifiedDimensions = other.getSimplifiedDimensions();
        if (this$simplifiedDimensions == null ? other$simplifiedDimensions != null : !((Object)this$simplifiedDimensions).equals(other$simplifiedDimensions)) {
            return false;
        }
        List<NDataModel.NamedColumn> this$otherColumns = this.getOtherColumns();
        List<NDataModel.NamedColumn> other$otherColumns = other.getOtherColumns();
        if (this$otherColumns == null ? other$otherColumns != null : !((Object)this$otherColumns).equals(other$otherColumns)) {
            return false;
        }
        List<LayoutRecDetailResponse> this$recItems = this.getRecItems();
        List<LayoutRecDetailResponse> other$recItems = other.getRecItems();
        if (this$recItems == null ? other$recItems != null : !((Object)this$recItems).equals(other$recItems)) {
            return false;
        }
        IndexPlan this$indexPlan = this.getIndexPlan();
        IndexPlan other$indexPlan = other.getIndexPlan();
        if (this$indexPlan == null ? other$indexPlan != null : !this$indexPlan.equals(other$indexPlan)) {
            return false;
        }
        if (this.isSaveOnly() != other.isSaveOnly()) {
            return false;
        }
        if (this.isWithRecJob() != other.isWithRecJob()) {
            return false;
        }
        if (this.isWithEmptySegment() != other.isWithEmptySegment()) {
            return false;
        }
        if (this.isWithModelOnline() != other.isWithModelOnline()) {
            return false;
        }
        if (this.isWithBaseIndex() != other.isWithBaseIndex()) {
            return false;
        }
        Set<IndexEntity.Source> this$baseIndexType = this.getBaseIndexType();
        Set<IndexEntity.Source> other$baseIndexType = other.getBaseIndexType();
        if (this$baseIndexType == null ? other$baseIndexType != null : !((Object)this$baseIndexType).equals(other$baseIndexType)) {
            return false;
        }
        if (this.isComputedColumnNameAutoAdjust() != other.isComputedColumnNameAutoAdjust()) {
            return false;
        }
        List<SimplifiedJoinTableDesc> this$simplifiedJoinTableDescs = this.getSimplifiedJoinTableDescs();
        List<SimplifiedJoinTableDesc> other$simplifiedJoinTableDescs = other.getSimplifiedJoinTableDescs();
        if (this$simplifiedJoinTableDescs == null ? other$simplifiedJoinTableDescs != null : !((Object)this$simplifiedJoinTableDescs).equals(other$simplifiedJoinTableDescs)) {
            return false;
        }
        List<ComputedColumnDesc> this$$getComputedColumnDescs = this.getComputedColumnDescs();
        List<ComputedColumnDesc> other$$getComputedColumnDescs = other.getComputedColumnDescs();
        return !(this$$getComputedColumnDescs == null ? other$$getComputedColumnDescs != null : !((Object)this$$getComputedColumnDescs).equals(other$$getComputedColumnDescs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        String $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : $end.hashCode());
        List<SimplifiedMeasure> $simplifiedMeasures = this.getSimplifiedMeasures();
        result = result * 59 + ($simplifiedMeasures == null ? 43 : ((Object)$simplifiedMeasures).hashCode());
        List<NDataModel.NamedColumn> $simplifiedDimensions = this.getSimplifiedDimensions();
        result = result * 59 + ($simplifiedDimensions == null ? 43 : ((Object)$simplifiedDimensions).hashCode());
        List<NDataModel.NamedColumn> $otherColumns = this.getOtherColumns();
        result = result * 59 + ($otherColumns == null ? 43 : ((Object)$otherColumns).hashCode());
        List<LayoutRecDetailResponse> $recItems = this.getRecItems();
        result = result * 59 + ($recItems == null ? 43 : ((Object)$recItems).hashCode());
        IndexPlan $indexPlan = this.getIndexPlan();
        result = result * 59 + ($indexPlan == null ? 43 : $indexPlan.hashCode());
        result = result * 59 + (this.isSaveOnly() ? 79 : 97);
        result = result * 59 + (this.isWithRecJob() ? 79 : 97);
        result = result * 59 + (this.isWithEmptySegment() ? 79 : 97);
        result = result * 59 + (this.isWithModelOnline() ? 79 : 97);
        result = result * 59 + (this.isWithBaseIndex() ? 79 : 97);
        Set<IndexEntity.Source> $baseIndexType = this.getBaseIndexType();
        result = result * 59 + ($baseIndexType == null ? 43 : ((Object)$baseIndexType).hashCode());
        result = result * 59 + (this.isComputedColumnNameAutoAdjust() ? 79 : 97);
        List<SimplifiedJoinTableDesc> $simplifiedJoinTableDescs = this.getSimplifiedJoinTableDescs();
        result = result * 59 + ($simplifiedJoinTableDescs == null ? 43 : ((Object)$simplifiedJoinTableDescs).hashCode());
        List<ComputedColumnDesc> $$getComputedColumnDescs = this.getComputedColumnDescs();
        result = result * 59 + ($$getComputedColumnDescs == null ? 43 : ((Object)$$getComputedColumnDescs).hashCode());
        return result;
    }
}

