/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.bisync;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.tool.bisync.SyncContext;
import org.apache.kylin.tool.bisync.model.ColumnDef;
import org.apache.kylin.tool.bisync.model.JoinTreeNode;
import org.apache.kylin.tool.bisync.model.MeasureDef;
import org.apache.kylin.tool.bisync.model.SyncModel;

public class SyncModelBuilder {
    private final SyncContext syncContext;

    public SyncModelBuilder(SyncContext syncContext) {
        this.syncContext = syncContext;
    }

    public SyncModel buildSourceSyncModel(List<String> dimensions, List<String> measures) {
        NDataModel dataModelDesc = this.syncContext.getDataflow().getModel();
        IndexPlan indexPlan = this.syncContext.getDataflow().getIndexPlan();
        Map<String, ColumnDef> columnDefMap = this.authColumns(dataModelDesc, this.syncContext.isAdmin(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of());
        List<MeasureDef> measureDefs = dataModelDesc.getEffectiveMeasures().values().stream().map(MeasureDef::new).collect(Collectors.toList());
        this.markHasPermissionIndexedColumnsAndMeasures(columnDefMap, measureDefs, indexPlan, (Set<String>)ImmutableSet.of(), dimensions, measures, this.syncContext.getModelElement());
        this.markComputedColumnVisibility(columnDefMap, measureDefs, this.syncContext.getKylinConfig().exposeComputedColumn());
        Set<String[]> hierarchies = this.getHierarchies(indexPlan);
        JoinTreeNode joinTree = this.generateJoinTree(dataModelDesc.getJoinTables(), dataModelDesc.getRootFactTableName());
        return this.getSyncModel(dataModelDesc, columnDefMap, measureDefs, hierarchies, joinTree);
    }

    public SyncModel buildHasPermissionSourceSyncModel(Set<String> authTables, Set<String> authColumns, List<String> dimensions, List<String> measures) {
        NDataModel dataModelDesc = this.syncContext.getDataflow().getModel();
        IndexPlan indexPlan = this.syncContext.getDataflow().getIndexPlan();
        Set<String> allAuthColumns = this.addHasPermissionCCColumn(dataModelDesc, authColumns);
        Map<String, ColumnDef> columnDefMap = this.authColumns(dataModelDesc, this.syncContext.isAdmin(), authTables, allAuthColumns);
        List<MeasureDef> measureDefs = dataModelDesc.getEffectiveMeasures().values().stream().filter(measure -> this.checkMeasurePermission(allAuthColumns, (NDataModel.Measure)measure)).map(MeasureDef::new).collect(Collectors.toList());
        this.markHasPermissionIndexedColumnsAndMeasures(columnDefMap, measureDefs, indexPlan, allAuthColumns, dimensions, measures, this.syncContext.getModelElement());
        this.markComputedColumnVisibility(columnDefMap, measureDefs, this.syncContext.getKylinConfig().exposeComputedColumn());
        Set<String> omitDbColSet = this.renameColumnName(allAuthColumns);
        Set<String[]> hierarchies = this.getHierarchies(indexPlan).stream().map(hierarchyArray -> Arrays.stream(hierarchyArray).filter(omitDbColSet::contains).collect(Collectors.toSet()).toArray(new String[0])).collect(Collectors.toSet()).stream().filter(x -> !Arrays.asList(x).isEmpty()).collect(Collectors.toSet());
        JoinTreeNode joinTree = this.generateJoinTree(dataModelDesc.getJoinTables(), dataModelDesc.getRootFactTableName());
        return this.getSyncModel(dataModelDesc, columnDefMap, measureDefs, hierarchies, joinTree);
    }

    private SyncModel getSyncModel(NDataModel dataModelDesc, Map<String, ColumnDef> columnDefMap, List<MeasureDef> measureDefs, Set<String[]> hierarchies, JoinTreeNode joinTree) {
        SyncModel syncModel = new SyncModel();
        syncModel.setColumnDefMap(columnDefMap);
        syncModel.setJoinTree(joinTree);
        syncModel.setMetrics(measureDefs);
        syncModel.setHierarchies(hierarchies);
        syncModel.setProject(this.syncContext.getProjectName());
        syncModel.setModelName(dataModelDesc.getAlias());
        syncModel.setHost(this.syncContext.getHost());
        syncModel.setPort(String.valueOf(this.syncContext.getPort()));
        return syncModel;
    }

    private boolean checkMeasurePermission(Set<String> columns, NDataModel.Measure measure) {
        Set measureColumns = measure.getFunction().getParameters().stream().filter(parameterDesc -> parameterDesc.getColRef() != null).map(parameterDesc -> parameterDesc.getColRef().getAliasDotName()).collect(Collectors.toSet());
        return columns.containsAll(measureColumns);
    }

    private void markComputedColumnVisibility(Map<String, ColumnDef> columnDefMap, List<MeasureDef> measureDefs, boolean exposeComputedColumns) {
        if (exposeComputedColumns) {
            return;
        }
        for (ColumnDef columnDef : columnDefMap.values()) {
            if (!columnDef.isComputedColumn()) continue;
            columnDef.setHidden(true);
        }
        block1: for (MeasureDef measureDef : measureDefs) {
            for (TblColRef paramColRef : measureDef.getMeasure().getFunction().getColRefs()) {
                ColumnDef columnDef = columnDefMap.get(paramColRef.getAliasDotName());
                if (columnDef == null || !columnDef.isComputedColumn()) continue;
                measureDef.setHidden(true);
                continue block1;
            }
        }
    }

    private void markHasPermissionIndexedColumnsAndMeasures(Map<String, ColumnDef> columnDefMap, List<MeasureDef> measureDefs, IndexPlan indexPlan, Set<String> authorizedCols, List<String> dimensions, List<String> measures, SyncContext.ModelElement modelElement) {
        Set<Object> colsToShow = Sets.newHashSet();
        Set<Object> measuresToShow = Sets.newHashSet();
        switch (modelElement) {
            case AGG_INDEX_COL: {
                ImmutableBitSet aggDimBitSet = indexPlan.getAllIndexes().stream().filter(index -> !index.isTableIndex()).map(IndexEntity::getDimensionBitset).reduce(ImmutableBitSet.EMPTY, ImmutableBitSet::or);
                Set tblColRefs = indexPlan.getEffectiveDimCols().entrySet().stream().filter(entry -> aggDimBitSet.get(((Integer)entry.getKey()).intValue())).map(Map.Entry::getValue).collect(Collectors.toSet());
                colsToShow = tblColRefs.stream().filter(colRef -> this.testAuthorizedCols(authorizedCols, (TblColRef)colRef)).map(TblColRef::getAliasDotName).collect(Collectors.toSet());
                measuresToShow = indexPlan.getEffectiveMeasures().values().stream().filter(measureDef -> this.testAuthorizedMeasures(authorizedCols, (NDataModel.Measure)measureDef)).map(MeasureDesc::getName).collect(Collectors.toSet());
                break;
            }
            case AGG_INDEX_AND_TABLE_INDEX_COL: {
                colsToShow = indexPlan.getEffectiveDimCols().values().stream().filter(colRef -> this.testAuthorizedCols(authorizedCols, (TblColRef)colRef)).map(TblColRef::getAliasDotName).collect(Collectors.toSet());
                measuresToShow = indexPlan.getEffectiveMeasures().values().stream().filter(measureDef -> this.testAuthorizedMeasures(authorizedCols, (NDataModel.Measure)measureDef)).map(MeasureDesc::getName).collect(Collectors.toSet());
                break;
            }
            case ALL_COLS: {
                colsToShow = indexPlan.getModel().getEffectiveDimensions().values().stream().filter(colRef -> this.testAuthorizedCols(authorizedCols, (TblColRef)colRef)).map(TblColRef::getAliasDotName).collect(Collectors.toSet());
                measuresToShow = indexPlan.getModel().getEffectiveMeasures().values().stream().filter(measureDef -> this.testAuthorizedMeasures(authorizedCols, (NDataModel.Measure)measureDef)).map(MeasureDesc::getName).collect(Collectors.toSet());
                break;
            }
            case CUSTOM_COLS: {
                HashSet dimensionSet = Sets.newHashSet(dimensions);
                colsToShow = indexPlan.getModel().getEffectiveDimensions().values().stream().filter(colRef -> this.testAuthorizedDimensions(dimensionSet, (TblColRef)colRef)).map(TblColRef::getAliasDotName).collect(Collectors.toSet());
                measuresToShow = indexPlan.getModel().getEffectiveMeasures().values().stream().map(MeasureDesc::getName).filter(measures::contains).collect(Collectors.toSet());
                break;
            }
        }
        Set<String> dimensionSet = indexPlan.getModel().getEffectiveDimensions().values().stream().map(TblColRef::getAliasDotName).collect(Collectors.toSet());
        this.showDimsAndMeasures(columnDefMap, measureDefs, colsToShow, measuresToShow, dimensionSet);
    }

    private boolean testAuthorizedCols(Set<String> authorizedCols, TblColRef colRef) {
        return this.syncContext.isAdmin() || authorizedCols.contains(colRef.getColumnWithTableAndSchema()) || authorizedCols.contains(colRef.getAliasDotName());
    }

    private boolean testAuthorizedDimensions(Set<String> dimensions, TblColRef colRef) {
        return dimensions.contains(colRef.getColumnWithTableAndSchema()) || dimensions.contains(colRef.getAliasDotName());
    }

    private boolean testAuthorizedMeasures(Set<String> authorizedCols, NDataModel.Measure measureDef) {
        return this.syncContext.isAdmin() || this.checkMeasurePermission(authorizedCols, measureDef);
    }

    private void showDimsAndMeasures(Map<String, ColumnDef> columnDefMap, List<MeasureDef> measureDefs, Set<String> colsToShow, Set<String> measuresToShow, Set<String> dimensionSet) {
        for (String colToShow : colsToShow) {
            ColumnDef colToShowDef = columnDefMap.get(colToShow);
            colToShowDef.setHidden(false);
            if (!dimensionSet.contains(colToShow)) continue;
            colToShowDef.setDimension(true);
        }
        for (MeasureDef measureDef : measureDefs) {
            if (!measuresToShow.contains(measureDef.getMeasure().getName())) continue;
            measureDef.setHidden(false);
        }
    }

    Set<String> renameColumnName(Set<String> columns) {
        return columns.stream().map(x -> {
            String[] split = x.split("\\.");
            if (split.length == 3) {
                return split[1] + "." + split[2];
            }
            return x;
        }).collect(Collectors.toSet());
    }

    private Map<String, ColumnDef> authColumns(NDataModel model, boolean isAdmin, Set<String> tables, Set<String> columns) {
        HashMap modelColsMap = Maps.newHashMap();
        for (TableRef tableRef : model.getAllTables()) {
            if (!isAdmin && !tables.contains(tableRef.getTableIdentity())) continue;
            for (TblColRef colRef : tableRef.getColumns()) {
                if (!isAdmin && !columns.contains(colRef.getAliasDotName()) && !columns.contains(colRef.getColumnWithTableAndSchema())) continue;
                ColumnDef columnDef = ColumnDef.builder().role("dimension").tableAlias(tableRef.getAlias()).columnName(colRef.getName()).columnType(colRef.getDatatype()).isHidden(true).isComputedColumn(colRef.getColumnDesc().isComputedColumn()).build();
                modelColsMap.put(colRef.getIdentity(), columnDef);
            }
        }
        model.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).forEach(namedColumn -> {
            ColumnDef columnDef = (ColumnDef)modelColsMap.get(namedColumn.getAliasDotColumn());
            if (columnDef != null) {
                columnDef.setColumnAlias(namedColumn.getName());
            }
        });
        return modelColsMap;
    }

    private Set<String> addHasPermissionCCColumn(NDataModel modelDesc, Set<String> columns) {
        HashSet allAuthColumns = Sets.newHashSet();
        allAuthColumns.addAll(columns);
        List computedColumnDescs = modelDesc.getComputedColumnDescs();
        Set<ComputedColumnDesc> computedColumnDescSet = computedColumnDescs.stream().filter(computedColumnDesc -> {
            Set<String> normalColumns = this.convertColNames(modelDesc, (ComputedColumnDesc)computedColumnDesc, Sets.newHashSet());
            return columns.containsAll(normalColumns);
        }).collect(Collectors.toSet());
        computedColumnDescSet.forEach(cc -> allAuthColumns.add(cc.getFullName()));
        return allAuthColumns;
    }

    private Set<String> convertColNames(NDataModel model, ComputedColumnDesc computedColumnDesc, Set<String> normalColumns) {
        Set<String> normalCols = this.convertCCToNormalCols(model, computedColumnDesc, normalColumns);
        HashSet newAuthColumns = Sets.newHashSet();
        model.getAllTables().forEach(tableRef -> {
            List<TblColRef> collect = tableRef.getColumns().stream().filter(column -> normalCols.contains(column.getCanonicalName())).collect(Collectors.toList());
            collect.forEach(x -> newAuthColumns.add(x.getAliasDotName()));
        });
        return newAuthColumns;
    }

    private Set<String> convertCCToNormalCols(NDataModel model, ComputedColumnDesc computedColumnDesc, Set<String> normalColumns) {
        Set ccUsedColsWithModel = ComputedColumnUtil.getCCUsedColsWithModel((NDataModel)model, (ComputedColumnDesc)computedColumnDesc);
        Set allCCols = model.getComputedColumnDescs().stream().map(ComputedColumnDesc::getIdentName).collect(Collectors.toSet());
        ccUsedColsWithModel.forEach(x -> {
            if (!allCCols.contains(x)) {
                normalColumns.add((String)x);
            }
        });
        model.getComputedColumnDescs().stream().filter(desc -> ccUsedColsWithModel.contains(desc.getIdentName())).forEach(x -> this.convertCCToNormalCols(model, (ComputedColumnDesc)x, normalColumns));
        return normalColumns;
    }

    private Set<String[]> getHierarchies(IndexPlan indexPlan) {
        HashSet hierarchies = Sets.newHashSet();
        if (indexPlan.getRuleBasedIndex() == null) {
            return hierarchies;
        }
        HashSet hierarchyNameSet = Sets.newHashSet();
        for (NAggregationGroup group : indexPlan.getRuleBasedIndex().getAggregationGroups()) {
            SelectRule rule = group.getSelectRule();
            if (rule == null) continue;
            for (Object[] objectArray : rule.hierarchyDims) {
                CharSequence[] hierarchyNames;
                String hierarchyNamesJoined;
                if (!ArrayUtils.isNotEmpty((Object[])objectArray) || hierarchyNameSet.contains(hierarchyNamesJoined = String.join((CharSequence)",", hierarchyNames = (String[])Arrays.stream(objectArray).map(id -> indexPlan.getModel().getColumnNameByColumnId(id.intValue())).toArray(String[]::new)))) continue;
                hierarchies.add(hierarchyNames);
                hierarchyNameSet.add(hierarchyNamesJoined);
            }
        }
        return hierarchies;
    }

    private JoinTreeNode generateJoinTree(List<JoinTableDesc> joinTables, String factTable) {
        HashMap<String, List<JoinTableDesc>> joinTreeMap = new HashMap<String, List<JoinTableDesc>>();
        for (JoinTableDesc joinTable : joinTables) {
            String[] fks = joinTable.getJoin().getForeignKey();
            String leftTableName = fks[0].substring(0, fks[0].indexOf(46));
            if (joinTreeMap.containsKey(leftTableName)) {
                ((List)joinTreeMap.get(leftTableName)).add(joinTable);
                continue;
            }
            LinkedList<JoinTableDesc> rightTables = new LinkedList<JoinTableDesc>();
            rightTables.add(joinTable);
            joinTreeMap.put(leftTableName, rightTables);
        }
        return this.createJoinTree(factTable, joinTreeMap);
    }

    private JoinTreeNode createJoinTree(String factTableName, Map<String, List<JoinTableDesc>> joinTreeMap) {
        JoinTableDesc factTable = new JoinTableDesc();
        int dot = factTableName.indexOf(46);
        String alias = factTableName.substring(dot + 1);
        factTable.setTable(factTableName);
        factTable.setAlias(alias);
        factTable.setKind(NDataModel.TableKind.FACT);
        return this.buildChildJoinTree(factTable, joinTreeMap);
    }

    private JoinTreeNode buildChildJoinTree(JoinTableDesc root, Map<String, List<JoinTableDesc>> joinTreeMap) {
        JoinTreeNode joinTree = new JoinTreeNode();
        joinTree.setValue(root);
        List<JoinTableDesc> childTables = joinTreeMap.get(root.getAlias());
        if (childTables != null) {
            LinkedList<JoinTreeNode> childNodes = new LinkedList<JoinTreeNode>();
            for (JoinTableDesc childTable : childTables) {
                childNodes.add(this.buildChildJoinTree(childTable, joinTreeMap));
            }
            joinTree.setChildNodes(childNodes);
        }
        return joinTree;
    }
}

